#ifndef MODULEMODIFIER_H
#define MODULEMODIFIER_H

#include <gtk/gtk.h>
#include <vector>
using namespace std;

#include "configuration.h"
#include "modifierentry.h"
#include "modifierentrylistener.h"
#include "../path.h"

class ModifierEntry;
class OverrideMenu;

class ModuleModifier : public ModifierEntryListener
{
public:
        ModuleModifier(Configuration& parent_, const Path& mod_);
        virtual ~ModuleModifier();
        GtkWidget* getWidget() {return outerBox;};
        void load();
        void unload();
        void reload();
        void rowSelect(int row, int column);
        void addButtons();

        void boolValueChanged(const string& varName, bool newValue);
        void stringValueChanged(const string& varName, string newValue);

        void cancel();
        void apply();
        void setChanged(bool ch);
        bool getChanged() {return changed;}
        
        void addOverride(const Path& module, int entryNum);
        void removeEntry(ModifierEntry* modE);
        void addEntry(const Path& module, int valueNum, bool owner);

        Path getModulePath() {
                return mod;
        }

        Configuration& parent;

private:
        // the module that this modulemodifier is configuring
        Path mod;

        GtkWidget* outerBox;
        GtkWidget* innerBox;

        vector<ModifierEntry*> contents;
        vector<GtkWidget*> extraWidgets;
        vector<OverrideMenu*> overrideMenus;
        bool changed;

        bool reloadInProgress;
};

#endif
