#ifndef PATHED_TREE_H
#define PATHED_TREE_H

#include "../common.h"
#include "../path.h"
#include <vector>
#include <string>
#include <gtk/gtk.h>
using namespace std;

class PathedTree;

#ifdef PATHED_TREE_CPP
static void row_selectf(GtkCTree* ctree, GList* node, gint column, PathedTree* data);
#endif

class PathedTreeNode
{
public:
        PathedTreeNode();
        PathedTreeNode(const PathedTreeNode *p);
        ~PathedTreeNode();
                        
        void set_widget(GtkCTreeNode *n) {
                node = n;
        }
        PathedTreeNode& add_child();
        void remove_child(int num);

        GtkCTreeNode *get_widget() {
                return node;
        }

        bool operator==(const PathedTreeNode& other) const {
                return node == other.node;
        }
        
        int child_num(const PathedTreeNode *child) const;
        int mynum() const;
        Path get_path() const;
        PathedTreeNode& get_by_path(const Path& p);
        int num_children() const {
                return children.size();
        }
        PathedTreeNode *get_by_widget(GtkCTreeNode *w);
                        
private:
        const PathedTreeNode *parent;
        GtkCTreeNode* node;
        vector<PathedTreeNode *> children;
};

class PathedTreeListener
{
public:
        virtual void node_selected(const Path& path) = 0;
};


class PathedTree
{
public:
        PathedTree();
        ~PathedTree();
        const Path& currently_selected() const {
                return mod;
        }
        GtkWidget *get_widget() {
                assert(tree);
                return tree;
        }
        void clear();
        void set_path_name(const Path& p, const string& name);
        void delete_by_path(const Path& p);
        void add_listener(PathedTreeListener *l) {
                listeners.push_back(l);
        }
        void remove_listener(PathedTreeListener *l);
                        
        void expand_all() {
                gtk_ctree_expand_recursive(GTK_CTREE(tree), root_node->get_widget());
        }
        void show_all() {
                gtk_widget_show(tree);
        }
        void select(const Path& p);
                        
#ifdef PATHED_TREE_CPP
        friend void row_selectf(GtkCTree* ctree, GList* node, gint column, PathedTree* data);
#endif
        
private:
        void row_select(GList *node);
        void notify_node_selected(const Path& path) {
                for (int i = 0; i < int(listeners.size()); i++)
                        listeners[i]->node_selected(path);
        }

private:
        GtkWidget* tree;        
        Path mod; // currently selected module
        PathedTreeNode *root_node;
private:
        vector<PathedTreeListener *> listeners;
};

#endif
