#include <gtk/gtk.h>
#include <gnome.h>
#include <iostream>
#include "config/pathed_tree.h"
#include "utils.h"
#include <unistd.h>
#include "dataset.h"
using namespace std;

GtkWidget *window;

bool debug = true;

static void destroywindow(void* a, void* b, void* t)
{
        gtk_widget_hide_all(window);
}

void create_window()
{
        window = gnome_app_new("Root-portal test thingy",
                               "Root-portal test thingy");
        gtk_signal_connect(GTK_OBJECT(window), "delete_event",
                           GTK_SIGNAL_FUNC(&destroywindow), 0);
        gtk_widget_set_usize(window, 600, 500);
}

void set_widget(GtkWidget *w)
{
        gnome_app_set_contents(GNOME_APP(window), w);
}

void show_window()
{
        gtk_widget_show_all(window);
}

void pathed_tree_test()
{
        cout << "pathed tree test....\n";
        create_window();
        PathedTree *pt = new PathedTree();
        set_widget(pt->get_widget());
        Path aa;
        pt->set_path_name(aa, "Root-Portal");
        aa.add_last(0);
        pt->set_path_name(aa, "Something");

        aa.remove_last();
        aa.add_last(1);
        pt->set_path_name(aa, "Something else");
        
        aa.remove_last();
        aa.add_last(2);
        pt->set_path_name(aa, "hmm");

        aa.remove_last();
        aa.add_last(3);
        pt->set_path_name(aa, "more stuff");

        aa.remove_last();
        aa.add_last(2);
        aa.add_last(0);
        pt->set_path_name(aa, "sub on hmm");
        
        aa.remove_last();
        aa.add_last(1);
        pt->set_path_name(aa, "this will be deleted");
        pt->delete_by_path(aa);
        
        show_window();
}

void data_set_test()
{
//          DataSet a(" hello\\, there ");
        DataSet a;
        a.addString(" hello, there ");
        cout << a.toString() << endl;
        cout << a.count() << endl;
        DataSet b(a.toString());
        cout << b.count() << endl;
        cout << b.toString() << endl;
        cout << "\"" << DataSet().toString() << "\"" << endl;
        DataSet c;
        c.addString("\\");
        cout << "\"" << c.toString() << "\"" << endl;
        DataSet d("\\\\");
        cout << "\"" << d.toString() << "\"" << endl;
        DataSet e("\\");
        cout << e.count() << endl;
}

void read_line_test()
{
        string line;
        
        line = read_line(0);
        cout << "\"" << line << "\"" << endl;

        while (line != "quit") {
                line = read_line(0, true);
                cout << "\"" << line << "\"" << endl;
                sleep(1);
        }
}

int main(int argc, char *argv[])
{
        cout << "Root portal test system\n";
        
        int test_pathed_tree = -1;
        int test_read_line = -1;
        int test_data_set = -1;
        /* this tells popt how to do magic on our variables */
        static const struct poptOption options[] = {
                { "pathed_tree", 'p', POPT_ARG_NONE, &test_pathed_tree, 0,
                  "test pathed tree module", NULL },
                { "read_line", 'l', POPT_ARG_NONE, &test_read_line, 0,
                  "test read_line function", NULL },
                { "data_set", 'd', POPT_ARG_NONE, &test_data_set, 0,
                  "test data set operations", NULL },
                { NULL, '\0', 0, NULL, 0}
        };
        
    	gnome_init_with_popt_table(PACKAGE, VERSION, argc, argv, options, 0, NULL);

        if (test_pathed_tree != -1)
                pathed_tree_test();
        if (test_read_line != -1)
                read_line_test();
        if (test_data_set != -1)
                data_set_test();
        
        if (test_pathed_tree != -1)
                gtk_main();
        
        return 0;
}
