 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_GRAPH_TYPES_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_TYPES_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AdjacencyIterator_

struct AdjacencyIterator_;       	// "projects/library/seqan/graph_types/graph_base.h"(173)

//____________________________________________________________________________
// Alphabet

template <typename T> struct Alphabet;       	// "projects/library/seqan/graph_types/graph_base.h"(83)

//____________________________________________________________________________
// Automaton

template <typename TAlphabet , typename TCargo , typename TSpec > struct Automaton;       	// "projects/library/seqan/graph_types/graph_interface.h"(41)

//____________________________________________________________________________
// AutomatonEdgeArray

template <typename TEdge, typename TAlphabet> class AutomatonEdgeArray;       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(34)

//____________________________________________________________________________
// BfsIterator_

struct BfsIterator_;       	// "projects/library/seqan/graph_types/graph_base.h"(181)

//____________________________________________________________________________
// Cargo

template <typename T> struct Cargo;       	// "projects/library/seqan/graph_types/graph_base.h"(54)

//____________________________________________________________________________
// DfsPreorder_

struct DfsPreorder_;       	// "projects/library/seqan/graph_types/graph_base.h"(189)

//____________________________________________________________________________
// Directed

template <typename TCargo , typename TSpec > struct Directed;       	// "projects/library/seqan/graph_types/graph_interface.h"(29)

//____________________________________________________________________________
// EdgeDescriptor

template <typename T> struct EdgeDescriptor;       	// "projects/library/seqan/graph_types/graph_base.h"(45)

//____________________________________________________________________________
// EdgeIdHandler

template <typename T> struct EdgeIdHandler;       	// "projects/library/seqan/graph_types/graph_base.h"(100)

//____________________________________________________________________________
// EdgeIterator_

struct EdgeIterator_;       	// "projects/library/seqan/graph_types/graph_base.h"(157)

//____________________________________________________________________________
// EdgeStump

template <typename TCargo , bool TList , bool TSource , bool TId , typename TSpec > class EdgeStump;       	// "projects/library/seqan/graph_types/graph_base.h"(203)

//____________________________________________________________________________
// EdgeType

template <typename T> struct EdgeType;       	// "projects/library/seqan/graph_types/graph_base.h"(69)

//____________________________________________________________________________
// ExactFragment

template <typename TSpec > struct ExactFragment;       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(33)

//____________________________________________________________________________
// ExactReversableFragment

template <typename TSpec > struct ExactReversableFragment;       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(37)

//____________________________________________________________________________
// Fragment

template <typename TSize , typename TSpec > class Fragment;       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(45)

//____________________________________________________________________________
// Graph

template <typename TSpec > class Graph;       	// "projects/library/seqan/graph_types/graph_interface.h"(62)

//____________________________________________________________________________
// GraphIterator

template <typename TSpec> struct GraphIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(34)

//____________________________________________________________________________
// Hmm

template <typename TAlphabet , typename TCargo , typename TSpec > struct Hmm;       	// "projects/library/seqan/graph_types/graph_interface.h"(45)

//____________________________________________________________________________
// IdManager

template <typename TIdType, typename TSpec> class IdManager;       	// "projects/library/seqan/graph_types/graph_idmanager.h"(45)
template <typename TIdType , typename TSpec > class IdManager;       	// "projects/library/seqan/graph_types/graph_base.h"(233)

//____________________________________________________________________________
// InternalAdjacencyIterator

template <typename TSpec > struct InternalAdjacencyIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(50)

//____________________________________________________________________________
// InternalBfsIterator

template <typename TSpec > struct InternalBfsIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(54)

//____________________________________________________________________________
// InternalDfsIterator

template <typename TSpec > struct InternalDfsIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(58)

//____________________________________________________________________________
// InternalEdgeIterator

template <typename TSpec > struct InternalEdgeIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(42)

//____________________________________________________________________________
// InternalMap

template <typename TContainer, unsigned int const MemberId > struct InternalMap;       	// "projects/library/seqan/graph_types/graph_property.h"(235)

//____________________________________________________________________________
// InternalOutEdgeIterator

template <typename TSpec > struct InternalOutEdgeIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(46)

//____________________________________________________________________________
// InternalPointerMap

template <typename TPropmap, TPropmap const Instance> struct InternalPointerMap;       	// "projects/library/seqan/graph_types/graph_property.h"(495)

//____________________________________________________________________________
// InternalVertexIterator

template <typename TSpec > struct InternalVertexIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(38)

//____________________________________________________________________________
// OutEdgeIterator_

struct OutEdgeIterator_;       	// "projects/library/seqan/graph_types/graph_base.h"(165)

//____________________________________________________________________________
// Tree

template <typename TCargo , typename TSpec > struct Tree;       	// "projects/library/seqan/graph_types/graph_interface.h"(37)

//____________________________________________________________________________
// TreeTag_

struct TreeTag_;       	// "projects/library/seqan/graph_types/graph_base.h"(127)

//____________________________________________________________________________
// Undirected

template <typename TCargo , typename TSpec > struct Undirected;       	// "projects/library/seqan/graph_types/graph_interface.h"(33)

//____________________________________________________________________________
// VertexIdHandler

template <typename T> struct VertexIdHandler;       	// "projects/library/seqan/graph_types/graph_base.h"(113)
template <typename T> struct VertexIdHandler;       	// "projects/library/seqan/graph_types/graph_base.h"(254)

//____________________________________________________________________________
// VertexIterator_

struct VertexIterator_;       	// "projects/library/seqan/graph_types/graph_base.h"(149)

//____________________________________________________________________________
// WithoutEdgeId_

struct WithoutEdgeId_;       	// "projects/library/seqan/graph_types/graph_base.h"(122)

//____________________________________________________________________________
// WordGraph

template <typename TSpec > struct WordGraph;       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(28)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AdjacencyIterator

typedef Tag<AdjacencyIterator_> const AdjacencyIterator;       	// "projects/library/seqan/graph_types/graph_base.h"(174)

//____________________________________________________________________________
// BfsIterator

typedef Tag<BfsIterator_> const BfsIterator;       	// "projects/library/seqan/graph_types/graph_base.h"(182)

//____________________________________________________________________________
// DfsPreorder

typedef Tag<DfsPreorder_> const DfsPreorder;       	// "projects/library/seqan/graph_types/graph_base.h"(190)

//____________________________________________________________________________
// EdgeIterator

typedef Tag<EdgeIterator_> const EdgeIterator;       	// "projects/library/seqan/graph_types/graph_base.h"(158)

//____________________________________________________________________________
// OutEdgeIterator

typedef Tag<OutEdgeIterator_> const OutEdgeIterator;       	// "projects/library/seqan/graph_types/graph_base.h"(166)

//____________________________________________________________________________
// TreeTag

typedef Tag<TreeTag_> const TreeTag;       	// "projects/library/seqan/graph_types/graph_base.h"(128)

//____________________________________________________________________________
// VertexIterator

typedef Tag<VertexIterator_> const VertexIterator;       	// "projects/library/seqan/graph_types/graph_base.h"(150)

//____________________________________________________________________________
// WithoutEdgeId

typedef Tag<WithoutEdgeId_> const WithoutEdgeId;       	// "projects/library/seqan/graph_types/graph_base.h"(123)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _addLetterToOracle

template <typename TAlphabet, typename TCargo, typename TSpec, typename TPropertyMap, typename TChar> inline void _addLetterToOracle(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TPropertyMap& supplyState, TChar const c);       	// "projects/library/seqan/graph_types/graph_impl_oracle.h"(67)

//____________________________________________________________________________
// _addStringToTrie

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeyword, typename TPos> inline void _addStringToTrie(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeyword const& str, TPos const& keywordIndex);       	// "projects/library/seqan/graph_types/graph_impl_trie.h"(71)

//____________________________________________________________________________
// _assignId

template <typename TCargo, bool TList, bool TSource, typename TSpec, typename TId2> void _assignId(EdgeStump<TCargo, TList, TSource, true, TSpec>* es, TId2 const id);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(926)
template <typename TCargo, bool TList, bool TSource, typename TSpec, typename TId2> void _assignId(EdgeStump<TCargo, TList, TSource, false, TSpec>*, TId2 const);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(937)
template <typename TCargo, bool TList, bool TSource, typename TId2> void _assignId(EdgeStump<TCargo, TList, TSource, false, TreeTag>*, TId2 const);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(947)

//____________________________________________________________________________
// _copyGraph

template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& source, Graph<Automaton<TAlphabet, TCargo, TSpec> >& dest, bool transpose);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(158)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& source, Graph<Automaton<TAlphabet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(204)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Undirected<TCargo, TSpec> > const& source, Graph<Undirected<TCargo, TSpec> >& dest, bool);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(138)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Undirected<TCargo, TSpec> > const& source, Graph<Undirected<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(184)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& source, Graph<Hmm<TAlphabet, TCargo, TSpec> >& dest, bool transp);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(148)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& source, Graph<Hmm<TAlphabet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(172)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Tree<TCargo, TSpec> > const& source, Graph<Tree<TCargo, TSpec> >& dest, bool transpose);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(177)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Tree<TCargo, TSpec> > const& source, Graph<Tree<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(218)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Directed<TCargo, TSpec> > const& source, Graph<Directed<TCargo, TSpec> >& dest, bool transpose);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(139)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Directed<TCargo, TSpec> > const& source, Graph<Directed<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(182)

//____________________________________________________________________________
// _createEdgeAttributes

template <typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Directed<TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_types/graph_drawing.h"(212)
template <typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Undirected<TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_types/graph_drawing.h"(223)
template <typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Tree<void, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_types/graph_drawing.h"(234)
template <typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Tree<TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_types/graph_drawing.h"(245)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_types/graph_drawing.h"(267)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Automaton<TAlphabet, TCargo, WordGraph<TSpec> > > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_types/graph_drawing.h"(289)

//____________________________________________________________________________
// _createEmptyEdgeAttributes

template <typename TSpec, typename TEdgeAttributes> inline void _createEmptyEdgeAttributes(Graph<TSpec> const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_types/graph_drawing.h"(193)

//____________________________________________________________________________
// _createNodeAttributes

template <typename TSpec, typename TNodeAttributes> inline void _createNodeAttributes(Graph<TSpec> const& g, TNodeAttributes& nodeMap);       	// "projects/library/seqan/graph_types/graph_drawing.h"(142)
template <typename TSpec, typename TNodeAttributes, typename TNameMap> inline void _createNodeAttributes(Graph<TSpec> const& g, TNodeAttributes& nodeMap, TNameMap const& nameMap);       	// "projects/library/seqan/graph_types/graph_drawing.h"(169)

//____________________________________________________________________________
// _createTrieNodeAttributes

template <typename TAlphabet, typename TCargo, typename TSpec, typename TNodeMap> inline void _createTrieNodeAttributes(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, String<String<unsigned int> > pos, TNodeMap& nodeMap);       	// "projects/library/seqan/graph_types/graph_drawing.h"(105)

//____________________________________________________________________________
// _createVertices

template <typename TSpec, typename TVertexDescriptor> inline void _createVertices(Graph<TSpec>& g, TVertexDescriptor const maxId);       	// "projects/library/seqan/graph_types/graph_interface.h"(392)

//____________________________________________________________________________
// _getEdgeIdManager

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(143)
template <typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Undirected<TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(124)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(134)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> const & _getEdgeIdManager(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(133)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> & _getEdgeIdManager(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(141)
template <typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Directed<TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(124)

//____________________________________________________________________________
// _getId

template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, true, TSpec> const>::Type _getId(EdgeStump<TCargo, TList, TSource, true, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(956)
template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, true, TSpec> >::Type _getId(EdgeStump<TCargo, TList, TSource, true, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(966)
template <typename TCargo, bool TList, bool TSource> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TreeTag> const>::Type _getId(EdgeStump<TCargo, TList, TSource, false, TreeTag> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(976)
template <typename TCargo, bool TList, bool TSource> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TreeTag> >::Type _getId(EdgeStump<TCargo, TList, TSource, false, TreeTag>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(987)
template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TSpec> >::Type _getId(EdgeStump<TCargo, TList, TSource, false, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(998)
template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TSpec> >::Type _getId(EdgeStump<TCargo, TList, TSource, false, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(1009)
template <typename TId> inline TId _getId(TId const id);       	// "projects/library/seqan/graph_types/graph_interface.h"(381)

//____________________________________________________________________________
// _getInfinity

template <typename T> inline T _getInfinity();       	// "projects/library/seqan/graph_types/graph_interface.h"(342)
template <> inline double _getInfinity();       	// "projects/library/seqan/graph_types/graph_interface.h"(352)

//____________________________________________________________________________
// _getInfinityDistance

template <typename TWeightMap> inline typename Value<TWeightMap>::Type _getInfinityDistance(TWeightMap const&);       	// "projects/library/seqan/graph_types/graph_interface.h"(361)
template <typename T> inline T _getInfinityDistance();       	// "projects/library/seqan/graph_types/graph_interface.h"(371)

//____________________________________________________________________________
// _getVertexIdManager

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(132)
template <typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Undirected<TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(113)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(123)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> const & _getVertexIdManager(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(117)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> & _getVertexIdManager(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(125)
template <typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Directed<TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(113)

//____________________________________________________________________________
// _getVertexString

template <typename TAlphabet, typename TCargo, typename TSpec> inline String<AutomatonEdgeArray<typename EdgeType<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type, TAlphabet> >& _getVertexString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(121)
template <typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Undirected<TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(102)
template <typename TAlphabet, typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(112)
template <typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Tree<TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(106)
template <typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Directed<TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(102)

//____________________________________________________________________________
// _goNextInternal

template <typename TGraph, typename TSpec> inline void _goNextInternal(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(269)

//____________________________________________________________________________
// _goPreviousInternal

template <typename TGraph, typename TSpec> inline void _goPreviousInternal(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(340)

//____________________________________________________________________________
// _loadSequences

template <typename TPath, typename TStringSet, typename TNames> inline unsigned int _loadSequences(TPath const& in_path, TStringSet& origStrSet, TNames& names);       	// "projects/library/seqan/graph_types/graph_utility_parsing.h"(43)

//____________________________________________________________________________
// _markRootVertex

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const& v, TAttributes& str);       	// "projects/library/seqan/graph_types/graph_drawing.h"(54)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Directed<TCargo, TSpec> > const&, TVertexDescriptor const&, TAttributes&);       	// "projects/library/seqan/graph_types/graph_drawing.h"(68)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Undirected<TCargo, TSpec> > const&, TVertexDescriptor const&, TAttributes&);       	// "projects/library/seqan/graph_types/graph_drawing.h"(79)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const& v, TAttributes& str);       	// "projects/library/seqan/graph_types/graph_drawing.h"(91)

//____________________________________________________________________________
// _rebuildParentMap

template <typename TCargo, typename TSpec> inline void _rebuildParentMap(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(150)

//____________________________________________________________________________
// _writeEdgeType

template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(413)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Directed<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(425)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Undirected<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(437)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Tree<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(449)

//____________________________________________________________________________
// _writeGraphFooter

template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Directed<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(320)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Undirected<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(331)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Tree<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(342)
template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(354)

//____________________________________________________________________________
// _writeGraphType

template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(365)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Directed<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(377)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Undirected<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(389)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Tree<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(401)

//____________________________________________________________________________
// addChild

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addChild(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor parent);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(894)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addChild(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TCargo const cargo);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(909)

//____________________________________________________________________________
// addEdge

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(398)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel, typename TEdgeCargo> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label, TEdgeCargo const cargo);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(420)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type addEdge(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor source, TVertexDescriptor target);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(392)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCargo2> inline typename EdgeDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type addEdge(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo2 const cargo);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(429)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(398)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCargo2> inline typename EdgeDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo2 const cargo);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(411)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(458)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child, TCargo const cargo);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(487)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type addEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, String<TAlphabet> const& label);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(101)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TChars> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type addEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, TChars const* chars);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(128)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TLabel, typename TEdgeCargo> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type addEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label, TEdgeCargo const cargo);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(142)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Directed<TCargo, TSpec> > >::Type addEdge(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(547)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Directed<TCargo, TSpec> > >::Type addEdge(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo const cargo);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(576)

//____________________________________________________________________________
// addEdges

template <typename TSpec, typename TEdgeArray, typename TSize> inline void addEdges(Graph<TSpec>& dest, TEdgeArray const & edges, TSize const size);       	// "projects/library/seqan/graph_types/graph_interface.h"(421)

//____________________________________________________________________________
// addVertex

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(362)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type addVertex(Graph<Undirected<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(360)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, bool silent);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(310)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(333)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEmission> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, String<TEmission> const& emis);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(344)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEmission> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TEmission const& emis, bool silent);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(370)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addVertex(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(408)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Directed<TCargo, TSpec> > >::Type addVertex(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(477)

//____________________________________________________________________________
// assignBeginState

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignBeginState(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(630)

//____________________________________________________________________________
// assignCargo

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec, typename TCargo2> inline void assignCargo(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es, TCargo2 const& t);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(451)
template <bool TList, bool TSource, bool TId, typename TSpec, typename TCargo2> inline void assignCargo(EdgeStump<void, TList, TSource, TId, TSpec>*, TCargo2 const&);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(462)

//____________________________________________________________________________
// assignEmissionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TEmisProb> inline void assignEmissionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const state, TAlphabet const symbol, TEmisProb const eProb);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(942)

//____________________________________________________________________________
// assignEndState

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignEndState(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(655)

//____________________________________________________________________________
// assignNextS

template <typename TCargo, bool TId, typename TSpec> inline void assignNextS(EdgeStump<TCargo, true, true, TId, TSpec>* es, EdgeStump<TCargo, true, true, TId, TSpec>* es2);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(807)
template <typename TCargo, bool TId, typename TSpec> inline void assignNextS(EdgeStump<TCargo, true, false, TId, TSpec>*, EdgeStump<TCargo, true, false, TId, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(819)

//____________________________________________________________________________
// assignNextT

template <typename TCargo, bool TSource, bool TId, typename TSpec> inline void assignNextT(EdgeStump<TCargo, true, TSource, TId, TSpec>* es, EdgeStump<TCargo, true, TSource, TId, TSpec>* es2);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(717)

//____________________________________________________________________________
// assignProperty

template <typename TPropertyMap, typename TDescriptor, typename TValue> inline void assignProperty(TPropertyMap& pm, TDescriptor const d, TValue const val);       	// "projects/library/seqan/graph_types/graph_property.h"(135)
template <typename T1, typename T2, typename TEdgeDescriptor, typename TValue> inline void assignProperty(InternalMap<Pair<T1, T2>, 1>&, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph_types/graph_property.h"(318)
template <typename T1, typename T2, typename TEdgeDescriptor, typename TValue> inline void assignProperty(InternalMap<Pair<T1, T2>, 2>&, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph_types/graph_property.h"(330)
template <typename T, typename TEdgeDescriptor, typename TValue> inline void assignProperty(InternalMap<T, 0>&, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph_types/graph_property.h"(342)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline void assignProperty(InternalPointerMap<TValue TClass::*, TPMember>&, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph_types/graph_property.h"(550)
template <typename TClass, typename TValue, typename TEdgeDescriptor> inline void assignProperty(TValue TClass:: * ptr_to_member, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph_types/graph_property.h"(665)

//____________________________________________________________________________
// assignRoot

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(715)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignRoot(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(747)

//____________________________________________________________________________
// assignSilentStatus

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignSilentStatus(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex, bool const silent);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(971)

//____________________________________________________________________________
// assignSource

template <typename TCargo, bool TList, bool TId, typename TSpec, typename TVertexDescriptor> inline void assignSource(EdgeStump<TCargo, TList, true, TId, TSpec>* es, TVertexDescriptor const s);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(578)
template <typename TCargo, bool TList, bool TId, typename TSpec, typename TVertexDescriptor> inline void assignSource(EdgeStump<TCargo, TList, false, TId, TSpec>*, TVertexDescriptor const);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(589)

//____________________________________________________________________________
// assignTarget

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec, typename TVertexDescriptor> inline void assignTarget(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es, TVertexDescriptor const t);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(487)

//____________________________________________________________________________
// assignTransitionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TTransProb> inline void assignTransitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const state1, TVertexDescriptor const state2, TTransProb const t);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(844)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor, typename TTransProb> inline void assignTransitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >&, TEdgeDescriptor e, TTransProb const t);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(859)

//____________________________________________________________________________
// atBegin

template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(266)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(206)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(196)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(199)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(616)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(626)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(636)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(647)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(657)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(224)

//____________________________________________________________________________
// atEnd

template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(311)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(226)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(213)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(216)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(717)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(727)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(737)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(747)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(757)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(248)

//____________________________________________________________________________
// beginState

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type& beginState(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(677)

//____________________________________________________________________________
// canParseString

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline bool canParseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const & g, TVertexDescriptor const vertex, TCharacters const & chars);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(942)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline bool canParseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const & g, TVertexDescriptor const vertex, TCharacters const * chars);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(955)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TCharacters> inline bool canParseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > & g, TCharacters const & chars);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(968)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TCharacters> inline bool canParseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > & g, TCharacters const * chars);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(977)

//____________________________________________________________________________
// cargo

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> const>::Type& cargo(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(392)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type& cargo(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(402)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> >::Type cargo(EdgeStump<void, TList, TSource, TId, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(413)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> const>::Type cargo(EdgeStump<void, TList, TSource, TId, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(424)

//____________________________________________________________________________
// childVertex

template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type childVertex(Graph<Tree<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(1000)

//____________________________________________________________________________
// clear

template <typename TAlphabet, typename TCargo, typename TSpec> inline void clear(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(295)
template <typename TCargo, typename TSpec> inline void clear(Graph<Undirected<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(305)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clear(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(266)
template <typename TCargo, typename TSpec> inline void clear(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(338)
template <typename TCargo, typename TSpec> inline void clear(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(352)

//____________________________________________________________________________
// clearEdges

template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(271)
template <typename TCargo, typename TSpec> inline void clearEdges(Graph<Undirected<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(249)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearEdges(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(238)
template <typename TCargo, typename TSpec> inline void clearEdges(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(300)
template <typename TCargo, typename TSpec> inline void clearEdges(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(301)

//____________________________________________________________________________
// clearVertices

template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearVertices(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(283)
template <typename TCargo, typename TSpec> inline void clearVertices(Graph<Undirected<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(293)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearVertices(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(248)
template <typename TCargo, typename TSpec> inline void clearVertices(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(325)
template <typename TCargo, typename TSpec> inline void clearVertices(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(331)

//____________________________________________________________________________
// collectLeaves

template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TGroup> inline void collectLeaves(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const root, TGroup& group);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(1060)

//____________________________________________________________________________
// createOracle

template <typename TAlphabet, typename TCargo, typename TSpec, typename TText> inline void createOracle(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TText const text);       	// "projects/library/seqan/graph_types/graph_impl_oracle.h"(113)

//____________________________________________________________________________
// createOracleOnReverse

template <typename TAlphabet, typename TCargo, typename TSpec, typename TText> inline void createOracleOnReverse(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TText const text);       	// "projects/library/seqan/graph_types/graph_impl_oracle.h"(146)

//____________________________________________________________________________
// createRoot

template <typename TAlphabet, typename TCargo, typename TSpec> inline void createRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(688)
template <typename TCargo, typename TSpec> inline void createRoot(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(762)

//____________________________________________________________________________
// createSetOracle

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeywords> inline void createSetOracle(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeywords const& keywords);       	// "projects/library/seqan/graph_types/graph_impl_oracle.h"(170)

//____________________________________________________________________________
// createSetSuffixTrie

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TTexts> inline void createSetSuffixTrie(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TTexts const& texts);       	// "projects/library/seqan/graph_types/graph_impl_trie.h"(234)

//____________________________________________________________________________
// createSuffixTrie

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TText> inline void createSuffixTrie(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TText const& text);       	// "projects/library/seqan/graph_types/graph_impl_trie.h"(210)

//____________________________________________________________________________
// createTrie

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeywords> inline void createTrie(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeywords const& keywords);       	// "projects/library/seqan/graph_types/graph_impl_trie.h"(126)

//____________________________________________________________________________
// createTrieOnReverse

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeywords> inline void createTrieOnReverse(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeywords const& keywords);       	// "projects/library/seqan/graph_types/graph_impl_trie.h"(164)

//____________________________________________________________________________
// degree

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type degree(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(352)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type degree(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(351)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type degree(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(299)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type degree(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(398)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type degree(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(455)

//____________________________________________________________________________
// emissionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline TCargo& emissionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const state, TAlphabet const symbol);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(912)

//____________________________________________________________________________
// empty

template <typename TAlphabet, typename TCargo, typename TSpec> inline bool empty(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(261)
template <typename TCargo, typename TSpec> inline bool empty(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(239)
template <typename TAlphabet, typename TCargo, typename TSpec> inline bool empty(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(228)
template <typename TCargo, typename TSpec> inline bool empty(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(290)
template <typename TCargo, typename TSpec> inline bool empty(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(279)

//____________________________________________________________________________
// endState

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type& endState(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(696)

//____________________________________________________________________________
// findEdge

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type findEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v, TLabel const c);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(607)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type findEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const v, TLabel const c);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(621)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type findEdge(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(715)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type findEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(500)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type findEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(666)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Directed<TCargo, TSpec> > >::Type findEdge(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(906)

//____________________________________________________________________________
// fragmentBegin

template <typename TSize, typename TSpec, typename TVal> inline TSize& fragmentBegin(Fragment<TSize, TSpec> const& f, TVal const seqId);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(153)

//____________________________________________________________________________
// fragmentLength

template <typename TSize, typename TSpec, typename TVal> inline TSize& fragmentLength(Fragment<TSize, TSpec> const& f, TVal const);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(165)
template <typename TSize, typename TSpec> inline TSize& fragmentLength(Fragment<TSize, TSpec> const& f);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(175)

//____________________________________________________________________________
// getAdjacencyMatrix

template <typename TAlphabet, typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(572)
template <typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Undirected<TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(678)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(489)
template <typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Tree<TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(635)
template <typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Directed<TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(852)

//____________________________________________________________________________
// getBeginState

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type getBeginState(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(715)

//____________________________________________________________________________
// getCargo

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> const>::Type& getCargo(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(336)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type& getCargo(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(346)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> const>::Type getCargo(EdgeStump<void, TList, TSource, TId, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(356)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> >::Type getCargo(EdgeStump<void, TList, TSource, TId, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(367)

//____________________________________________________________________________
// getEmissionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline TCargo getEmissionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const state, TAlphabet const symbol);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(884)

//____________________________________________________________________________
// getEndState

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type getEndState(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(734)

//____________________________________________________________________________
// getIdLowerBound

template <typename TIdType, typename TSpec> inline typename Value<IdManager<TIdType, TSpec> >::Type getIdLowerBound(IdManager<TIdType, TSpec> const& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(252)
template <typename TSpec> inline typename Value<IdManager<void, TSpec> >::Type getIdLowerBound(IdManager<void, TSpec> const&);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(429)

//____________________________________________________________________________
// getIdUpperBound

template <typename TIdType, typename TSpec> inline typename Value<IdManager<TIdType, TSpec> >::Type getIdUpperBound(IdManager<TIdType, TSpec> const& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(231)
template <typename TSpec> inline typename Value<IdManager<void, TSpec> >::Type getIdUpperBound(IdManager<void, TSpec> const& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(417)

//____________________________________________________________________________
// getNextS

template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, true, TId, TSpec>* getNextS(EdgeStump<TCargo, true, true, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(895)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, false, TId, TSpec>* getNextS(EdgeStump<TCargo, true, false, TId, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(905)

//____________________________________________________________________________
// getNextT

template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* getNextT(EdgeStump<TCargo, true, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(771)
template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* getNextT(EdgeStump<TCargo, true, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(782)

//____________________________________________________________________________
// getNil

template <typename T> inline T getNil(T *);       	// "projects/library/seqan/graph_types/graph_interface.h"(318)
template <typename T> inline T getNil();       	// "projects/library/seqan/graph_types/graph_interface.h"(327)

//____________________________________________________________________________
// getProjectedPosition

template <typename TSize, typename TSpec, typename TId1, typename TPosition1, typename TId2, typename TPosition2> inline void getProjectedPosition(Fragment<TSize, ExactFragment<TSpec> > const& f, TId1 const seqId, TPosition1 const pos, TId2& seqId2, TPosition2& pos2);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(189)
template <typename TSize, typename TSpec, typename TId1, typename TPosition1, typename TId2, typename TPosition2> inline void getProjectedPosition(Fragment<TSize, ExactReversableFragment<TSpec> > const& f, TId1 const seqId, TPosition1 const pos, TId2& seqId2, TPosition2& pos2);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(218)

//____________________________________________________________________________
// getProperty

template <typename TPropertyMap, typename TDescriptor> inline typename GetValue<TPropertyMap const>::Type getProperty(TPropertyMap const& pm, TDescriptor const d);       	// "projects/library/seqan/graph_types/graph_property.h"(206)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> >::Type getProperty(InternalMap<Pair<T1, T2>, 1> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(419)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> >::Type getProperty(InternalMap<Pair<T1, T2>, 1>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(430)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> >::Type getProperty(InternalMap<Pair<T1, T2>, 2> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(441)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> >::Type getProperty(InternalMap<Pair<T1, T2>, 2>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(452)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> >::Type getProperty(InternalMap<T, 0> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(463)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> >::Type getProperty(InternalMap<T, 0>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(474)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> >::Type getProperty(InternalPointerMap<TValue TClass::*, TPMember> const&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_property.h"(583)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> >::Type getProperty(InternalPointerMap<TValue TClass::*, TPMember>&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_property.h"(595)
template <typename TClass, typename TValue, typename TEdgeDescriptor> inline TValue getProperty(TValue TClass:: * const ptr_to_member, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_property.h"(688)

//____________________________________________________________________________
// getRoot

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type getRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(765)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type getRoot(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(782)

//____________________________________________________________________________
// getSource

template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> const>::Type getSource(EdgeStump<TCargo, TList, true, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(657)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> >::Type getSource(EdgeStump<TCargo, TList, true, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(667)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> const>::Type getSource(EdgeStump<TCargo, TList, false, TId, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(677)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> >::Type getSource(EdgeStump<TCargo, TList, false, TId, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(688)

//____________________________________________________________________________
// getSuccessor

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TChar> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type getSuccessor(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor vertex, TChar const c);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(827)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type getSuccessor(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > const& g, TVertexDescriptor vertex, TCharacters const& chars);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(210)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type getSuccessor(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > const& g, TVertexDescriptor vertex, TCharacters const* chars);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(231)

//____________________________________________________________________________
// getTarget

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> const>::Type getTarget(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(541)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type getTarget(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(551)

//____________________________________________________________________________
// getTransitionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline TCargo getTransitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const state1, TVertexDescriptor const state2);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(761)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline TCargo getTransitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> > const&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(776)

//____________________________________________________________________________
// getValue

template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(186)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(166)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(164)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(166)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(490)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(500)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(510)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(520)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(530)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(184)

//____________________________________________________________________________
// goBegin

template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(288)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(216)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(205)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(208)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(667)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(677)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(687)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(697)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(707)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(235)

//____________________________________________________________________________
// goEnd

template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(332)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(236)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(221)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(224)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(767)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(777)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(787)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(798)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(808)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(258)

//____________________________________________________________________________
// goNext

template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(354)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(246)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(229)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(232)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(818)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(828)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(838)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(848)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(861)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(291)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(301)

//____________________________________________________________________________
// goPrevious

template <typename TGraph, typename TSpec> inline void goPrevious(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(398)
template <typename TGraph, typename TSpec> inline void goPrevious(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(279)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(902)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(916)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(930)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(944)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(967)
template <typename TGraph, typename TSpec> inline void goPrevious(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(366)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(376)

//____________________________________________________________________________
// hostGraph

template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(243)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(196)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(188)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(191)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(606)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(214)

//____________________________________________________________________________
// idCount

template <typename TIdType, typename TSpec> inline typename Value<IdManager<TIdType, TSpec> >::Type idCount(IdManager<TIdType, TSpec> const& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(276)
template <typename TSpec> inline typename Value<IdManager<void, TSpec> >::Type idCount(IdManager<void, TSpec> const& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(440)

//____________________________________________________________________________
// idInUse

template <typename TIdType, typename TSpec, typename TId> inline bool idInUse(IdManager<TIdType, TSpec> const& idm, TId const id);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(299)
template <typename TSpec, typename TId> inline bool idInUse(IdManager<void, TSpec> const&, TId const);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(452)

//____________________________________________________________________________
// inDegree

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type inDegree(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(325)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type inDegree(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(339)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type inDegree(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(288)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type inDegree(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(371)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type inDegree(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(413)

//____________________________________________________________________________
// isLeaf

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isLeaf(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor v);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(816)

//____________________________________________________________________________
// isReversed

template <typename TSize, typename TSpec> inline bool isReversed(Fragment<TSize, ExactReversableFragment<TSpec> > const& f);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(244)

//____________________________________________________________________________
// isRoot

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor v);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(792)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isRoot(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor v);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(793)

//____________________________________________________________________________
// isSilent

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isSilent(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(1017)

//____________________________________________________________________________
// label

template <typename TSize, typename TSpec, typename TStringSet, typename TVal> inline typename Infix<typename Value<TStringSet>::Type>::Type label(Fragment<TSize, TSpec> const& f, TStringSet& str, TVal const seqId);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(129)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Alphabet<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> > >::Type label(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1151)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Alphabet<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> > >::Type label(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(459)

//____________________________________________________________________________
// nextS

template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, true, TId, TSpec>* & nextS(EdgeStump<TCargo, true, true, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(842)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, true, TId, TSpec>* & nextS(EdgeStump<TCargo, true, true, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(852)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, false, TId, TSpec>* nextS(EdgeStump<TCargo, true, false, TId, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(861)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, false, TId, TSpec>* nextS(EdgeStump<TCargo, true, false, TId, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(872)

//____________________________________________________________________________
// nextT

template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* & nextT(EdgeStump<TCargo, true, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(739)
template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* & nextT(EdgeStump<TCargo, true, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(749)

//____________________________________________________________________________
// numChildren

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numChildren(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(864)

//____________________________________________________________________________
// numEdges

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type numEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(241)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type numEdges(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(219)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type numEdges(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(208)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numEdges(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(256)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type numEdges(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(242)

//____________________________________________________________________________
// numTreeEdges

template <typename TCargo, typename TSpec> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numTreeEdges(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(840)

//____________________________________________________________________________
// numVertices

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type numVertices(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(251)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type numVertices(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(229)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type numVertices(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(218)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numVertices(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(280)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type numVertices(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(263)

//____________________________________________________________________________
// obtainId

template <typename TIdType, typename TSpec> inline typename Value<IdManager<TIdType, TSpec> >::Type obtainId(IdManager<TIdType, TSpec>& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(142)
template <typename TSpec> inline typename Value<IdManager<void, TSpec> >::Type obtainId(IdManager<void, TSpec>& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(385)

//____________________________________________________________________________
// operator!=

template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(444)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(324)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(280)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(283)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1069)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1081)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1093)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1105)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1117)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(428)

//____________________________________________________________________________
// operator*

template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(218)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(186)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(180)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(183)
template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(596)
template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(204)

//____________________________________________________________________________
// operator++

template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(365)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(376)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(256)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(267)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(249)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(258)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(252)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(261)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(879)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(890)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(317)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(328)

//____________________________________________________________________________
// operator--

template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(409)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(420)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(289)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(300)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(985)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(996)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(392)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(403)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename TSpec> inline TStream & operator<< (TStream & target, Graph<TSpec> const& source);       	// "projects/library/seqan/graph_types/graph_interface.h"(443)

//____________________________________________________________________________
// operator==

template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(433)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(313)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(269)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(272)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1009)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1021)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1033)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1045)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1057)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(416)

//____________________________________________________________________________
// outDegree

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type outDegree(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(306)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type outDegree(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(316)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type outDegree(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(277)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type outDegree(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(349)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type outDegree(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(377)

//____________________________________________________________________________
// parentVertex

template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type parentVertex(Graph<Tree<TCargo, TSpec> > const& g, typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type const edge);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(1024)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type parentVertex(Graph<Tree<TCargo, TSpec> > const& g, typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type const v);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(1035)

//____________________________________________________________________________
// parseString

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TIterator> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TIterator & beginIt, TIterator const & endIt);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(867)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TIterator> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TIterator const & beginIt, TIterator const & endIt);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(887)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TCharacters const& chars);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(900)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TCharacters const* chars);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(912)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TIterator> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type parseString(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > const& g, TVertexDescriptor const vertex, TIterator beginIt, TIterator endIt);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(244)

//____________________________________________________________________________
// property

template <typename TPropertyMap, typename TDescriptor> inline typename Reference<TPropertyMap>::Type property(TPropertyMap& pm, TDescriptor const d);       	// "projects/library/seqan/graph_types/graph_property.h"(165)
template <typename TPropertyMap, typename TDescriptor> inline typename Reference<TPropertyMap const>::Type property(TPropertyMap const& pm, TDescriptor const d);       	// "projects/library/seqan/graph_types/graph_property.h"(176)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> >::Type& property(InternalMap<Pair<T1, T2>, 2>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(353)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> const>::Type& property(InternalMap<Pair<T1, T2>, 2> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(364)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> >::Type& property(InternalMap<Pair<T1, T2>, 1>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(375)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> const>::Type& property(InternalMap<Pair<T1, T2>, 1> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(386)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> >::Type& property(InternalMap<T, 0>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(397)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> const>::Type& property(InternalMap<T, 0> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(408)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> >::Type& property(InternalPointerMap<TValue TClass::*, TPMember>&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_property.h"(561)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> const>::Type& property(InternalPointerMap<TValue TClass::*, TPMember> const&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_property.h"(572)
template <typename TClass, typename TValue, typename TEdgeDescriptor> inline TValue& property(TValue TClass:: * const ptr_to_member, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_property.h"(677)

//____________________________________________________________________________
// releaseAll

template <typename TIdType, typename TSpec> inline void releaseAll(IdManager<TIdType, TSpec>& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(209)
template <typename TSpec> inline void releaseAll(IdManager<void, TSpec>& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(407)

//____________________________________________________________________________
// releaseId

template <typename TIdType, typename TSpec, typename TId> inline void releaseId(IdManager<TIdType, TSpec>& idm, TId const id);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(177)
template <typename TSpec, typename TId> inline void releaseId(IdManager<void, TSpec>& idm, TId const);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(397)

//____________________________________________________________________________
// removeAllChildren

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeAllChildren(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(967)

//____________________________________________________________________________
// removeChild

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeChild(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(940)

//____________________________________________________________________________
// removeEdge

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline void removeEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(441)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(454)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(447)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Undirected<TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(535)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(423)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(434)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(503)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Tree<TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(539)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, String<TAlphabet> const& label);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(156)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(614)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Directed<TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(650)

//____________________________________________________________________________
// removeInEdges

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(493)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(644)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(456)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(568)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(730)

//____________________________________________________________________________
// removeOutEdges

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(470)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(626)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(445)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(550)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(699)

//____________________________________________________________________________
// removeVertex

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(381)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(377)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(385)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(433)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(507)

//____________________________________________________________________________
// resizeEdgeMap

template <typename TSpec, typename TPropertyMap> inline void resizeEdgeMap(Graph<TSpec> const& g, TPropertyMap& pm);       	// "projects/library/seqan/graph_types/graph_property.h"(101)
template <typename TSpec, typename TContainer, unsigned int const MemberId> inline void resizeEdgeMap(Graph<TSpec> const&, InternalMap<TContainer, MemberId>&);       	// "projects/library/seqan/graph_types/graph_property.h"(299)
template <typename TSpec, typename TContainer, unsigned int const MemberId> inline void resizeEdgeMap(Graph<TSpec>&, InternalMap<TContainer, MemberId>&);       	// "projects/library/seqan/graph_types/graph_property.h"(308)
template <typename TSpec, typename TPropmap, TPropmap const Instance> inline void resizeEdgeMap(Graph<TSpec>&, InternalPointerMap<TPropmap, Instance>&);       	// "projects/library/seqan/graph_types/graph_property.h"(530)
template <typename TSpec, typename TPropmap, TPropmap const Instance> inline void resizeEdgeMap(Graph<TSpec> const&, InternalPointerMap<TPropmap, Instance>&);       	// "projects/library/seqan/graph_types/graph_property.h"(540)
template <typename TSpec, typename TClass, typename TValue> inline void resizeEdgeMap(Graph<TSpec> const&, TValue TClass:: *);       	// "projects/library/seqan/graph_types/graph_property.h"(645)
template <typename TSpec, typename TClass, typename TValue> inline void resizeEdgeMap(Graph<TSpec>&, TValue TClass:: *);       	// "projects/library/seqan/graph_types/graph_property.h"(654)
template <typename TSpec, typename TPropertyMap, typename TProperties> inline void resizeEdgeMap(Graph<TSpec> const& g, TPropertyMap& pm, TProperties const& prop);       	// "projects/library/seqan/graph_types/graph_property.h"(725)

//____________________________________________________________________________
// resizeVertexMap

template <typename TSpec, typename TPropertyMap> inline void resizeVertexMap(Graph<TSpec> const& g, TPropertyMap& pm);       	// "projects/library/seqan/graph_types/graph_property.h"(72)
template <typename TSpec, typename TPropertyMap, typename TProperties> inline void resizeVertexMap(Graph<TSpec> const& g, TPropertyMap& pm, TProperties const& prop);       	// "projects/library/seqan/graph_types/graph_property.h"(707)

//____________________________________________________________________________
// root

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type& root(Graph<Automaton<TAlphabet, TCargo, TSpec> > & g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(740)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type& root(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(772)

//____________________________________________________________________________
// sequenceId

template <typename TSize, typename TSpec, typename TVal> inline typename Id<Fragment<TSize, TSpec> >::Type sequenceId(Fragment<TSize, TSpec> const& f, TVal const seqId);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(141)

//____________________________________________________________________________
// silentStatus

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool& silentStatus(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(994)

//____________________________________________________________________________
// source

template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> >::Type& source(EdgeStump<TCargo, TList, true, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(599)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> >::Type source(EdgeStump<TCargo, TList, true, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(609)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> >::Type source(EdgeStump<TCargo, TList, false, TId, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(620)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> >::Type source(EdgeStump<TCargo, TList, false, TId, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(632)

//____________________________________________________________________________
// sourceVertex

template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type sourceVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(537)
template <typename TGraph, typename TSpec> inline typename VertexDescriptor<TGraph>::Type sourceVertex(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1128)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type sourceVertex(Graph<Undirected<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(666)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type sourceVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(478)
template <typename TGraph, typename TSpec> inline typename VertexDescriptor<TGraph>::Type sourceVertex(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(439)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type sourceVertex(Graph<Tree<TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(610)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Directed<TCargo, TSpec> > >::Type sourceVertex(Graph<Directed<TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(815)

//____________________________________________________________________________
// target

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type& target(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(509)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type target(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(519)

//____________________________________________________________________________
// targetVertex

template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type targetVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(525)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Directed<TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Directed<TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1160)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1170)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Tree<TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1180)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Undirected<TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Undirected<TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1190)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1204)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type targetVertex(Graph<Undirected<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(655)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type targetVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(467)
template <typename TGraph, typename TSpec> inline typename VertexDescriptor<TGraph>::Type targetVertex(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(449)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type targetVertex(Graph<Tree<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(599)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Directed<TCargo, TSpec> > >::Type targetVertex(Graph<Directed<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(782)

//____________________________________________________________________________
// transitionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline TCargo& transitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const state1, TVertexDescriptor const state2);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(803)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline TCargo& transitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(817)

//____________________________________________________________________________
// transpose

template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& source, Graph<Automaton<TAlphabet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(219)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(229)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Undirected<TCargo, TSpec> > const& source, Graph<Undirected<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(198)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Undirected<TCargo, TSpec> > const&);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(210)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& source, Graph<Hmm<TAlphabet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(186)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(196)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Tree<TCargo, TSpec> > const& source, Graph<Tree<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(233)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(244)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Directed<TCargo, TSpec> > const& source, Graph<Directed<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(209)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(219)

//____________________________________________________________________________
// value

template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(208)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(176)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(172)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(174)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(542)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(553)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(563)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(574)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(584)
template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(194)

//____________________________________________________________________________
// write

template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(637)
template <typename TFile, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Undirected<TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(746)
template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(513)
template <typename TFile, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Tree<TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(698)
template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Automaton<TAlphabet, TCargo, WordGraph<TSpec> > > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(173)
template <typename TFile, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Directed<TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(930)
template <typename TFile, typename TSpec, typename TNodeAttributes, typename TEdgeAttributes> void write(TFile & file, Graph<TSpec> const& g, TNodeAttributes const& nodeMap, TEdgeAttributes const& edgeMap, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(468)
template <typename TFile, typename TSpec, typename TNodeAttributes> inline void write(TFile & file, Graph<TSpec> const& g, TNodeAttributes const& nodeMap, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(526)
template <typename TFile, typename TSpec> inline void write(TFile & file, Graph<TSpec> const& g, DotDrawing);       	// "projects/library/seqan/graph_types/graph_drawing.h"(541)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

