/*	SCCS Id: @(#)you.h	3.2	96/05/06	*/
/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1985. */
/* NetHack may be freely redistributed.  See license for details. */

#ifndef YOU_H
#define YOU_H

#ifndef ALIGN_H
#include "align.h"
#endif
#ifndef ATTRIB_H
#include "attrib.h"
#endif
#ifndef MONST_H
#include "monst.h"
#endif
#ifndef PROP_H
#include "prop.h"
#endif

/* KMH, balance patch -- Skills have been moved to skills.h */
#ifndef SKILLS_H
# include "skills.h"
#endif

/* KMH -- struct prop and assignments moved to prop.h */


struct u_have {
	Bitfield(amulet,1);	/* carrying Amulet	*/
	Bitfield(bell,1);	/* carrying Bell	*/
	Bitfield(book,1);	/* carrying Book	*/
	Bitfield(menorah,1);	/* carrying Candelabrum */
	Bitfield(questart,1);	/* carrying the Quest Artifact */
	Bitfield(unused,3);
};


struct u_event {
	Bitfield(minor_oracle,1);	/* received at least 1 cheap oracle */
	Bitfield(major_oracle,1);	/*  "  expensive oracle */
	Bitfield(qcalled,1);		/* called by Quest leader to do task */
	Bitfield(qexpelled,1);		/* expelled from the Quest dungeon */
	Bitfield(qcompleted,1);		/* successfully completed Quest task */
	Bitfield(uheard_tune,2);	/* 1=know about, 2=heard passtune */
	Bitfield(uopened_dbridge,1);	/* opened the drawbridge */

	Bitfield(invoked,1);		/* invoked Gate to the Sanctum level */
	Bitfield(gehennom_entered,1);	/* entered Gehennom via Valley */
#ifdef ELBERETH
	Bitfield(uhand_of_elbereth,2);	/* became Hand of Elbereth */
#endif
	Bitfield(udemigod,1);		/* killed the wiz */
	Bitfield(ascended,1);		/* has offered the Amulet */
};


/* KMH, ethics --
 * These are voluntary challenges.  Each field denotes the number of
 * times a challenge has been _broken_.
 */
struct u_ethics {				/* Number of times... */
	long	meat;				/* Eaten corpses, tins, eggs, tripe, or body parts */
	long	flesh;				/* ... or anything "fleshy" */
	long	food;				/* ... or any comestible */
	long	gnostic;			/* Used prayer, priest, or altar */
	long	weaphit;			/* Hit a monster with a weapon */
	long	killer;				/* Killed a monster yourself */
	long	literate;			/* Read something (other than BotD) */
	long	polypiles;			/* Polymorphed an object */
	long	polyselfs;			/* Transformed yourself */
	long	wishes;				/* Used a wish */
	long	wisharti;			/* Wished for an artifact */
	long	chastity;			/* How many times you've played around with *ubbi */
						/* Genocides is obvious at end of game */
};


struct you {
	xchar ux, uy;
	schar dx, dy, dz;	/* direction of move (or zap or ... ) */
	schar di;			/* direction of FF */
	xchar ux0, uy0;		/* initial position FF */
	d_level uz, uz0;	/* your level on this and the previous turn */
	d_level utolev;		/* level monster teleported you to, or uz */
	uchar utotype;		/* bitmask of goto_level() flags for utolev */
	boolean umoved;		/* changed map location (post-move) */
	int last_str_turn;	/* 0: none, 1: half turn, 2: full turn */
						/* +: turn right, -: turn left */
	int ulevel;			/* 1 to MAXULEV */
	int ulevelmax;		/* Maximmum level achieved */
	unsigned utrap;		/* trap timeout */
	unsigned utraptype;	/* defined if utrap nonzero */
#define TT_BEARTRAP	0
#define TT_PIT		1
#define TT_WEB		2
#define TT_LAVA		3
#define TT_INFLOOR	4
	char	urooms[5];	/* rooms (roomno + 3) occupied now */
	char	urooms0[5];	/* ditto, for previous position */
	char	uentered[5];	/* rooms (roomno + 3) entered this turn */
	char	ushops[5];	/* shop rooms (roomno + 3) occupied now */
	char	ushops0[5];	/* ditto, for previous position */
	char	ushops_entered[5]; /* ditto, shops entered this turn */
	char	ushops_left[5];	/* ditto, shops exited this turn */

	int	 uhunger;	/* refd only in eat.c and shk.c */
	unsigned uhs;		/* hunger state - see eat.c */

	struct prop uprops[LAST_PROP+1];

	unsigned umconf;
	char usick_cause[PL_PSIZ+20]; /* sizeof "unicorn horn named "+1 */
	Bitfield(usick_type,2);
#define SICK_VOMITABLE 0x01
#define SICK_NONVOMITABLE 0x02
#define SICK_ALL 0x03

/* For messages referring to hands, eyes, feet, etc... when polymorphed */
#define ARM 0
#define EYE 1
#define FACE 2
#define FINGER 3
#define FINGERTIP 4
#define FOOT 5
#define HAND 6
#define HANDED 7
#define HEAD 8
#define LEG 9
#define LIGHT_HEADED 10
#define NECK 11
#define SPINE 12
#define TOE 13
#define HAIR 14

	/* These ranges can never be more than MAX_RANGE (vision.h). */
	int nv_range;			/* current night vision range */
	int xray_range;			/* current xray vision range */

	/*
	 * These variables are valid globally only when punished and blind.
	 */
#define BC_BALL  0x01	/* bit mask for ball  in 'bc_felt' below */
#define BC_CHAIN 0x02	/* bit mask for chain in 'bc_felt' below */
	int bglyph;	/* glyph under the ball */
	int cglyph;	/* glyph under the chain */
	int bc_order;	/* ball & chain order [see bc_order() in ball.c] */
	int bc_felt;	/* mask for ball/chain being felt */


	/*
	 * Player type monster (e.g. PM_VALKYRIE).  This is set in u_init
	 * and never changed afterward.
	 */
	int umonster;
#ifndef ROLE_PATCH
	char role;			/* 'A'==archeologist, 'K'==knight, &c */
#endif
	char usym;			/* usually '@' */
	int umonnum;				/* monster number or -1 */
	int mh, mhmax, mtimedone;		/* for polymorph-self */
	struct attribs	macurr,			/* for monster attribs */
			mamax;			/* for monster attribs */
	int ulycn;				/* lycanthrope type */

	unsigned ucreamed;
	unsigned uswldtim;		/* time you have been swallowed */

	Bitfield(uswallow,1);		/* true if swallowed */
	Bitfield(uinwater,1);		/* if you're currently in water (only
					   underwater possible currently) */
	Bitfield(uundetected,1);	/* if you're a hiding monster/piercer */
	Bitfield(mfemale,1);		/* saved human value of flags.female */
	Bitfield(uinvulnerable,1);	/* you're invulnerable (praying) */
	Bitfield(uburied,1);		/* you're buried */
	/* 2 free bits! */

	unsigned udg_cnt;		/* how long you have been demigod */
	struct u_event	uevent;		/* certain events have happened */
	struct u_have	uhave;		/* you're carrying special objects */
	struct u_ethics	uethics;	/* KMH, ethics */
	struct attribs	acurr,		/* your current attributes (eg. str)*/
			aexe,		/* for gain/loss via "exercise" */
			abon,		/* your bonus attributes (eg. str) */
			amax,		/* your max attributes (eg. str) */
			atemp,		/* used for temporary loss/gain */
			atime;		/* used for loss/gain countdown */
	align	ualign;			/* character alignment */
#define CONVERT		2
	aligntyp ualignbase[CONVERT];	/* for ualign conversion record */
	schar uluck, moreluck;		/* luck and luck bonus */
#define LUCKADD		3	/* added value when carrying luck stone */
#define Luck	(u.uluck + u.moreluck)
#define LUCKMAX		10	/* on moonlit nights 11 */
#define LUCKMIN		(-10)
	long	uhealbonus;		/* KMH -- Healing bonus from healthstones */

	schar	uhitinc;		/* KMH -- additional to-hit bonus */
	schar	udaminc;		/* Additional damage bonus */
	schar	uac;
	uchar	uspellprot;		/* protection by SPE_PROTECTION */
	uchar	usptime;		/* #moves until uspellprot-- */
	uchar	uspmtime;		/* #moves between uspellprot-- */

	int     uhp, uhpmax, uhpbase;
	int     uen, uenmax, uenbase;   /* magical energy - M. Stephenson */
	int ugangr;                     /* if the gods are angry at you */
	int ublessed, ublesscnt;        /* blessing/duration from #pray */
#ifdef NOARTIFACTWISH
	int usacrifice;                 /* number of sacrifices so far */
#endif
	/* These have been supplanted by techniques */
/*	int unextuse;                   /* next use of special power */
/*	int ulastuse;                   /* duration of special power */
	/* KMH -- Drow is now its own role... */
/*	boolean uelf_drow;		/* are you a drow? */
/*	int ustrucklast;		/* Seems unused */
    long    ugold, ugold0;
	long	uexp, urexp;
	long	ucleansed;	/* to record moves when player was cleansed */
	long	usleep;		/* sleeping; monstermove you last started */
	int uinvault;
	struct monst *ustuck;
#ifdef YEOMAN
	struct monst *usteed;
#endif
	int	umortality;		/* how many times you died */
	int ugrave_arise; /* you die and become something aside from a ghost */
	time_t	ubirthday;		/* real world time when game began */

	/* KMH -- Info shared among gypsies */
	int umonteluck;		/* Chance of winning; lower is better */
	char umontelast;	/* Last monte card picked */

#ifdef WEAPON_SKILLS
	int	weapon_slots;		/* unused skill slots */
	int	skills_advanced;		/* # of advances made so far */
	xchar	skill_record[P_SKILL_LIMIT];	/* skill advancements */
	struct skills weapon_skills[P_NUM_SKILLS];
	boolean twoweap;		/* KMH -- using two-weapon combat */
#endif /* WEAPON_SKILLS */

};	/* end of `struct you' */

#define Upolyd (u.mtimedone != 0)


#endif	/* YOU_H */
