    /*
 * Storm Package Manager
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/* Test program */

#include <signal.h>
#include <fcntl.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "../libstormpkg/libstormpkg_app_include.h"
#include <apt-pkg/algorithms.h>

void test_test(int);
void test_test_test(int);
void check_dep();
bool depsafe(pkgCache::PkgIterator &, pkgCache::PkgIterator *pp=NULL);
void depdisplay(pkgCache::PkgIterator &pi);
pid_t redir();

extern int maxID;
extern pkgDepCache *MainPkgDepCache;

const char printforhelp[] = "Test.\n";
const char thisname[] = "testapp";
extern pkgCache *MainPkgCache;
char * name=NULL;

int main(int argc,char *argv[]){

//    pid_t pidt;

    if  (argc>1)
        name=argv[1];
    else
        name="sl-smail";//"abuse-lib";

  //  pidt=redir();


  string str;
  
  str="Hello";
  str+=" World\n";
  printf("%s%i", str.data(), maxID);
  str="Hi Linux";
  printf("%s\n", str.data());
  printf("%s\n", str.c_str());
//  return 0;
/*
   jmp_buf ejbuf;   
   struct pkginfo **pkg;
   int count,i;

   if (setjmp(ejbuf)) { // expect warning about possible clobbering of argv 
      error_unwind(ehflag_bombout);
      exit(2);
   }
   push_error_handler(&ejbuf,libstormpkg_print_error_fatal,0);

//   count = get_package_list(&pkg);
   if (count){
      fprintf(stderr,"Got information for %u packages.\n",count);
      for (i = 0;i < count;i++){
         fprintf(stderr,"%s\n",pkg[i]->name);
      }
      sleep(10);
   } else {
      fprintf(stderr,"No packages installed (?)\n");
   }

   error_unwind(ehflag_normaltidy);
*/
   
	int i;
	i=get_package_list();
	printf("abc=%u\n", i);
	
	test_test(i);
	
//	printf("%c", EOF);
	
	exit(0);

}


char *state;
string **notes;

void test_test(int i){
//	int c=0;
	pkgCache::PkgIterator pi;
//	pkgCache::PrvIterator *pri;
//	pkgCache::VerIterator vi;
//	pkgCache::VerFileIterator *vfi;
//	pkgCache::PkgFileIterator pfi(*MainPkgCache);
	pkgRecords pr(*MainPkgCache);
//	pkgCache::DepIterator dpi;

//	pkgProblemResolver Fix(*MainPkgDepCache);

    state=(char*)malloc(maxID*sizeof(char));
    memset(state, 0, maxID);

    notes=(string**)malloc(maxID*sizeof(string*));
    for (int c=0;c<maxID;c++)   {
        notes[c]=new string();
        }

		
    if  (!name)	{
        printf("U should give me a package name\n");
        return ;
        }
/*
	pi=MainPkgCache->FindPkg(name);
	
	state[pi->ID]=2;

	
	check_dep();

	Fix.Protect(pi);    // |=Protected
    Fix.Remove(pi);     // |=ToRemove
	MainPkgDepCache->MarkDelete(pi);
	Fix.InstallProtect();
	Fix.Resolve(false);
*/

	for (pi=MainPkgCache->PkgBegin();pi.end()==false;pi++)  {
       	pkgDepCache::StateCache &S=(*MainPkgDepCache)[pi];
       	
        if (S.Mode == pkgDepCache::ModeKeep){
            i++;
            printf("name=%i = %s\n", i, pi.Name());
            }
        }	
    }	
/*	

	for (pi=MainPkgCache->PkgBegin();pi.end()==false;pi++)  {
	    if  (((state[pi->ID]&2)==2)&&(pi->CurrentVer)) {
	        c++;
	        printf("%iName=%s----%i\n%s-----\n", c, pi.Name(), state[pi->ID], notes[pi->ID]->c_str());
	        }
	    }
    printf("List::\n");
	for (pi=MainPkgCache->PkgBegin();pi.end()==false;pi++)  {
	    if  (state[pi->ID]==8) {
	        c++;
	        printf("%iName=%s----%i\n", c, pi.Name(), state[pi->ID]);
	        }
	    }
    printf("List1::\n");
	for (pi=MainPkgDepCache->PkgBegin();pi.end()==false;pi++)  {
	    if  (((*MainPkgDepCache)[pi].Delete()!=true)&&((state[pi->ID]&2)==2)) {
	        c++;
	        printf("%iName=%s----%i---%i\n", c, pi.Name(), state[pi->ID], pi->VersionList);
	        }
	    }
    printf("List2::\n");
	for (pi=MainPkgDepCache->PkgBegin();pi.end()==false;pi++)  {
	    if  (((*MainPkgDepCache)[pi].Delete()==true)&&((state[pi->ID]&2)==0)) {
	        c++;
	        printf("%iName=%s----%i\n", c, pi.Name(), state[pi->ID]);
	        }
	    }
    printf("max=%i\n", i);

    }


bool loop;

void check_dep()    {

    do  {
        loop=false;
        pkgCache::PkgIterator pi=MainPkgCache->PkgBegin();
        for (;pi.end()==false;pi++){
//            if  ((pi->VersionList)&&(!pi->CurrentVer))   continue;
            if  (!pi->CurrentVer)   continue;
            if  ((state[pi->ID]&2)==2)  continue;
            if  (depsafe(pi)==false){
                loop=true;
//                depdisplay(pi);
                }
            }
        }while(loop==true);
    }

//useless
void depdisplay(pkgCache::PkgIterator &pi)  {
    struct pkgDepCache::StateCache &S = (*MainPkgDepCache)[pi];
    struct pkgCache::DepIterator Dep = S.CandidateVerIter(*MainPkgCache).DependsList();
    for (; Dep.end() != true;Dep++) {
        pkgCache::PkgIterator P = Dep.SmartTargetPkg();
        if  (!P->VersionList)
            continue;
        if  (Dep->Type==pkgCache::Dep::Suggests)
            state[P->ID]|=8;
        }
    }


bool depsafe(pkgCache::PkgIterator &pi, pkgCache::PkgIterator *pp){

    bool r=true;

if  (!strcmp("mail-transport-agent", pi.Name()))
    printf("Iamhere\n");

    if  (!pi->VersionList){
        if  (pi->ProvidesList)  {
            pkgCache::PrvIterator I=pi.ProvidesList();
            for (;I.end()==false;I++)   {
                pkgCache::PkgIterator p=I.OwnerPkg();
                if  ((state[p->ID]&2)==2)   continue;
                if  ((p->VersionList!=0)&&(p->CurrentVer==0))  continue;
                if  (p->CurrentVer!=0)
                    if  (depsafe(p)!=false) {
                        return true;
                        }
                }
            for (I=pi.ProvidesList();I.end()==false;I++)   {
                pkgCache::PkgIterator p=I.OwnerPkg();
                if  ((state[p->ID]&2)==2){
                    (*notes[p->ID])+=p.Name();
                    (*notes[p->ID])+=" provides ";
                    (*notes[p->ID])+=pi.Name();
                    (*notes[pi->ID])+=notes[p->ID]->c_str();
                    }
                }
            state[pi->ID]|=2;
            loop=true;
            if  (pp)
            return false;
            }
        return r;
        }

//    if  (!pi->CurrentVer)  return false;

    struct pkgDepCache::StateCache &S = (*MainPkgDepCache)[pi];
    struct pkgCache::DepIterator Dep = S.CandidateVerIter(*MainPkgCache).DependsList();
    for (; Dep.end() != true;) {
        // Grok or groups

        string note=" ";

        pkgCache::DepIterator Start, End;// = Dep;
        bool Result = true, relate=false;
	    Dep.GlobOr(Start, End);
   	
   	    note+=pi.Name();
  	    note+=" ";
   	    note+=Start.DepType();
   	    note+=" ";

//        for (bool LastOR = true; Dep.end() == false && LastOR == true; Dep++) {
//    	    LastOR = (Dep->CompareOp & pkgCache::Dep::Or) == pkgCache::Dep::Or;
        while(1) {  	

            pkgCache::PkgIterator T=Start.SmartTargetPkg();
            if  ((state[T->ID]&2)==2)    relate=true;
            if  (((state[T->ID]&2)!=2)&&(T->CurrentVer!=0))
                    Result = false;
    	
    	    note+=T.Name();
	    	if  (Start.TargetVer()){
    	      	note+=" (";
    		   	note+=Start.CompType();
	    	    note+=Start.TargetVer();
    		    note+=") ";
    		    }
    	    char *s;
    	    if  (Start!=End) {
    	        Start++;
    	        s=", ";
    	        if  (Start==End)    s=" or ";
        	    note+=s;
    	        }
    	    else {
        	    note+="\n";
        	    break;
    	        }
            }

        if  (Result == false)
            continue;
//        if  (Start->Type == pkgCache::Dep::Suggests)
//            state[pi->ID]|=8;
//        if  (MainPkgDepCache->IsImportantDep(Start) == false)
//            continue;


//printf("Type=%s\n", Start.DepType());
        if  (Start->Type!=pkgCache::Dep::Depends)
        if  (Start->Type!=pkgCache::Dep::PreDepends)
//        if  (Start->Type!=pkgCache::Dep::Replaces)
//        if  (Start->Type!=pkgCache::Dep::conflicts)
            continue;
        // Now we have to take action...
        pkgCache::PkgIterator P = Start.SmartTargetPkg();

//        if (((*MainPkgDepCache)[Start] & pkgDepCache::DepCVer) == pkgDepCache::DepCVer)
        if  (((state[P->ID]&2)==2)||((P->CurrentVer==0)&&(relate==true))||(depsafe(P)==false)) {
            state[pi->ID]|=2;
            loop=true;
            (*notes[pi->ID])+=note.c_str();
            (*notes[P->ID])+=(*notes[pi->ID]).c_str();
            r=false;
            }
        }
    return r;
    }

int mypipe[2];

pid_t redir(){
    pid_t pid;
    pipe(mypipe);
    dup2(mypipe[1], 1);
    if  (!(pid=fork())){
        char c;
        while(1){
            read(mypipe[0], &c, 1);
            dprintf(2, "%c", c);
            if  (c==EOF)    break;
            }
        }
//    dprintf(2, "I am error\n");
//    dprintf(1, "I am output\n");
    return pid;
    }



void test_test_test(int i){

    }
*/
