/*  $Id: pce_pl.pl,v 1.33 2002/02/01 15:04:48 jan Exp $

    Part of XPCE --- The SWI-Prolog GUI toolkit

    Author:        Jan Wielemaker and Anjo Anjewierden
    E-mail:        jan@swi.psy.uva.nl
    WWW:           http://www.swi.psy.uva.nl/projects/xpce/
    Copyright (C): 1985-2002, University of Amsterdam

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    As a special exception, if you link this library with other files,
    compiled with a Free Software compiler, to produce an executable, this
    library does not by itself cause the resulting executable to be covered
    by the GNU General Public License. This exception does not however
    invalidate any other reasons why the executable file might be covered by
    the GNU General Public License.
*/


:- module(pce_host,
	[ '$load_pce'/0
	, (meta_predicate)/1
	, '$call_atom'/1
	]).


:- module_transparent
	strip_module/3,
	'$load_pce'/0.

:- use_module(library(quintus), [(meta_predicate)/1]).

		 /*******************************
		 *	    EXPANSION		*
		 *******************************/

user:term_expansion((:- require(_)), []).


		 /*******************************
		 *	    PROPERTIES		*
		 *******************************/

property(prolog(swi)).			% this is SWI-Prolog
property(file_extensions([pl])).	% list of file extensions
property(use_predicate_references).	% use direct predicate refs in methods
property(register_source_locations).	% register the source locations
property(string).			% Supports string datatype
property(runtime) :-
	get(@(pce), is_runtime_system, @(on)).
	

		/********************************
		*         STRIP_MODULE		*
		********************************/

strip_module(Raw, Module, Term) :-
	'$strip_module'(Raw, Module, Term).


		/********************************
		*      DEBUGGER SUPPORT		*
		********************************/

%	$call_atom(+Atom)
%	Transform `Atom' into a term and call it in the user module.
%	Used to implement the `@' option in the PCE tracer.

'$call_atom'(Atom) :-
	term_to_atom(Term, Atom),
	user:Term.

		 /*******************************
		 *	     ERRORS		*
		 *******************************/

:- multifile
	prolog:message/3.

prolog:message(T) -->
	{ current_module(pce_messages) }, % avoid problem while booting
	pce_messages:pce_message(T).

		/********************************
		*             ENTRY		*
		********************************/

pce_home(PceHome) :-
	absolute_file_name(pce('.'),
			   [ file_type(directory),
			     file_errors(fail)
			   ], PceHome),
	exists_directory(PceHome), !.
pce_home(PceHome) :-
	getenv('XPCEHOME', PceHome),
	exists_directory(PceHome), !.
pce_home(PceHome) :-
	(   current_prolog_flag(xpce_version, Version),
	    atom_concat('/xpce-', Version, Suffix)
	;   Suffix = '/xpce'
	),
	absolute_file_name(swi(Suffix),
			   [ file_type(directory),
			     file_errors(fail)
			   ], PceHome),
	exists_directory(PceHome), !.
pce_home(PceHome) :-
	current_prolog_flag(saved_program, true), !,
	(   current_prolog_flag(home, PceHome)
	->  true
	;   current_prolog_flag(symbol_file, Exe)
	->  file_directory_name(Exe, PceHome)
	;   PceHome = '.'
	).
pce_home(_) :-
	print_message(error, format('Cannot find XPCE home directory', [])),
	halt(1).

'$load_pce' :-
	'$c_current_predicate'('$pce_init', user:'$pce_init'(_)), !,
	init_pce.
'$load_pce' :-
	current_prolog_flag(open_shared_object, true),
	(   load_foreign_library(pce_principal:foreign(pl2xpce))
	->  true
	;   print_message(error,
			  format('Failed to load XPCE foreign library', [])),
	    halt(1)
	),
	init_pce.

init_threads :-
	current_prolog_flag(threads, true), !,
	(   pce_principal:send(@pce, multi_threading(@on))
	->  true
	;   print_message(warning, pce(no_threads))
	).
init_threads.

init_pce :-
	(   pce_home(PceHome),
	    pce_principal:'$pce_init'(PceHome)
	->  set_prolog_flag(xpce, true),
	    init_threads
	;   print_message(error,
			  format('Failed to initialise XPCE', [])),
	    halt(1)
	).

%	We must declare this here as boot/english/pce_messages.pl is
%	not yet loaded.

:- multifile
	prolog:message/3.

prolog:message(pce(no_threads)) -->
        [ 'This version of XPCE does not support multi-threading'
        ].
