#ifndef INCLUDED_ENDIAN_H
#define INCLUDED_ENDIAN_H
/* vim:ts=4:sw=4:noet
 * (tabspace=4)
 * 
 * Copyright (C) 2004, 2005 Walter Doekes, <walter@djcvt.net>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* define BIG_ENDIAN if appropriate */
#if defined(linux)
#	include <endian.h>
#	if defined(LITTLE_ENDIAN) && defined(BIG_ENDIAN)
		/* GCC bug when using -On */
#		undef BIG_ENDIAN
#	endif
#elif !(defined(__alpha) || \
		defined(__i386__)|| \
		defined(__vax__)|| \
		defined(_WIN32))
#	define BIG_ENDIAN
#elif defined(__GNUC__)
	/* GCC bug when using -On */
#	undef BIG_ENDIAN
#endif

#endif /* INCLUDED_ENDIAN_H */
