#!/bin/sh
#
#   the ultimate team organization software
#   ---------------------------------------
#
#   Copyright 1998-2000 by Gero Kohnert
#   (see html/copyright.html for License)
#
#   Database Creation support script
#
#   Author: Gero Kohnert
#
#   $Header: /cvsroot/tutos/tutos/createdb.sh,v 1.10.4.1 2003/04/15 08:57:51 tapoueh Exp $
#
if [ -f /usr/share/tutos/shellfunc.sh ]; then
    . /usr/share/tutos/shellfunc.sh
else
    . ./shellfunc.sh
fi

usage() {
  echo "$0 databasetype action"
  echo ""
  echo "where databasetype is one of "
  echo "  POSTGRES"
  echo "  MYSQL"
  echo "  ORACLE"
  echo "  INTERBASE"
  echo ""
  echo "where action is one of "
  echo "  CREATE"
  echo "  DROP"
  echo "  DUMP              (dump data only no table schema)"
  echo ""
}

if [ $# != 2 ]
then
  usage
  echo "Missing Argument 1 or 2"
  exit;
fi

TYPE=$1
export TYPE

setdb $1

echo "----------------------------"
echo "HOST:   $DBHOST"
echo "PORT:   $DBPORT"
echo "DBUSER: $DBUSER"
echo "DBNAME: $DBNAME"
echo "----------------------------"

#
# ORACLE (See technet.orcale.com for help)
#
if [ $1 = "ORACLE" ]
then
  #
  # CREATE DATABASE AND USER
  #
  if [ $2 = "CREATE" ]
  then
    echo "Please enter password for $DBSUSER :"
    read  P
    $SQLCMD -s ${DBSUSER}/${P}@${DBNAME} <<EOF
$line1
$line2
CREATE USER $DBUSER identified by ${DBPASSWD};
GRANT connect,resource to $DBUSER identified by $DBPASSWD ;  
EOF
  fi
  #
  # DELETE DATABASE AND USER
  #
  if [ $2 = "DROP" ]
  then
    echo "Please enter password for $DBSUSER :"
    read  P
    $SQLCMD -s ${DBSUSER}/${P}@${DBNAME} <<EOF
$line1
$line2
DROP USER $DBUSER cascade;
EOF
  fi
  #
  # DUMP DATABASE AND USER
  #
  if [ $2 = "DUMP" ]
  then
    $ORACLE_HOME/bin/exp ${DBUSER}/${DBPASSWD}@${DBNAME} GRANTS=y COMPRESS=y ROWS=y OWNER=$DBUSER FILE=oracle.$DBNAME.dump
  fi
  #
  # RESTORE DATABASE AND USER
  #
  if [ $2 = "RESTORE" ]
  then
    $ORACLE_HOME/bin/imp ${DBUSER}/${DBPASSWD}@${DBNAME} GRANTS=y ROWS=y  FILE=oracle.$DBNAME.dump
  fi
fi
#
# POSTGRES
#
if [ $1 = "POSTGRES" ]
then
  #
  # CREATE DATABASE AND USER
  #
  if [ $2 = "CREATE" ]
  then
    createdb -h $DBHOST -p $DBPORT -U $DBSUSER $DBNAME
    echo " Database $DBNAME created !"
# OLD Postgres 6.5
#    createuser -h $DBHOST -p $DBPORT -U -D $DBUSER
    #  Postgres 7
    createuser -A -D -h $DBHOST -p $DBPORT -U $DBSUSER $DBUSER
    echo " User $DBUSER created !"
    echo "---------------------------------------------------------------"
    echo " To enable access to the $DBNAME Database add something like   "
    echo " this to your [postgreshome]/data/pg_hba.conf file             "
    echo "---------------------------------------------------------------"
    echo "host  $DBNAME   [IP Addr of $APACHEHOST]  255.255.255.255   trust"
    echo "---------------------------------------------------------------"
    echo "it is recommended to restart the database !"
  fi
  #
  # DELETE DATABASE AND USER
  #
  if [ $2 = "DROP" ]
  then
    # Postgres 6.5
    # destroydb -h $DBHOST -p $DBPORT $DBNAME
    # Postgres 7
    dropdb -h $DBHOST -p $DBPORT $DBNAME
    echo " Database $DBNAME destroyed !"
    # Postgres 6.5
    # destroyuser -h $DBHOST -p $DBPORT $DBUSER
    # Postgres 7
    dropuser -h $DBHOST -p $DBPORT $DBUSER
    echo " User $DBUSER destroyed !"
    echo "---------------------------------------------------------------"
    echo " Please remove all lines for $DBNAME                           "
    echo " from your [postgreshome]/data/pg_hba.conf file                "
    echo "---------------------------------------------------------------"
    echo "host  $DBNAME   [IP Addr of $APACHEHOST]  255.255.255.255   trust"
    echo "---------------------------------------------------------------"
    echo "it is recommended to restart the database !"
  fi
  #
  # DUMP DATABASE AND USER
  #
  if [ $2 = "DUMP" ]
  then
    pg_dump -a -D -h $DBHOST -p $DBPORT -f postgres.$DBNAME.dump $DBNAME
    echo "Postgres Database dumpfile \"postgres.$DBNAME.dump\" created"
  fi
  #
  # RESTORE DATABASE AND USER
  #
  if [ $2 = "RESTORE" ]
  then
    echo "Postgres Database restore currently not supported"
    echo "run psql -h $DBHOST -d $DBNAME -f [your dump file]"
    echo "after running scheme.sh"
  fi
fi
#
# MySQL
#
if [ $1 = "MYSQL" ]
then
  #
  # REMINDER  /usr/bin/mysqladmin -u root -p password 'newpassword' 
  # REMINDER  /usr/bin/mysqladmin -u root -h marvin -p password 'new-password' 
  #
  # CREATE DATABASE AND USER
  #
  #
  if [ $2 = "CREATE" ]; then
      CMD="$SQLCMD -h $DBHOST -u $DBSUSER"
      if [ -z "$DBPASSWD" ]; then
	  PWD=""
      else
	  PWD="-p"$DBPASSWD
      fi
      $CMD "$PWD" mysql <<EOF
$line1 

CREATE DATABASE $DBNAME;

GRANT ALL PRIVILEGES ON $DBNAME.* TO $DBUSER@$APACHEHOST IDENTIFIED BY '$DBPASSWD';
FLUSH PRIVILEGES;
EOF
  fi
  #
  # DELETE DATABASE AND USER
  #
  if [ $2 = "DROP" ]
  then
    $SQLCMD -h $DBHOST -u $DBSUSER -p mysql <<EOF
$line1

DROP DATABASE IF EXISTS $DBNAME;

REVOKE ALL PRIVILEGES ON $DBNAME.* FROM $DBUSER@$APACHEHOST IDENTIFIED BY '$DBPASSWD';

DELETE FROM db WHERE db = '$DBNAME';

FLUSH PRIVILEGES;
EOF
  fi
  #
  # DUMP DATABASE AND USER
  #
  if [ $2 = "DUMP" ]
  then
    mysqldump -t -c -h $DBHOST -u $DBUSER $DBNAME > mysql.$DBNAME.dump
    echo "MySQL Database dumpfile \"mysql.$DBNAME.dump\" created"
  fi
  #
  # RESTORE DATABASE AND USER
  #
  if [ $2 = "RESTORE" ]
  then
    echo "MySQL Database restore currently not supported"
    echo "run mysql < [your dump file]"
    echo "after running scheme.sh"
  fi
fi

# -----------------------------------------------------------------------------
# Interbase Version 6.0
# -----------------------------------------------------------------------------
if [ $1 = "INTERBASE" ]
then
  IBASE_HOME=/opt/interbase
  DBSPASSWD=masterkey
  export IBASE_HOME
  # connect '/tmp/tutos.gdb'  USER 'wwwrun' PASSWORD 'tutos';
  #
  # CREATE DATABASE AND USER
  #
  if [ $2 = "CREATE" ]
  then
    $IBASE_HOME/bin/gsec -user $DBSUSER -password $DBSPASSWD -database $IBASE_HOME/isc4.gdb -add $DBUSER -pw $DBPASSWD -fname TUTOS 
    $IBASE_HOME/bin/gsec -user $DBSUSER -password $DBSPASSWD -database $IBASE_HOME/isc4.gdb -display
    $SQLCMD -u $DBSUSER -p $DBSPASSWD <<EOF
$line1 

CREATE DATABASE '$DBNAME';

EOF
  fi
  #
  # DELETE DATABASE AND USER
  #
  if [ $2 = "DROP" ]
  then
    $IBASE_HOME/bin/gsec -user $DBSUSER -password $DBSPASSWD -database $IBASE_HOME/isc4.gdb -del $DBUSER

    $SQLCMD -u $DBSUSER -p $DBSPASSWD <<EOF
$line1
CONNECT '$DBHOST:$DBNAME';
DROP DATABASE;

EOF
  fi
  #
  # DUMP DATABASE AND USER
  #
  if [ $2 = "DUMP" ]
  then
    $IBASE_HOME/bin/gbak  -USER $DBSUSER -PASSWORD $DBSPASSWD -b $DBHOST:$DBNAME  ibase.dump
    echo "Interbase Database dumpfile \"ibase.dump\" created"
  fi
  #
  # RESTORE DATABASE AND USER
  #
  if [ $2 = "RESTORE" ]
  then
    echo "Ibase Database restore currently not supported"
    echo "after running scheme.sh"
  fi
fi

if [ $2 = "CREATE" ]
then
  notice;
fi

# EOF
