<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * Create a new mail
 *
 * CVS Info:  $Id: mail_new.php,v 1.25 2003/04/01 18:34:32 gokohnert Exp $
 * $Author: gokohnert $
 *
 * @modulegroup mail
 * @module mail_new
 * @package mail
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("mail","new");
 loadlayout();

 /**
  * write a new mail
  */
 class mail_new extends layout {
   /**
    * display the info
    */
   Function info() {
     global $tutos,$lang;

     echo "<form name=\"mailnew\" enctype=\"multipart/form-data\" action=\"mail_ins.php\" method=\"post\">\n";
     $this->addHidden("gotourl","mail_new.php");
     echo $this->DataTableStart();

     echo "<tr>\n";
     echo " <th colspan=\"4\">". $lang['MailboxEmail'] ."</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['MailFrom'],0,"from");
     echo " <td colspan=\"3\">\n";
     $d = $this->obj->from->default_email();
     echo "  <select name=\"from\">\n";
     if ( isset($this->obj->from->location) ) {
       @reset($this->obj->from->location);
       while( list ($i,$f) = @each ($this->obj->from->location)) {
         if ( $f->email_1 != "") {
           echo "   <option value=\"1,". $f->id ."\"". ($d == $f->email_1 ? " selected" : "") .">". $f->email_1 ."</option>\n";
         }
         if ( $f->email_2 != "") {
           echo "   <option value=\"2,". $f->id ."\"". ($d == $f->email_2 ? " selected" : "") .">". $f->email_2 ."</option>\n";
         }
       }
     }
     echo "  </select>\n";
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['MailTo'],1,"to");
     echo " <td colspan=\"3\">\n";
     echo "  <input size=\"40\" maxlength=\"200\" name=\"to\" value=\"". $this->obj->getToAscii() ."\">\n";
     echo " </td>\n";
     echo "</tr>\n"; 

     echo "<tr>\n";
     echo $this->showfieldc($lang['MailCc'],0,"cc");
     echo " <td colspan=\"3\">\n";
     echo "  <input id=\"cc\" size=\"40\" maxlength=\"200\" name=\"cc\" value=\"". $this->obj->getCcAscii() ."\">\n";
     echo " </td>\n";
     echo "</tr>\n";
     
     echo "<tr>\n";
     echo $this->showfieldc($lang['MailBcc'],1,"bcc");
     $xx = $this->obj->getBccAscii();
     if ( strlen($xx) < 200 ) {
       echo " <td colspan=\"3\">\n";
       echo "  <input size=\"40\" maxlength=\"200\" name=\"bcc\" value=\"". $xx ."\">\n";
       echo " </td>\n";
     } else {
       echo $this->showdata($lang[$this->to->getType()] ." ". $this->to->getLink(),3);
       $this->addHidden("toid",$_GET['toid']);
     }
     echo "</tr>\n";     
 
     echo "<tr>\n";
     echo $this->showfieldc($lang['MailSubject'],0,"subject");
     echo " <td colspan=\"3\">\n";
     echo "  <input id=\"subject\" size=\"40\" maxlength=\"60\" name=\"subject\" value=\"". $this->obj->subject ."\">\n";
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo " <td colspan=\"4\">\n";
     echo "  <textarea id=\"body\" wrap=\"hard\" rows=\"20\" cols=\"60\" name=\"body\">". $this->obj->body[0] ."</textarea>\n";
     echo " </td>\n";
     echo "</tr>\n";

	 if ($this->noattach == false) {
       echo "<tr>\n";
       echo $this->showfieldc($lang['MailAttachmentNew'],0,"file");
       echo " <td colspan=\"3\">\n";
       echo " <input size=\"30\" id=\"file\" name=\"file\" type=\"file\" value=\"". myentities($this->obj->filepath) ."\">\n";
       echo " </td>\n";
       echo "</tr>\n";
	 }
     submit_reset(0,1,1,1,1,0);
     echo $this->DataTableEnd();
     echo $this->getHidden();
     hiddenFormElements();
     echo "</form>\n";
     echo $this->setfocus("mailnew.body");
   }
   /**
    *
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['MailboxEmail'];

     $this->obj = new mail();
     $this->obj->body[0] = "";
     $this->obj->filepath = "";

     $this->obj->setFrom($this->user);

     if ( isset($_GET['subject']) ) {
       $this->obj->setSubject(StripSlashes($_GET['subject']));
     }
     if ( isset($_GET['filepath']) ) {
       $this->obj->file_path = $_GET['filepath'];
     }
     if ( isset($_GET['to']) ) {
       foreach ( $_GET['to'] as $t ) {
         $this->obj->addTo($t);
       }
     } 
	 if ( isset($_GET['noattach']) ) {
  	   $this->noattach = true;
	 } else {
  	   $this->noattach = false;
	 }

     if ( isset($_GET['toid']) ) {
       $this->to = getObject($this->dbconn,$_GET['toid']);
       if ( $this->to->getType() == "team" ) {
          // team members are sent in bcc
         $this->obj->addBcc($this->to);
         $this->obj->addTo($this->user);
       } else if ( $this->to->getType() == "product" ) {
         $this->to->readroles();
         foreach ($this->to->role as $role => $f) {
           if ( isset ($this->to->role[$role] ) && is_array ($this->to->role[$role]) ) {
             foreach($this->to->role[$role] as $i => $o) {
               $this->obj->addTo($o);
             }
           }
         }
       } else if ( $this->to->getType() == "group" ) {
         $this->to->read_member();
         foreach( $this->to->member as $i => $o) {
           $this->obj->addTo($o);
         }
       } else {
         $msg .= "Unknown toid". $this->to->id ." ". $_GET['toid'] ." ". $this->to->getType();
         $this->stop = true;
       }
     }
     if ( isset($_GET['cc']) ) {
       foreach ( $_GET['cc'] as $t ) {
         $this->obj->addCc($t);
       }
     }
     if ( isset($_GET['bcc']) ) {
       foreach ( $_GET['bcc'] as $t ) {
         $this->obj->addBcc($t);
       }
     }     
     if ( isset($_GET['body']) ) {
       $this->obj->addBody(Base64_Decode($_GET['body']));
     }
   }
 }

 $l = new mail_new($current_user);
 $l->display();
 $dbconn->Close();
?>