
/*
 * GLX Server Extension
 * Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
 * Copyright (C) 1998, 1999  Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * STEPHEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR 
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/*
 * GL Rendering Commands with Evaluator Map Data
 * modified July 14, 1998 by Terence Ripperda (ripperda@engr.sgi.com)
 *
 * to help clean up some of the code and files I am splitting them 
 * up along more distinguished lines. This file corresponds to 
 * section 9.3.6 of the GLX Extension for OpenGL Protocol Specification
 * Version 1.2. This section describes the protocol for OpenGL calls
 * that Render and contain/transfer evaluator map data.
 */

#include "glxlib.h"
#include "buffer_macros.h"
#include <stdio.h>



void __glx_Map1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride,
	     GLint order, const GLdouble* points)
{
    int n_values = GLX_map1_size(target);
    int _size=n_values*order*8;
    char* buffer = NULL;
    __GLX_GET_RENDER_BUFFER(buffer, 143, 28, _size);
    __GLX_PUT_double(buffer, u1);
    __GLX_PUT_double(buffer, u2);
    __GLX_PUT_enum(buffer, target);
    __GLX_PUT_int(buffer, order);
    PUT_large_map2d( buffer, points, 1, order, 1, stride, n_values );
}



void __glx_Map1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride,
	     GLint order, const GLfloat* points)

{
    int n_values = GLX_map1_size(target);
    int _size=n_values*order*4;
    char *buffer = NULL;
    __GLX_GET_RENDER_BUFFER(buffer, 144, 20, _size);
    __GLX_PUT_enum(buffer, target);
    __GLX_PUT_float(buffer, u1);
    __GLX_PUT_float(buffer, u2);
    __GLX_PUT_int(buffer, order);
    PUT_large_map2f( buffer, points, 1, order, 1, stride, n_values );
}



void __glx_Map2d(GLenum target, GLdouble u1, GLdouble u2, GLint ustride,
	     GLint uorder, GLdouble v1, GLdouble v2, GLint vstride,
	     GLint vorder, const GLdouble* points)
{
    int n_values = GLX_map2_size(target);
    int _size=n_values*uorder*vorder*8;
    char* buffer = NULL;
    __GLX_GET_RENDER_BUFFER(buffer, 145, 48, _size);
    __GLX_PUT_double(buffer, u1);
    __GLX_PUT_double(buffer, u2);
    __GLX_PUT_double(buffer, v1);
    __GLX_PUT_double(buffer, v2);
    __GLX_PUT_enum(buffer, target);
    __GLX_PUT_int(buffer, uorder);
    __GLX_PUT_int(buffer, vorder);
    PUT_large_map2d(
       buffer, points,
       uorder, vorder,
       ustride, vstride,
       n_values
    );
}


void __glx_Map2f(GLenum target, GLfloat u1, GLfloat u2, GLint ustride,
	     GLint uorder, GLfloat v1, GLfloat v2, GLint vstride,
	     GLint vorder, const GLfloat* points)
{
    int n_values = GLX_map2_size(target);
    int _size=n_values*uorder*vorder*4;
    char* buffer = NULL;
    __GLX_GET_RENDER_BUFFER(buffer, 146, 32, _size);
    __GLX_PUT_enum(buffer, target);
    __GLX_PUT_float(buffer, u1);
    __GLX_PUT_float(buffer, u2);
    __GLX_PUT_int(buffer, uorder);
    __GLX_PUT_float(buffer, v1);
    __GLX_PUT_float(buffer, v2);
    __GLX_PUT_int(buffer, vorder);
    PUT_large_map2f( 
       buffer, points, 
       uorder, vorder, 
       ustride, vstride, 
       n_values
    );
}

