/*
 * GLX Hardware Device Driver for Intel i810
 * Copyright (C) 1999 Keith Whitwell
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * KEITH WHITWELL, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

/* $Id: i810context.h,v 1.1 1999/12/13 12:47:44 keithw Exp $ */


#ifndef I810CONTEXT_INC
#define I810CONTEXT_INC


#include "mesaglx/types.h"

#include "i810common.h"
#include "i810buf.h"
#include "i810tex.h"
#include "i810vb.h"

#include "xsmesaP.h"

/* Hmmm */
#define FALLBACK_TEXTURE   1



/* For i810Ctx->new_state.
 */
#define I810_NEW_TEXTURE 0x20
#define I810_NEW_CONTEXT 0x100



struct i810_context_t {
   GLint refcount;

   struct i810_dest_buffer *DB;
   GLcontext *gl_ctx;

   i810TextureObjectPtr CurrentTex0Obj;
   i810TextureObjectPtr CurrentTex1Obj;

   struct i810_texture_object_t TexObjList, SwappedOut;

   int TextureMode;

   /* flags 
    */
   int GlobalPaletteUpdated:1; 


   /* Hardware state
    */
   GLuint Setup[I810_CTX_SETUP_SIZE];
   

   /* Context hardware state mirrors.
    */
   GLushort GlobalPalette[256];

   /* Support for CVA and the fast paths.
    */
   GLuint setupdone;
   GLuint setupindex;
   GLuint renderindex;
   GLuint using_fast_path;
   GLuint using_immediate_fast_path;
/*     gl_vertex_interp_func interp; */

   /* Shortcircuit some state changes.
    */
   points_func PointsFunc;
   line_func LineFunc;
   triangle_func TriangleFunc;
   quad_func QuadFunc;

   /* Manage our own state */
   GLuint new_state; 
   GLuint reg_dirty;
   
   /* One of the few bits of hardware state that can't be calculated
    * completely on the fly:
    */
   GLuint LcsCullMode;
};

i810ContextPtr i810CreateContext(GLcontext *ctx); /* Do I need visual info? */
int i810DestroyContext(i810ContextPtr ctx);
int i810BindBuffer(i810ContextPtr ctx, struct i810_dest_buffer *buf);

extern GLuint i810DDRegisterPipelineStages( struct gl_pipeline_stage *out,
					   const struct gl_pipeline_stage *in,
					   GLuint nr );

extern GLboolean i810DDBuildPrecalcPipeline( GLcontext *ctx );


/* i810DB will be invalid when the frame buffer have to be reallocate
 * but there was not enough video memory avialable. 
 * TODO: fix this.
 */
#define CHECK_CONTEXT(x) do {			\
  if (!i810Ctx || !i810DB) {	\
    fprintf(stderr, "CHECK_CONTEXT failed in %s\n", __FUNCTION__); \
    x						\
  }						\
} while(0)

#endif
