
/*
 * GLX Server Extension
 * Copyright (C) 1998, 1999 Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef GLX_VARRAY_H
#define GLX_VARRAY_H

#include <GL/gl.h>

#define GLX_MAX_ARRAY_INFOS 6

#define GLX_EDGEFLAG 0
#define GLX_TEXTURE  1
#define GLX_COLOR    2
#define GLX_INDEX    3
#define GLX_NORMAL   4
#define GLX_VERTEX   5

/** structures for Vertex_Arrays **/

struct array_info {
   unsigned int data_type;
   unsigned int j;
   unsigned int array_type;
};


struct glx_varray {
   unsigned int  num_comps;
   unsigned int  offset;
   GLenum        data_type;
};


int GLX_vertex_data_size(struct array_info *arrays, int num_arrays); 
int GLX_varray_size(int num_verts, int num_arrays, void *arrays);
int GLX_array_info_size(int num_arrays);
int GLX_DrawArrays(int n, int m, GLenum mode, struct array_info *infos,
                 void *vertex_data);
int GLX_DrawArrays_swapped(int n, int m, GLenum mode, struct array_info *infos,
                 void *vertex_data);

#endif
