/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000 Ricardo Villalba <rvm@linuxfan.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _QTEXTDICCIONARIO_H_
#define _QTEXTDICCIONARIO_H_

#include "DiccionarioBase.h"

class QString;
class QStringList;
class QConfig;

class QTextDiccionario : public DiccionarioBase {

public:
	QTextDiccionario();
	virtual ~QTextDiccionario();

	//virtual bool busca(const QString& palabra, QStringList & resultado, 
    //                   bool con_formato=false);

	virtual bool busca(const QString& palabra, QString & resultado, 
                       bool con_formato=false);

	virtual bool aprende(const QString& texto_idioma1, const QString& texto_idioma2);
	virtual bool puedeAprender() { return true; };

	virtual bool canSelectIgnorarAcentos() { return true; };

	virtual void save();

	virtual void load(const QString& fichero);

	//virtual bool isBabyDict() { return false; };
	//virtual bool isDictdDict() { return false; };
    //virtual bool isTextDict() { return true; };

protected:
	bool chequea(const QString& texto_idioma1, const QString& texto_idioma2, QString & resultado);
	void extraeDatos(QString& output, bool invertir, QString & resultado, 
                     bool con_formato, bool contabiliza=false);
	QCString creaComando(const QString& palabra, const QString& diccionario);
	bool comprimido(const QString& diccionario);
	void formateaTexto(QString & texto, const QString& c_search);
	//void analizaTexto(QStringList & lista);
	QString getExprIgnorarAcentos( const QString& palabra );
};

#endif

