

#include <QConfig.h>
#include <qglobal.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qdir.h>


QConfig::QConfig(const char *fileName) : SimpleConfig(fileName) {
}

QString QConfig::configName(const char *name) {
	QDir d( QDir::home() );
	//debug("Directorio home: %s", d.absPath().data() );

	QString fullName= d.absPath() + "/." + QString(name);

	//debug("Nombre completo: %s", fullName.data() );
	//debug("Nombre completo: %s", fullName.latin1() );

	return fullName;
}

QConfig::~QConfig() {
}

#ifndef NO_GRAPHICS_AT_ALL
bool QConfig::writeSizeEntry(const char *key, QSize size) {
	QString s = QString("%1, %2").arg(size.width()).arg(size.height());
	writeEntry( key, s.latin1() );
	return true;
}

bool QConfig::writePointEntry(const char *key, QPoint point) {
	QString s = QString("%1, %2").arg(point.x()).arg(point.y());
	writeEntry( key, s.latin1() );
	return true;
}

QSize QConfig::readSizeEntry(const char *key, QSize defaultSize) const {
	QString s = QString("%1, %2").arg(defaultSize.width()).arg(defaultSize.height());
	QStringList l = QStringList::split( QChar(','), readEntry(key, s.latin1()), true);

	QSize size( l[0].toInt(), l[1].toInt() );

	return size;
}

QPoint QConfig::readPointEntry(const char *key, QPoint defaultPoint) const {
	QString s = QString("%1, %2").arg(defaultPoint.x()).arg(defaultPoint.y());
	QStringList l = QStringList::split( QChar(','), readEntry(key, s.latin1()), true);

	QPoint point( l[0].toInt(), l[1].toInt() );

	return point;
}

#if QT_VERSION >= 300
bool QConfig::writeFontEntry(const char *key, QFont font) {
	writeEntry(key, font.toString().latin1() );
	return true;
}

QFont QConfig::readFontEntry(const char *key, QFont defaultFont) const {
	QFont f(defaultFont);
	f.fromString( readEntry(key, f.toString().latin1() ) );
	return f;
}

#else

bool QConfig::writeFontEntry(const char *key, QFont font) {
	QString clave(key);
	clave += "_qt2";

	QString s = QString("%1, %2, %3, %4, %5, %6, %7, %8")
                .arg(font.family())
                .arg(font.pointSize())
                .arg(font.weight())
                .arg(font.italic())
                .arg(font.bold())
                .arg(font.underline())
                .arg(font.strikeOut())
                .arg(font.charSet());

	writeEntry( clave.latin1(), s.latin1() );
	return true;
}

QFont QConfig::readFontEntry(const char *key, QFont defaultFont) const {
	QString clave(key);
	clave += "_qt2";

	QString s = QString("%1, %2, %3, %4, %5, %6, %7, %8")
                .arg(defaultFont.family())
                .arg(defaultFont.pointSize())
                .arg(defaultFont.weight())
                .arg(defaultFont.italic())
                .arg(defaultFont.bold())
                .arg(defaultFont.underline())
                .arg(defaultFont.strikeOut())
                .arg(defaultFont.charSet());

	QStringList l = QStringList::split( QChar(','), readEntry(clave.latin1(), s.latin1()), true);

	QFont f( defaultFont );
	f.setFamily( l[0] );
	f.setPointSize( l[1].toInt() ); 
	f.setWeight( l[2].toInt() );
	f.setItalic( (bool) l[3].toInt() );
	f.setBold( (bool) l[4].toInt() );
	f.setUnderline( (bool) l[5].toInt() );
	f.setStrikeOut( (bool) l[6].toInt() );
	f.setCharSet( (QFont::CharSet) l[7].toInt() );

	return f;
}

#endif // QT_VERSION >= 300


bool QConfig::writeColorEntry(const char *key, QColor color) {
	QString s = QString("%1, %2, %3").arg(color.red()).arg(color.green()).arg(color.blue());
	writeEntry( key, s.latin1() );
	return true;
}

QColor QConfig::readColorEntry(const char *key, QColor defaultColor) const {
	QString s = QString("%1, %2, %3").arg(defaultColor.red()).arg(defaultColor.green()).arg(defaultColor.blue());
	QStringList l = QStringList::split( QChar(','), readEntry(key, s.latin1()), true);

	QColor color( l[0].toInt(), l[1].toInt(), l[2].toInt() );
	return color;
}

#endif //NO_GRAPHICS_AT_ALL

