/**********************************************************************

	--- Qt Architect generated file ---

	File: QATextPrefs.cpp
	Last generated: Sat Nov 11 16:12:17 2000

 *********************************************************************/

#include "textPrefs.h"
#include "qfunciones.h"
#include "qdialogos.h"
#include <qfiledialog.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qstrlist.h>

#include <qwhatsthis.h>

#include "textPrefsData.cpp"
#include "textPrefsData.moc.cpp"

QString TextPrefs::last_dir;

TextPrefs::TextPrefs
(
	DiccionarioBase *dictionary, bool nuevo,
	QWidget* parent,
	const char* name
)
	:
	TextPrefsData( parent, name )
{
	dict=dictionary;
	nuevo_dict=nuevo;

	alias->setText( dict->getAlias() );
	idioma1->setText( dict->getIdioma1() );
	idioma2->setText( dict->getIdioma2() );
	diccionario->setText( dict->getDiccionario() );
	personal->setText( dict->getPersonal() );
	separador->setEditText( dict->getSeparador() );

	if (dict->getSeparador()=="\t") {
		separador->setEditText("<tab>");
	}

	icono1->setText("");
	icono2->setText("");

	fichero_icono1=dict->getIconoIdioma1();
	ico1.load( fichero_icono1 );
	fichero_icono2=dict->getIconoIdioma2();
	ico2.load( fichero_icono2 );

	icono1->setPixmap( ico1 );
	icono2->setPixmap( ico2 );

	utf8->setChecked( dict->getUTF8() );


	if (last_dir.isEmpty()) last_dir="/usr/share/wordtrans/";

	if (dict->getTipo()==DiccionarioBase::Babylon_dict) {
		separador->setEnabled(false);
		personal->setEnabled(false);
		separador->clear();
		personal->clear();
		utf8->setEnabled(false);
	}

	alias->setFocus();

	//Whatsthis
	QWhatsThis::add(alias, 
		_("<b>Alias</b> should be a short but descriptive name.<br>"
          "The alias will be used for selecting the dictionary in "
          "the console version (option <b>-d</b>).<br>"
          "It is also used as a file name for the configuration file "
          "of this dictionary.") );

	QWhatsThis::add( idioma1, 
		_("Type here the first language of this dictionary.") );

	QWhatsThis::add( idioma2, 
		_("Type here the second language of this dictionary.") );

	QWhatsThis::add( icono1, 
		_("Click on this button to select an appropriate icon for this language") );

	QWhatsThis::add( icono2, 
		_("Click on this button to select an appropriate icon for this language") );

	QWhatsThis::add( busca_diccionario, 
		_("Click on this button to select the dictionary.") );

	if (dict->getTipo()!=DiccionarioBase::Babylon_dict) {
		//No es del Babylon

		QWhatsThis::add( separador, 
		_("The <b>separator</b> is the character or string used in plain "
		  "text dictionaries to separate one language from the other.<br>"
          "Usual separators are \" : \", \" :: \", \"&lt;tab&gt;\" or \"\\\" "
          "(without quotation marks).<br>"
          "If you don't know which separator to use, maybe the easiest "
          "way to find out is opening the dictionary with a text editor "
          "and look at the first few lines.") );

		QWhatsThis::add( diccionario,
		_("Type here the file name of the dictionary, including the "
          "full path. You can also click on the button on the right for "
          "selecting it from a file dialog.") );

		QWhatsThis::add( personal, 
		_("Type here the file name where the new translations will be "
          "added. You <b>must not</b> specify the full path, the file "
          "will be saved in your home directory.<br>"
          "<b>Example</b>: if you type \"my_personal_dictionary.dic\" "
          "the file actually used will be "
          "\"/home/&lt;user&gt;/my_personal_dictionary.dic\"") );

		QWhatsThis::add( utf8, 
		_("Check this option if this dictionary is encoded in UTF-8.<br>"
		  "You can know if a dictionary is in UTF-8 by taking a look at it. "
		  "If you see strange symbols instead of non-english characters "
		  "(accented vowels, for instance) then probably it is in UTF-8.") );
	} else {
		//Diccionario del Babylon

		QString no_sense( _("This option is not used for Babylon's dictionaries.") );
		QWhatsThis::add( separador, no_sense );
		QWhatsThis::add( personal, no_sense );
		QWhatsThis::add( utf8, no_sense );

		QWhatsThis::add( diccionario,
		_("Type here the file name of the dictionary, including the "
          "full path. You can also click on the button on the right for "
          "selecting it from a file dialog.<br><br>"
          "For Babylon's dictionaries, the file name probably "
          "will be '<b>Engto???.dic</b>', where ??? represents the destination "
          "language (spa, ita, and so on). Please, don't forget that the "
          "file 'english.dic' has to be in the same directory!") );
	}
}


TextPrefs::~TextPrefs()
{
	debug("Destruyendo TextPrefs");
}

bool TextPrefs::aceptar() {
	QString s_alias=alias->text();

	if (s_alias.isEmpty()) {
		Dialogos::mensaje( this, _("Error: wrong alias"),  
                _("The alias will be used as the file name.\n"
                  "Please introduce a right one.") );
		return false;
	}

	QString s;
	s=diccionario->text();

	if (s.isEmpty()) {
		Dialogos::mensaje( this, _("Error: dictionary file empty"),  
                _("You must choose the file where the dictionary is.") );
		return false;
	}

	if (!dict->getTipo()==DiccionarioBase::Babylon_dict) {
		s=personal->text();
		if (s.isEmpty()) {
			Dialogos::mensaje( this, _("Error: personal file empty"),   
            	    _("You must choose a file where new translations will be stored.\n"
					  "This file will be saved in your home directory.") );
			return false;
		}

		s=separador->currentText();
		if (s.isEmpty()) {
			Dialogos::mensaje( this, _("Error: separator empty"), 
        	        _("You must indicate the separator (such as \" : \") used in\n"
					  "your new dictionary.") );
			return false;
		}
	}

	if (nuevo_dict) {
		QString fichero;
		fichero += qNomPersonal(".wordtrans/");
		fichero += s_alias;

		if (dict->getTipo()==DiccionarioBase::Babylon_dict) 
			fichero += ".bconf";
		else
			fichero += ".conf";

		QFile f( fichero );
        if (f.exists()) {
			QString s= _("File %1 already exists.\nPlease change the alias.")
					.arg(fichero);
			Dialogos::mensaje( this, _("Error: file exists"), s );
			return false;
		}

		dict->setFileName(fichero);
	}

	dict->setAlias( alias->text() );
	dict->setIdioma1( idioma1->text() );
	dict->setIdioma2( idioma2->text() );
	dict->setDiccionario( diccionario->text() );
	dict->setPersonal( personal->text() );

	if ((separador->currentText()=="<tab>") || (separador->currentText()=="<TAB>")) {
		debug("Separador == <tab>");
		separador->setEditText("\t");
	}

	dict->setSeparador( separador->currentText() );
	debug("Separador actualizado a '%s'", dict->getSeparador().latin1() );

	dict->setIconoIdioma1( fichero_icono1 );
	dict->setIconoIdioma2( fichero_icono2 );

	dict->setUTF8( utf8->isChecked() );

	return true;
}

//void TextPrefs::cancelar() {
	//done(2);
//}


void TextPrefs::buscaDiccionario() {
	QString fileName = Dialogos::cargar(0, "*", this);

	if ( fileName.isNull() ) return;
	
	diccionario->setText( fileName );

}

void TextPrefs::load_icono1() {
	QString fileName = Dialogos::cargarIcono(last_dir,"*.xpm *.png",this);
	if ( fileName.isNull() ) return;

	fichero_icono1=fileName;
	ico1.load( fichero_icono1 );
	icono1->setPixmap(ico1);

	QFileInfo fi( fileName );
	last_dir = fi.dirPath( true );
}

void TextPrefs::load_icono2() {
	QString fileName = Dialogos::cargarIcono(last_dir,"*.xpm *.png",this);
	if ( fileName.isNull() ) return;

	fichero_icono2=fileName;
	ico2.load( fichero_icono2 );
	icono2->setPixmap(ico2);

	QFileInfo fi( fileName );
	last_dir = fi.dirPath( true );
}

#include "textPrefs.moc.cpp"

