/* xsane -- a graphical (X11, gtk) scanner-oriented SANE frontend

   xsane-icons.c

   Oliver Rauch <Oliver.Rauch@rauch-domain.de>
   Copyright (C) 1998-2002 Oliver Rauch
   This file is part of the XSANE package.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 

/* --------------------------------------------------- */

const char *xsane_window_icon_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    14    16        6            1",
/* color  */
"  none",
"b c #2020e0",
"w c #eeeeee",
"x c #fff098",
"y c #f0e890",
"z c #e8d880",
/* pixel  */
"   xxyyyyy    ",
" xyyyyyyyyyyz ",
"xyyyyzzyyyyyyz",
"xyxz      zyyz",
"xxy        yyz",
"    yyyy yy   ",
"   zyyyyz yyy ",
"     zzzz  yxz",
"    zbbbbz yyz",
" x zbbwwbbz yy",
"xy zbbwwbbz yy",
"xyy zbbbbz xyy",
"xyyy zzzz xyyz",
"xyyyyyyyyyyyz ",
" zyyyyyyyyz   ",
"   zzzzzzz    "
};

/* --------------------------------------------------- */

const char *error_xpm[] =
{
"40 40 6 1",
" 	c None",
".	c #FE0809",
"+	c #FDFDFC",
"@	c #E5D5D6",
"#	c #E1A09F",
"$	c #FE8081",
"               #@@++++@@#               ",
"            #@++++++++++++@#            ",
"          #+++@#$......$$@+++#          ",
"        #+++#..............#+++#        ",
"       #++#..................@++#       ",
"      @++$....................$++@      ",
"     @+@........................++@     ",
"    #+@$.........................@+#    ",
"   #++...........................$++#   ",
"   ++$.....@+...............++....$++   ",
"  #+#.....+++@.............+++@....#+#  ",
"  ++.....$+++++...........@++++$....++  ",
" #+#......#++++@.........+++++#.....#+# ",
" @+........#+++++.......@++++$.......+@ ",
" +@.........$++++@.....+++++#........++ ",
"#+$..........#+++++...@++++$.........$+#",
"@+$...........$+++++$@++++#..........$+@",
"@+.............#+++++++++$............+@",
"++..............$+++++++#.............++",
"++...............#+++++#..............++",
"++...............++++++@..............++",
"++..............@++++++++.............++",
"@+.............+++++@++++@............+@",
"@+$...........@++++#.#+++++..........$+@",
"#+$..........+++++$...$++++@.........$+#",
" +@.........@++++#.....#+++++........@+ ",
" @+........+++++$.......$++++@.......+@ ",
" #+#......@++++#.........#+++++.....#+# ",
"  ++.....#++++#...........$++++$....++  ",
"  @+#.....$++$.............#++$....#+#  ",
"   ++$.....#$...............$#....$++   ",
"   #++............................++#   ",
"    #++..........................++#    ",
"     @++........................++@     ",
"      @++$....................$++@      ",
"       #++#..................#++#       ",
"        #+++#..............#+++#        ",
"          #+++@$$......$$++++#          ",
"            #+++++++++++++@#            ",
"               #@@++++@@#               "
};

/* --------------------------------------------------- */

const char *warning_xpm[] =
{
"40 40 4 1",
" 	c None",
".	c #FFFFFF",
"+	c #FFFA00",
"@	c #000000",
"                                        ",
"                   ..                   ",
"                   ..                   ",
"                  .++.                  ",
"                  .++.                  ",
"                 .++++.                 ",
"                 .++++.                 ",
"                .++++++.                ",
"                .++++++.                ",
"               .++++++++.               ",
"               .++++++++.               ",
"              .++++++++++.              ",
"              .++++@@++++.              ",
"             .++++@@@@++++.             ",
"             .+++@@@@@@+++.             ",
"            .++++@@@@@@++++.            ",
"            .+++@@@@@@@@+++.            ",
"           .++++@@@@@@@@++++.           ",
"           .++++@@@@@@@@++++.           ",
"          .++++++@@@@@@++++++.          ",
"          .++++++@@@@@@++++++.          ",
"         .+++++++@@@@@@+++++++.         ",
"         .+++++++@@@@@@+++++++.         ",
"        .+++++++++@@@@+++++++++.        ",
"        .+++++++++@@@@+++++++++.        ",
"       .++++++++++@@@@++++++++++.       ",
"       .+++++++++++@@+++++++++++.       ",
"      .++++++++++++++++++++++++++.      ",
"      .++++++++++++++++++++++++++.      ",
"     .++++++++++++++++++++++++++++.     ",
"     .+++++++++++++@@+++++++++++++.     ",
"    .+++++++++++++@@@@+++++++++++++.    ",
"    .+++++++++++++@@@@+++++++++++++.    ",
"   .+++++++++++++++@@+++++++++++++++.   ",
"   .++++++++++++++++++++++++++++++++.   ",
"  .++++++++++++++++++++++++++++++++++.  ",
"  .++++++++++++++++++++++++++++++++++.  ",
" ..++++++++++++++++++++++++++++++++++.. ",
" ...................................... ",
"........................................"
};

/* --------------------------------------------------- */

const char *info_xpm[] =
{
"40 40 4 1",
" 	c None",
".	c #FFFFFF",
"+	c #00A000",
"@	c #000000",
"                                        ",
"                   ..                   ",
"                   ..                   ",
"                  .++.                  ",
"                  .++.                  ",
"                 .++++.                 ",
"                 .++++.                 ",
"                .++++++.                ",
"                .++++++.                ",
"               .++++++++.               ",
"               .++++++++.               ",
"              .++++++++++.              ",
"              .++++@@++++.              ",
"             .++++@@@@++++.             ",
"             .+++@@@@@@+++.             ",
"            .++++@@@@@@++++.            ",
"            .+++@@@@@@@@+++.            ",
"           .++++@@@@@@@@++++.           ",
"           .++++@@@@@@@@++++.           ",
"          .++++++@@@@@@++++++.          ",
"          .++++++@@@@@@++++++.          ",
"         .+++++++@@@@@@+++++++.         ",
"         .+++++++@@@@@@+++++++.         ",
"        .+++++++++@@@@+++++++++.        ",
"        .+++++++++@@@@+++++++++.        ",
"       .++++++++++@@@@++++++++++.       ",
"       .+++++++++++@@+++++++++++.       ",
"      .++++++++++++++++++++++++++.      ",
"      .++++++++++++++++++++++++++.      ",
"     .++++++++++++++++++++++++++++.     ",
"     .+++++++++++++@@+++++++++++++.     ",
"    .+++++++++++++@@@@+++++++++++++.    ",
"    .+++++++++++++@@@@+++++++++++++.    ",
"   .+++++++++++++++@@+++++++++++++++.   ",
"   .++++++++++++++++++++++++++++++++.   ",
"  .++++++++++++++++++++++++++++++++++.  ",
"  .++++++++++++++++++++++++++++++++++.  ",
" ..++++++++++++++++++++++++++++++++++.. ",
" ...................................... ",
"........................................"
};
/* --------------------------------------------------- */

const char *file_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"* c #000000",
". c #707070",
"- c #e0e0e0",
"  none",
/* pixels */
"                    ",
"  ................  ",
"  .*............*.  ",
"  .*............*.  ",
"  ................  ",
"  ................  ",
"  ................  ",
"  ................  ",
"  ................  ",
"  ................  ",
"  ................  ",
"  ................  ",
"  ....--------....  ",
"  ....-...----....  ",
"  ....-...----....  ",
"  ....-...----....  ",
"  ....-...----....  ",
"   ...............  ",
"                    ",
"                    "
};

/* --------------------------------------------------- */

const char *ocr_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"* c #000000",
". c #303030",
"- c #505050",
"  none",
/* pixels */
"                    ",
"                    ",
" ***** ****   ***   ",
" *   * *   * *   *  ",
" *   * *   * *      ",
" ***** ****  *      ",
" *   * *   * *      ",
" *   * *   * *   *  ",
" *   * ****   ***   ",
"                    ",
"                    ",
" ****  ***** *****  ",
" *   * *     *      ",
" *   * *     *      ",
" *   * ***   ****   ",
" *   * *     *      ",
" *   * *     *      ",
" ****  ***** *      ",
"                    ",
"                    ",
};

/* --------------------------------------------------- */

const char *scale_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
". c #000000",
"* c #808080",
"- c #a0a0a0",
"  none",
/* pixels */
"                    ",
" ..........******** ",
" .        .       * ",
" .        .       * ",
" .        .       * ",
" .        .       * ",
" .        .       * ",
" .        .       * ",
" ..........       * ",
" *         -      * ",
" *          -     * ",
" *           -    * ",
" *            -   * ",
" *             -  * ",
" *              - * ",
" *               -* ",
" ****************** ",
"                    ",
"                    ",
"                    "
};

/* --------------------------------------------------- */

const char *despeckle_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"* c #000000",
". c #303030",
"- c #505050",
"  none",
/* pixels */
"                    ",
"  ..   ..   ..    - ",
" .**. .**. .**. .-- ",
" .**. .**. .**. --- ",
"  ..   ..   .. ---- ",
"              ----- ",
"  ..   ..   .------ ",
" .**. .**. .------- ",
" .**. .**. -------- ",
"  ..   .. --------- ",
"         ---------- ",
"  ..   .----------- ",
" .**. .------------ ",
" .**. ------------- ",
"  .. -------------- ",
"    --------------- ",
"  .---------------- ",
" .----------------- ",
" ------------------ ",
"                    "
};


/* --------------------------------------------------- */

const char *blur_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"* c #000000",
"+ c #404040",
". c #707070",
"  none",
/* pixels */
"                    ",
"  **    **    **  . ",
" ****************++ ",
" ***************+++ ",
"  **    **    *+... ",
"  **    **    ++.   ",
"  **    **   .++.   ",
"  **    **  ..++.   ",
" **********++++++++ ",
" *********+++++++++ ",
"  **    *+....++... ",
"  **    ++.  .++.   ",
"  **   .++.  .++.   ",
"  **  ..++....++... ",
" ****++++++++++++++ ",
" ***+++++++++++++++ ",
"  *+....++....++... ",
"  ++.  .++.  .++.   ",
" .++.  .++.  .++.   ",
"                    "
};

/* --------------------------------------------------- */

const char *clone_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"* c #000000",
"+ c #404040",
". c #808080",
"  none",
/* pixels */
"                    ",
"                    ",
"           *******  ",
"          *       * ",
"                  * ",
"                  * ",
" *     *          * ",
"  *   *          *  ",
"   * *           *  ",
"    *           *   ",
"   * *         *    ",
"  *   *       *     ",
" *     *     *      ",
"            *       ",
"           *        ",
"           *        ",
"           *        ",
"           ******** ",
"                    ",
"                    "
};

/* --------------------------------------------------- */

const char *rotate90_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"* c #000000",
"+ c #404040",
". c #808080",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"     ********       ",
"     *********      ",
"             **     ",
"              **    ",
"              **    ",
"              **    ",
"              **    ",
"           *  **  * ",
"            * ** *  ",
"             ****   ",
"              **    ",
"                    ",
"                    ",
"                    ",
"                    ",
"                    ",
"                    "
};

/* --------------------------------------------------- */

const char *rotate180_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"* c #000000",
"+ c #404040",
". c #808080",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"     ********       ",
"     *********      ",
"             **     ",
"              **    ",
"              **    ",
"              **    ",
"              **    ",
"              **    ",
"              **    ",
"              **    ",
"        *     **    ",
"       *     **     ",
"      ********      ",
"      *******       ",
"       *            ",
"        *           ",
"                    "
};

/* --------------------------------------------------- */

const char *rotate270_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"* c #000000",
"+ c #404040",
". c #808080",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"       ********     ",
"      *********     ",
"     **             ",
"    **              ",
"    **              ",
"    **              ",
"    **              ", 
" *  **  *           ",
"  * ** *            ",
"   ****             ",
"    **              ",
"                    ",
"                    ",
"                    ",
"                    ",
"                    ",
"                    "
};

/* --------------------------------------------------- */

const char *mirror_x_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"* c #000000",
"+ c #505050",
". c #ffffff",
"  none",
/* pixels */
"                    ",
"          .         ",
"          .         ",
"          .         ",
"     *    .    +    ",
"     *    .    +    ",
"    * *   .   + +   ",
"    * *   .   + +   ",
"   *   *  .  +   +  ",
"   *   *  .  +   +  ",
"  *     * . +     + ",
"  *     * . +     + ",
" *       *.+       +",
" *********.+++++++++",
"          .         ",
"          .         ",
"          .         ",
"          .         ",
"          .         ",
"                    "
};

/* --------------------------------------------------- */

const char *mirror_y_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"* c #000000",
"+ c #505050",
". c #ffffff",
"  none",
/* pixels */
"          *         ",
"         * *        ",
"         * *        ",
"        *   *       ",
"        *   *       ",
"       *     *      ",
"       *     *      ",
"      *       *     ",
"      *********     ",
" .................. ",
"      +++++++++     ",
"      +       +     ",
"       +     +      ",
"       +     +      ",
"        +   +       ",
"        +   +       ",
"         + +        ",
"         + +        ",
"          +         ",
"                    "
};

/* --------------------------------------------------- */

const char *fax_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"* c #000000",
". c #ffffff",
"- c #e0e0e0",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"     .***********   ",
"    ..*.........*   ",
"   ...*..**.*.*.*   ",
"   ****.........*   ",
"   *............*   ",
"   *...*...***..*   ",
"   *............*   ",
"   *.*.*.**.**..*   ",
"   *............*   ",
"   *..*....*..*.*   ",
"   *............*   ",
"   *.**..*....*.*   ",
"   *............*   ",
"   **************   ",
"                    ",
"                    ",
"                    "
};

/* --------------------------------------------------- */

const char *faxreceiver_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
"* c #000000",
"- c #e0e0e0",
"  none",
/* pixels */
"                    ",
"    *********       ",
"   ***********      ",
"  *************     ",
"  *********---*     ",
" *******------*     ",
" *****--------*     ",
" *****----***-*     ",
" ****----*----*     ",
" ***-------**--*    ",
" ***------------*   ",
" **--------------*  ",
" **------------***  ",
" **-----------*     ",
"  *-------*---*     ",
"  *--------***      ",
"   *----------*     ",
"   *---------*      ",
"   *------***       ",
"    *----*          ",
};

/* --------------------------------------------------- */

const char *mail_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"* c #000000",
". c #ffffff",
"- c #e0e0e0",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"                    ",
" ****************** ",
" **..............** ",
" *.*............*.* ",
" *..*..........*..* ",
" *...*........*...* ",
" *....*......*....* ",
" *.....******.....* ",
" *................* ",
" *................* ",
" *................* ",
" *................* ",
" ****************** ",
"                    ",
"                    ",
"                    ",
"                    "
};

/* --------------------------------------------------- */

const char *mailreceiver_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
"* c #000000",
"- c #e0e0e0",
"  none",
/* pixels */
"                    ",
"    *********       ",
"   ***********      ",
"  *************     ",
"  *********---*     ",
" *******------*     ",
" *****--------*     ",
" *****----***-*     ",
" ****----*----*     ",
" ***-------**--*    ",
" ***------------*   ",
" **--------------*  ",
" **------------***  ",
" **-----------*     ",
"  *-------*---*     ",
"  *--------***      ",
"   *----------*     ",
"   *---------*      ",
"   *------***       ",
"    *----*          ",
};

/* --------------------------------------------------- */

const char *subject_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
"* c #000000",
"- c #303030",
"  none",
/* pixels */
"                    ",
"                    ",
"    ******       ** ",
"  ***    ***     ** ",
" **        **    ** ",
"            **   ** ",
"            **   ** ",
"            **   ** ",
"           **    ** ",
"         ***     ** ",
"      *****      ** ",
"      **         ** ",
"      **         ** ",
"      **         ** ",
"      **         ** ",
"                    ",
"      **         ** ",
"      **         ** ",
"                    ",
"                    ",
};

/* --------------------------------------------------- */

const char *colormode_xpm[] = {
/* width height num_colors chars_per_pixel */
"    20    20        23            1",
/* colors */
". c #000000",
"R c #ff0000",
"1 c #e04000",
"2 c #c0800",
"3 c #a0a000",
"4 c #80c000",
"5 c #40e000",
"G c #00ff00",
"6 c #00e040",
"7 c #00c080",
"8 c #00a0a0",
"9 c #0080c0",
"0 c #0040e0",
"B c #0000ff",
"a c #202020",
"b c #404040",
"c c #606060",
"d c #808080",
"e c #a0a0a0",
"f c #c0c0c0",
"g c #e0e0e0",
"h c #ffffff",
"  none",
/* pixels */
"                    ",
" hhhhh              ",
" hhhhh......        ",
" hhhhh......RRRRRRR ",
" hhhhhaaaaaaRRRRRRR ",
" hhhhhbbbbbb1111111 ",
" hhhhhbbbbbb2222222 ",
" hhhhhcccccc3333333 ",
" hhhhhcccccc4444444 ",
" .....dddddd5555555 ",
" .....ddddddGGGGGGG ",
" .....eeeeeeGGGGGGG ",
" .....eeeeee6666666 ",
" .....ffffff7777777 ",
" .....ffffff8888888 ",
" .....gggggg9999999 ",
" .....gggggg0000000 ",
"      hhhhhhBBBBBBB ",
"            BBBBBBB ",
"                    "
};

/* --------------------------------------------------- */

const char *medium_xpm[] = {
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"# c #a05020",
"  none",
/* pixels */
"                    ",
"  ################  ",
"  ################  ",
"  #..##########..#  ",
"  #..##########..#  ",
"  ################  ",
"  ################  ",
"  #..##########..#  ",
"  #..##########..#  ",
"  ################  ",
"  ################  ",
"  #..##########..#  ",
"  #..##########..#  ",
"  ################  ",
"  ################  ",
"  #..##########..#  ",
"  #..##########..#  ",
"  ################  ",
"  ################  ",
"                    "
};

/* --------------------------------------------------- */

const char *medium_delete_xpm[] = {
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
". c #000000",
"# c #a05020",
"* c #000000",
"  none",
/* pixels */
"**                **",
"***##############***",
" ***############*** ",
"  ***##########***  ",
"  #***########***#  ",
"  ##***######***##  ",
"  ###***####***###  ",
"  #..#***##***#..#  ",
"  #..##******##..#  ",
"  ######****######  ",
"  ######****######  ",
"  #..##******##..#  ",
"  #..#***##***#..#  ",
"  ###***####***###  ",
"  ##***######***##  ",
"  #***########***#  ",
"  ***##########***  ",
" ***############**  ",
"***##############** ",
"**                **"
};

/* --------------------------------------------------- */

const char *Gamma_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        2            1",
/* colors */
". c #000000",
"  none",
/* pixels */
"                    ",
"                    ",
"    .............   ",
"     ...       ..   ",
"      ..        ..  ",
"      ..         .  ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"     ....           ",
"    ........        ",
"                    "
};

/* --------------------------------------------------- */

const char *Gamma_red_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        2            1",
/* colors */
". c #ff0000",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"    .............   ",
"     ...       ..   ",
"      ..        ..  ",
"      ..         .  ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"     ....           ",
"    ........        ",
};

/* --------------------------------------------------- */

const char *Gamma_green_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        2            1",
/* colors */
". c #00ff00",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"    .............   ",
"     ...       ..   ",
"      ..        ..  ",
"      ..         .  ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"     ....           ",
"    ........        ",
};

/* --------------------------------------------------- */

const char *Gamma_blue_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        2            1",
/* colors */
". c #0000ff",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"    .............   ",
"     ...       ..   ",
"      ..        ..  ",
"      ..         .  ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"      ..            ",
"     ....           ",
"    ........        ",
};

/* --------------------------------------------------- */

const char *brightness_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #ffffff",
/* pixels */
"                    ",
"                    ",
"                    ",
"         .          ",
"         .          ",
"         .          ",
"    .   ...   .     ",
"     . .aaa. .      ",
"      .aaaaa.       ",
"     .aaaaaaa.      ",
"    .aaaaaaaaa.     ",
" ....aaaaaaaaa....  ",
"    .aaaaaaaaa.     ",
"     .aaaaaaa.      ",
"      .aaaaa.       ",
"     . .aaa. .      ",
"    .   ...   .     ",
"         .          ",
"         .          ",
"         .          ",
};

/* --------------------------------------------------- */

const char *brightness_red_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #ff0000",
/* pixels */
"                    ",
"                    ",
"                    ",
"         .          ",
"         .          ",
"         .          ",
"    .   ...   .     ",
"     . .aaa. .      ",
"      .aaaaa.       ",
"     .aaaaaaa.      ",
"    .aaaaaaaaa.     ",
" ....aaaaaaaaa....  ",
"    .aaaaaaaaa.     ",
"     .aaaaaaa.      ",
"      .aaaaa.       ",
"     . .aaa. .      ",
"    .   ...   .     ",
"         .          ",
"         .          ",
"         .          ",
};

/* --------------------------------------------------- */

const char *brightness_green_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #00ff00",
/* pixels */
"                    ",
"                    ",
"                    ",
"         .          ",
"         .          ",
"         .          ",
"    .   ...   .     ",
"     . .aaa. .      ",
"      .aaaaa.       ",
"     .aaaaaaa.      ",
"    .aaaaaaaaa.     ",
" ....aaaaaaaaa....  ",
"    .aaaaaaaaa.     ",
"     .aaaaaaa.      ",
"      .aaaaa.       ",
"     . .aaa. .      ",
"    .   ...   .     ",
"         .          ",
"         .          ",
"         .          ",
};

const char *brightness_blue_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #0000ff",
/* pixels */
"                    ",
"                    ",
"                    ",
"         .          ",
"         .          ",
"         .          ",
"    .   ...   .     ",
"     . .aaa. .      ",
"      .aaaaa.       ",
"     .aaaaaaa.      ",
"    .aaaaaaaaa.     ",
" ....aaaaaaaaa....  ",
"    .aaaaaaaaa.     ",
"     .aaaaaaa.      ",
"      .aaaaa.       ",
"     . .aaa. .      ",
"    .   ...   .     ",
"         .          ",
"         .          ",
"         .          ",
};

/* --------------------------------------------------- */

const char *contrast_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #ffffff",
/* pixels */
"                    ",
"                    ",
"                    ",
"       .....        ",
"     .....aa..      ",
"    ......aaaa..    ",
"   .......aaaaa.    ",
"  ........aaaaaa.   ",
"  ........aaaaaa.   ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
"  ........aaaaaa.   ",
"  ........aaaaaa.   ",
"   .......aaaaa.    ",
"    ......aaaa..    ",
"     .....aa..      ",
"       .....        ",
};

/* --------------------------------------------------- */

const char *contrast_red_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #ff0000",
/* pixels */
"                    ",
"                    ",
"                    ",
"       .....        ",
"     .....aa..      ",
"    ......aaaa..    ",
"   .......aaaaa.    ",
"  ........aaaaaa.   ",
"  ........aaaaaa.   ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
"  ........aaaaaa.   ",
"  ........aaaaaa.   ",
"   .......aaaaa.    ",
"    ......aaaa..    ",
"     .....aa..      ",
"       .....        ",
};

/* --------------------------------------------------- */

const char *contrast_green_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #00ff00",
/* pixels */
"                    ",
"                    ",
"                    ",
"       .....        ",
"     .....aa..      ",
"    ......aaaa..    ",
"   .......aaaaa.    ",
"  ........aaaaaa.   ",
"  ........aaaaaa.   ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
"  ........aaaaaa.   ",
"  ........aaaaaa.   ",
"   .......aaaaa.    ",
"    ......aaaa..    ",
"     .....aa..      ",
"       .....        ",
};

/* --------------------------------------------------- */

const char *contrast_blue_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #0000ff",
/* pixels */
"                    ",
"                    ",
"                    ",
"       .....        ",
"     .....aa..      ",
"    ......aaaa..    ",
"   .......aaaaa.    ",
"  ........aaaaaa.   ",
"  ........aaaaaa.   ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
" .........aaaaaaa.  ",
"  ........aaaaaa.   ",
"  ........aaaaaa.   ",
"   .......aaaaa.    ",
"    ......aaaa..    ",
"     .....aa..      ",
"       .....        ",
};

/* --------------------------------------------------- */

const char *threshold_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #ffffff",
/* pixels */
"                    ",
"                    ",
"                    ",
"         .          ",
"         .          ",
"         .          ",
"    .   ...   .     ",
"     . .a... .      ",
"      .aa....       ",
"     .aaa.....      ",
"    .aaaa......     ",
" ....aaaa.........  ",
"    .aaaa......     ",
"     .aaa.....      ",
"      .aa....       ",
"     . .a... .      ",
"    .   ...   .     ",
"         .          ",
"         .          ",
"         .          ",
};
/* --------------------------------------------------- */

const char *rgb_default_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        6            1",
/* colors */
"  none",
"w c #ffffff",
"k c #000000",
"r c #ff0000",
"g c #00ff00",
"b c #0000ff",
/* pixels */
"                    ",
" rr gg   kk     bb  ",
" rr gg   kk     bb  ",
" rr gg   kk     bb  ",
" rr gg   kk     bb  ",
" rr gg   kk     bb  ",
" rr gg   kk     bb  ",
"  r  g   k      b   ",
"   r g    k    b    ",
"    r g  k    b     ",
"     rg   k  b      ",
"      rg k  b       ",
"       rgkkb        ",
"         kk         ",
"         kk         ",
"         kk         ",
"         kk         ",
"         kk         ",
"         kk         ",
"                    ",
};

/* --------------------------------------------------- */

const char *negative_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20       16            1",
/* colors */
"  none",
"W c #b0b0b0",
"r c #a01010",
"g c #20a010",
"b c #0020a0",
"c c #10a0a0",
"m c #a000a0",
"y c #a0a000",
"W c #ffffff",
"R c #ff0000",
"G c #00ff00",
"B c #0000ff",
"C c #00ffff",
"M c #ff00ff",
"Y c #ffff00",
"k c #000000",
/* pixels */
"                    ",
" YYYYYYYYYYYYYYYYYk ",
" kkYYYYYYYYYkkCCbkB ",
" kkkYYYYYYkkkkCCkBB ",
" YYYYYYYYYYCCCCkRRB ",
" YYYYYkkYYYYCCkRWWW ",
" YYYYYYYYYYYYkRRBWW ",
" YYkkYYYYYYkkWBBBBB ",
" YkkYYYYYYkkWWWBBBB ",
" YYYYYYYYYkBBBBBBBB ",
" MMMMMMMMkGGGGGGGGG ",
" MMMMMMMkGGGGGGGGGG ",
" MMMGMMkGGGGGGGgGGG ",
" MMMCMkGGGGGGGGGgGG ",
" MBMMkgGGRGGGGGGGGG ",
" MMMkGGgGGGGGGGGgGG ",
" MMkGGGGGgGGGGgGGGG ",
" MkGGGGGGGgGGGGGGgG ",
" kGGGGGGGGGGGGGGGGG ",
"                    ",
};

/* --------------------------------------------------- */

const char *enhance_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        16            1",
/* colors */
"  none",
"w c #b0b0b0",
"r c #a01010",
"g c #20a010",
"b c #0020a0",
"c c #10a0a0",
"m c #a000a0",
"y c #a0a000",
"W c #ffffff",
"R c #ff0000",
"G c #00ff00",
"B c #0000ff",
"C c #00ffff",
"M c #ff00ff",
"Y c #ffff00",
"k c #000000",
/* pixels */
"                    ",
" bbbbbbbbbbbbbbbbbk ",
" wwbbbbbbbbbwwrrbkB ",
" wwwbbbbbbwwwwrrkBB ",
" bbbbbbbbbbrrrrkRRB ",
" bbbbbwwbbbbrrkRWWW ",
" bbbbbbbbbbbbkRRBWW ",
" bbwwbbbbbbwkBBBBBB ",
" bwwbbbbbbbkBWBBBBB ",
" bbbbbbbbbkBBBBBBBB ",
" ggggggggkGGGGGGGGG ",
" gggmgggkGGGGGGGGGG ",
" gggrggkGGGGGGGgGGG ",
" gggggkGGGGGGGGGgGG ",
" gyggkgGGRGGGGGGGGG ",
" gggkGGgGGGGGGGGgGG ",
" ggkGGGGGgGGGGgGGGG ",
" gkGGGGGGGgGGGGGGgG ",
" kGGGGGGGGGGGGGGGGG ",
"                    ",
};

/* --------------------------------------------------- */

const char *store_enhancement_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        5            1",
/* colors */
"* c #000000",
". c #606060",
"- c #e0e0e0",
"w c #ffffff",
"  none",
/* pixels */
"                    ",
"  *             *   ",
"  **           **   ",
"  ***         ***   ",
"  ****       ****   ",
"  ** **     ** **   ",
"  **  **   **  **   ",
"  **   *****   **   ",
"  **    ***    **   ",
"  **     *     **   ",
"  **           **   ",
"  **           **   ",
"  **           **   ",
"  **           **   ",
"  **           **   ",
"  **           **   ",
"  **           **   ",
"  **           **   ",
" ****         ****  ",
"                    ",
};

/* --------------------------------------------------- */

const char *restore_enhancement_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        5            1",
/* colors */
"* c #000000",
". c #606060",
"- c #e0e0e0",
"w c #ffffff",
"  none",
/* pixels */
"                    ",
" **************     ",
" ****************   ",
"  **            **  ",
"  **            **  ",
"  **            **  ",
"  **            **  ",
"  **            **  ",
"  **            **  ",
"  ***************   ",
"  *************     ",
"  ** ***            ",
"  **   **           ",
"  **    **          ",
"  **     ***        ",
"  **       **       ",
"  **        ***     ",
"  **         **     ",
" ****        ****   ",
"                    ",
};

/* --------------------------------------------------- */

const char *default_enhancement_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"* c #000000",
". c #606060",
"- c #e0e0e0",
"  none",
/* pixels */
"                    ",
"         *          ",
"         *          ",
"         *          ",
"         *          ",
"         *          ",
"    *    *    *     ",
"    **   *   **     ",
"     **  *  **      ",
" ******* * ******** ",
"     **  *  **      ",
"    **   *   **     ",
"    *    *    *     ",
"         *          ",
"         *          ",
"         *          ",
"         *          ",
"         *          ",
"         *          ",
"                    ",
};

/* --------------------------------------------------- */

const char *pipette_white_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #ffffff",
/* pixels */
"                    ",
"                    ",
"              ....  ",
"             ...... ",
"             ...... ",
"          ......... ",
"            ......  ",
"           .aaa..   ",
"          .aaaa..   ",
"         .aaaa. .   ",
"        .aaaa.  .   ",
"       .aaaa.       ",
"      .aaaa.        ",
"     .aaaa.         ",
"    .aaaa.          ",
"   .aaaa.           ",
"  .aaaa.            ",
" .aaaa.             ",
" .aaa.              ",
"  ...               ",
};

/* --------------------------------------------------- */

const char *pipette_gray_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
". c #000000",
"  none",
"a c #ffffff",
"X c #808080",
/* pixels */
"                    ",
"                    ",
"              ....  ",
"             ...... ",
"             ...... ",
"          ......... ",
"            ......  ",
"           .aaa..   ",
"          .aaaa..   ",
"         .aaaa. .   ",
"        .XXXX.  .   ",
"       .XXXX.       ",
"      .XXXX.        ",
"     .XXXX.         ",
"    .XXXX.          ",
"   .XXXX.           ",
"  .XXXX.            ",
" .XXXX.             ",
" .XXX.              ",
"  ...               ",
};


const char *pipette_black_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #ffffff",
/* pixels */
"                    ",
"                    ",
"              ....  ",
"             ...... ",
"             ...... ",
"          ......... ",
"            ......  ",
"           .aaa..   ",
"          .aaaa..   ",
"         .aaaa. .   ",
"        ......  .   ",
"       ......       ",
"      ......        ",
"     ......         ",
"    ......          ",
"   ......           ",
"  ......            ",
" ......             ",
" .....              ",
"  ...               ",
};

/* --------------------------------------------------- */

const char *zoom_in_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"  none",
". c #000000",
"+ c #c0c0c0",
"a c #ffffff",
/* pixels */
"                    ",
"                    ",
"     .....          ",
"    .+aaaa.         ",
"   .++aaaaa.        ",
"  .+++aaaaaa.       ",
"  .aaaaaaaaa.       ",
"  .aaaaaaaaa.       ",
"  .aaaaaaaaa.       ",
"   .aaaaaaa.        ",
"    .aaaaa.         ",
"     .......        ",
"          ...       ",
"    .      ...      ",
"    .       ...     ",
"  .....      ...    ",
"    .         ...   ",
"    .          ..   ",
"                    ",
"                    ",
};

/* --------------------------------------------------- */

const char *zoom_not_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"  none",
". c #000000",
"+ c #c0c0c0",
"a c #ffffff",
/* pixels */
"                    ",
"                    ",
" ..  .....       .. ",
"  ...+aaaa.     ..  ",
"   ..+aaaaa.   ..   ",
"  .+..aaaaaa. ..    ",
"  .aa..aaaaa...     ",
"  .aaa..aaaa..      ",
"  .aaaa..aa..       ",
"   .aaaa....        ",
"    .aaaa..         ",
"     .......        ",
"       .. ...       ",
"      ..   ...      ",
"     ..     ...     ",
"    ..       ...    ",
"   ..         ...   ",
"  ..           ..   ",
"                    ",
"                    ",
};

/* --------------------------------------------------- */

const char *zoom_undo_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"  none",
". c #000000",
"+ c #c0c0c0",
"a c #ffffff",
/* pixels */
"                    ",
"                    ",
"     .....          ",
"    .+aaaa.         ",
"   .++aaaaa.        ",
"  .+++aaaaaa.       ",
"  .aaaaaaaaa.       ",
"  .aaaaaaaaa.       ",
"  .aaaaaaaaa.       ",
"   .aaaaaaa.        ",
"    .aaaaa.         ",
"     .......        ",
"          ...       ",
"                    ",
" .  . .  . ..   ..  ",
" .  . .. . . . .  . ",
" .  . .... . . .  . ",
" .  . . .. . . .  . ",
"  ..  .  . ..   ..  ",
"                    ",
};

/* --------------------------------------------------- */

const char *zoom_out_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"  none",
". c #000000",
"+ c #c0c0c0",
"a c #ffffff",
/* pixels */
"                    ",
"                    ",
"     .....          ",
"    .+aaaa.         ",
"   .++aaaaa.        ",
"  .+++aaaaaa.       ",
"  .aaaaaaaaa.       ",
"  .aaaaaaaaa.       ",
"  .aaaaaaaaa.       ",
"   .aaaaaaa.        ",
"    .aaaaa.         ",
"     .......        ",
"          ...       ",
"           ...      ",
"            ...     ",
"  .....      ...    ",
"              ...   ",
"               ..   ",
"                    ",
"                    ",
};

/* --------------------------------------------------- */

const char *full_preview_area_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"  none",
". c #000000",
"+ c #c0c0c0",
"a c #ffffff",
/* pixels */
"                    ",
" .................  ",
" .               .  ",
" .       .       .  ",
" .      ...      .  ",
" .     . . .     .  ",
" .       .       .  ",
" .       .       .  ",
" .   .   .   .   .  ",
" .  .    .    .  .  ",
" . ............. .  ",
" .  .    .    .  .  ",
" .   .   .   .   .  ",
" .       .       .  ",
" .       .       .  ",
" .     . . .     .  ",
" .      ...      .  ",
" .       .       .  ",
" .................  ",
"                    ",
};

/* --------------------------------------------------- */

const char *auto_select_preview_area_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"  none",
". c #000000",
"+ c #c0c0c0",
"a c #ffffff",
/* pixels */
"                    ",
" .................  ",
" .       .       .  ",
" .     . . .     .  ",
" .      ...      .  ",
" .       .       .  ",
" .    .......    .  ",
" .    .     .    .  ",
" . .  .     .  . .  ",
" .  . .     . .  .  ",
" ......     ......  ",
" .  . .     . .  .  ",
" . .  .     .  . .  ",
" .    .......    .  ",
" .       .       .  ",
" .      ...      .  ",
" .     . . .     .  ",
" .       .       .  ",
" .................  ",
"                    ",
};

/* --------------------------------------------------- */

const char *delete_images_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
"  none",
". c #000000",
"+ c #c0c0c0",
"a c #ffffff",
/* pixels */
"      ........      ",
"     ..........     ",
"    ............    ",
"   ...   ..   ...   ",
"   ...   ..   ...   ",
"   ..............   ",
"    .....  .....    ",
"     ..........     ",
"      ........      ",
"       ......       ",
"       ......       ",
"..     ......     ..",
"....    ....    ....",
"   ...        ...   ",
"      ...  ...      ",
"        ....        ",
"      ...  ...      ",
"   ...        ...   ",
"....            ....",
"..                ..",
};

/* --------------------------------------------------- */

const char *printer_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
". c #000000",
"# c #7f7f7f",
"  none",
"b c #ffffff",
/* pixels */
"                    ",
"                    ",
"                    ",
"                    ",
"   .........        ",
"   .bbbbbbb..       ",
"   .bbbbbbb.b.      ",
"   .bbbbbbb....     ",
"   .bbbbbbbbbb.     ",
"   .bbbbbbbbbb.     ",
"   .bbbbbbbbbb.     ",
"   .bbbbbbbbbb.     ",
"   .bbbbbbbbbb...   ",
"  ............. ..  ",
" ..###########.. .  ",
" .             . .  ",
" .             . .  ",
" .bbbbbbbbbbbbb. .  ",
" .#############..   ",
"  ..............    ",
};

/* --------------------------------------------------- */

const char *zoom_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #ffffff",
/* pixels */
"                    ",
"                    ",
"     .............. ",
"     .aaaaaaaaaaaa. ",
"     .aaaaaaaaaaaa. ",
"     .aaaaaaaaaaaa. ",
"     .aaaaaaaaaaaa. ",
"     .aaaaaaaaaaaa. ",
"     .aaa....aaaaa. ",
"     .aaaa...aaaaa. ",
"     .aaa....aaaaa. ",
"     .aa...a.aaaaa. ",
"     .aaa.aaaaaaaa. ",
" .......aaaaaaaaaa. ",
" .aaaaa.aaaaaaaaaa. ",
" .aaaaa............ ",
" .aaaaa.            ",
" .aaaaa.            ",
" .aaaaa.            ",
" .......            ",
};

/* --------------------------------------------------- */

const char *zoom_x_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
". c #000000",
"  none",
"a c #ffffff",
"# c #4040ff",
/* pixels */
"                    ",
"                    ",
"     .............. ",
"     .aaaaaaaaaaaa. ",
"     .aaaaaaaaaaaa. ",
"     .aaaaaaaaaaaa. ",
"     .aaaaaaaaaaaa. ",
"     .aaaaaaaaaaaa. ",
"     .aaa....aaaaa. ",
"     .aaaa...aaaaa. ",
"     .aaa....aaaaa. ",
"     .aa...a.aaaaa. ",
"     .aaa           ",
" .......a  ##    ## ",
" .aaaaa.a   ##  ##  ",
" .aaaaa..    ####   ",
" .aaaaa.      ##    ",
" .aaaaa.     ####   ",
" .aaaaa.    ##  ##  ",
" .......   ##    ## ",
};

/* --------------------------------------------------- */

const char *zoom_y_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
". c #000000",
"  none",
"a c #ffffff",
"# c #4040ff",
/* pixels */
"                    ",
"                    ",
"     .............. ",
"     .aaaaaaaaaaaa. ",
"     .aaaaaaaaaaaa. ",
"     .aaaaaaaaaaaa. ",
"     .aaaaaaaaaaaa. ",
"     .aaaaaaaaaaaa. ",
"     .aaa....aaaaa. ",
"     .aaaa...aaaaa. ",
"     .aaa....aaaaa. ",
"     .aa...a.aaaaa. ",
"     .aaa           ",
" .......a  ##    ## ",
" .aaaaa.a   ##  ##  ",
" .aaaaa..    ####   ",
" .aaaaa.      ##    ",
" .aaaaa.      ##    ",
" .aaaaa.      ##    ",
" .......      ##    ",
};

/* --------------------------------------------------- */

const char *resolution_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        2            1",
/* colors */
". c #000000",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"   ...     ..       ",
"  .....   ....   .  ",
" ....... ...... ... ",
" .......  ....   .  ",
" .......   ..       ",
"  .....             ",
"   ...     ..    .  ",
"          ....  ... ",
"   ..     ....   .  ",
"  ....     ..       ",
" ......             ",
"  ....     ..    .  ",
"   ..     ....      ",
"           ..    .  ",
"   ..               ",
"  ....     ..    .  ",
"   ..      ..       ",
};

/* --------------------------------------------------- */

const char *resolution_x_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"# c #4040ff",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"   ...     ..       ",
"  .....   ....   .  ",
" ....... ...... ... ",
" .......  ....   .  ",
" .......   ..       ",
"  .....             ",
"   ...     ..    .  ",
"          ....  ... ",
"   ..     ....   .  ",
"  ....              ",
" ......    ##    ## ",
"  ....      ##  ##  ",
"   ..        ####   ",
"              ##    ",
"   ..        ####   ",
"  ....      ##  ##  ",
"   ..      ##    ## ",
};

/* --------------------------------------------------- */

const char *resolution_y_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"# c #4040ff",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"   ...     ..       ",
"  .....   ....   .  ",
" ....... ...... ... ",
" .......  ....   .  ",
" .......   ..       ",
"  .....             ",
"   ...     ..    .  ",
"          ....  ... ",
"   ..     ....   .  ",
"  ....              ",
" ......    ##    ## ",
"  ....      ##  ##  ",
"   ..        ####   ",
"              ##    ",
"   ..         ##    ",
"  ....        ##    ",
"   ..         ##    ",
};

/* --------------------------------------------------- */

const char *scanner_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #ffffff",
/* pixels */
"                    ",
"                    ",
"                    ",
"                    ",
"                    ",
"   ..               ",
"   ....             ",
"      ....          ",
"         ....       ",
"            ....    ",
"               ...  ",
"               .... ",
"   ................ ",
"  .aaaa.a.a.a.a.aa. ",
" .aaaaa.a.a.a.a.aa. ",
" .aaaaaaaaaaaaaaaa. ",
" .aaaaaaaaaaaaaaaa. ",
" .aaaaaaaaaaaaaaaa. ",
"  ................. ",
" .................. ",
};

/* --------------------------------------------------- */

const char *intensity_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #ffffff",
/* pixels */
"                    ",
" .................. ",
" .aaaaaaaaaaaaaaaa. ",
" .aaaaaaaaaaaaaaaa. ",
" .aaaa........aaaa. ",
" .aaaaaaa..aaaaaaa. ",
" .aaaaaaa..aaaaaaa. ",
" .aaaaaaa..aaaaaaa. ",
" .aaaaaaa..aaaaaaa. ",
" .aaaaaaa..aaaaaaa. ",
" .aaaaaaa..aaaaaaa. ",
" .aaaaaaa..aaaaaaa. ",
" .aaaaaaa..aaaaaaa. ",
" .aaaaaaa..aaaaaaa. ",
" .aaaaaaa..aaaaaaa. ",
" .aaaa........aaaa. ",
" .aaaaaaaaaaaaaaaa. ",
" .aaaaaaaaaaaaaaaa. ",
" .................. ",
"                    ",
};

/* --------------------------------------------------- */

const char *red_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #ff2020",
/* pixels */
"                    ",
" .................. ",
" .aaaaaaaaaaaaaaaa. ",
" .aaaaaaaaaaaaaaaa. ",
" .aa..........aaaa. ",
" .aa...........aaa. ",
" .aa..aaaaaaaa..aa. ",
" .aa..aaaaaaaa..aa. ",
" .aa..aaaaaaaa..aa. ",
" .aa...........aaa. ",
" .aa..........aaaa. ",
" .aa..aaaa..aaaaaa. ",
" .aa..aaaaa..aaaaa. ",
" .aa..aaaaaa..aaaa. ",
" .aa..aaaaaaa..aaa. ",
" .aa..aaaaaaa..aaa. ",
" .aaaaaaaaaaaaaaaa. ",
" .aaaaaaaaaaaaaaaa. ",
" .................. ",
"                    ",
};

/* --------------------------------------------------- */

const char *green_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #20ff20",
/* pixels */
"                    ",
" .................. ",
" .aaaaaaaaaaaaaaaa. ",
" .aaaaaaaaaaaaaaaa. ",
" .aaaaa.......aaaa. ",
" .aaa...........aa. ",
" .aaa..aaaaaaa..aa. ",
" .aaa..aaaaaaaaaaa. ",
" .aaa..aaaaaaaaaaa. ",
" .aaa..aaa.....aaa. ",
" .aaa..aaa......aa. ",
" .aaa..aaaaaaa..aa. ",
" .aaa..aaaaaaa..aa. ",
" .aaa..aaaaaaa..aa. ",
" .aaaa.........aaa. ",
" .aaaaa.......aaaa. ",
" .aaaaaaaaaaaaaaaa. ",
" .aaaaaaaaaaaaaaaa. ",
" .................. ",
"                    ",
};

/* --------------------------------------------------- */

const char *blue_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
". c #000000",
"  none",
"a c #3030ff",
/* pixels */
"                    ",
" .................. ",
" .aaaaaaaaaaaaaaaa. ",
" .aaaaaaaaaaaaaaaa. ",
" .aa...........aaa. ",
" .aa............aa. ",
" .aa..aaaaaaaa..aa. ",
" .aa..aaaaaaaa..aa. ",
" .aa..aaaaaaaa..aa. ",
" .aa...........aaa. ",
" .aa...........aaa. ",
" .aa..aaaaaaaa..aa. ",
" .aa..aaaaaaaa..aa. ",
" .aa..aaaaaaaa..aa. ",
" .aa............aa. ",
" .aa...........aaa. ",
" .aaaaaaaaaaaaaaaa. ",
" .aaaaaaaaaaaaaaaa. ",
" .................. ",
"                    ",
};

/* --------------------------------------------------- */

const char *pixel_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        3            1",
/* colors */
"a c #000000",
"  none",
". c #ffffff",
/* pixels */
"                    ",
"                    ",
"                    ",
"     a          .   ",
"    a a        .    ",
"       a      .     ",
"   a    a a  .      ",
"         a  .       ",
"  a        .        ",
"          .         ",
"         .          ",
"        .      a    ",
"       .    aaaa    ",
"      .     aaaa a  ",
"     .   a  aaaaaa  ",
"    .  a aaaaaaaaa  ",
"   .  aaaaaaaaaaaa  ",
"                    ",
"                    ",
"                    ",
};

/* --------------------------------------------------- */

const char *log_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        2            1",
/* colors */
". c #000000",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"                    ",
"                    ",
" .      ..     ...  ",
" .     .  .   .   . ",
" .    .    .  .     ",
" .    .    .  .     ",
" .    .    .  .     ",
" .    .    .  . ... ",
" .    .    .  .   . ",
" .    .    .  .   . ",
" .    .    .  .   . ",
" .     .  .   .   . ",
" ....   ..     ...  ",
"                    ",
"                    ",
"                    ",
"                    ",
};

/* --------------------------------------------------- */

const char *move_up_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        2            1",
/* colors */
". c #000000",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"          .         ",
"         ...        ",
"         ...        ",
"        . . .       ",
"        . . .       ",
"       .  .  .      ",
"       .  .  .      ",
"          .         ",
"          .         ",
"          .         ",
"          .         ",
"          .         ",
"          .         ",
"          .         ",
"                    ",
"                    ",
"                    ",
};

/* --------------------------------------------------- */

const char *move_down_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        2            1",
/* colors */
". c #000000",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"          .         ",
"          .         ",
"          .         ",
"          .         ",
"          .         ",
"          .         ",
"          .         ",
"       .  .  .      ",
"       .  .  .      ",
"        . . .       ",
"        . . .       ",
"         ...        ",
"         ...        ",
"          .         ",
"                    ",
"                    ",
"                    ",
};

/* --------------------------------------------------- */

const char *scanning_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
". c #808080",
"+ c #000000",
"- c #ffffff",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"       +++++        ",
"      ++....+       ",
"     ++......+      ",
"    ++........+     ",
"    +..........-    ",
"    +..........-    ",
"    +..........-    ",
"    +..........-    ",
"     -........--    ",
"      -......--     ",
"       -....--      ",
"        -----       ",
"                    ",
"                    ",
"                    ",
"                    ",
"                    ",
};

/* --------------------------------------------------- */

const char *invalid_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
". c #ff0000",
"+ c #000000",
"- c #ffffff",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"       +++++        ",
"      ++....+       ",
"     ++......+      ",
"    ++........+     ",
"    +..........-    ",
"    +..........-    ",
"    +..........-    ",
"    +..........-    ",
"     -........--    ",
"      -......--     ",
"       -....--      ",
"        -----       ",
"                    ",
"                    ",
"                    ",
"                    ",
"                    ",
};

/* --------------------------------------------------- */

const char *valid_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
". c #00ff00",
"+ c #000000",
"- c #ffffff",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"       +++++        ",
"      ++....+       ",
"     ++......+      ",
"    ++........+     ",
"    +..........-    ",
"    +..........-    ",
"    +..........-    ",
"    +..........-    ",
"     -........--    ",
"      -......--     ",
"       -....--      ",
"        -----       ",
"                    ",
"                    ",
"                    ",
"                    ",
"                    ",
};

/* --------------------------------------------------- */

const char *incomplete_xpm[] =
{
/* width height num_colors chars_per_pixel */
"    20    20        4            1",
/* colors */
". c #ffff00",
"+ c #000000",
"- c #ffffff",
"  none",
/* pixels */
"                    ",
"                    ",
"                    ",
"       +++++        ",
"      ++....+       ",
"     ++......+      ",
"    ++........+     ",
"    +..........-    ",
"    +..........-    ",
"    +..........-    ",
"    +..........-    ",
"     -........--    ",
"      -......--     ",
"       -....--      ",
"        -----       ",
"                    ",
"                    ",
"                    ",
"                    ",
"                    ",
};

/* --------------------------------------------------- */

const unsigned char cursor_pipette_white[] =
{
   0x00, 0x70, 0x00, 0xf8, 0x80, 0xff, 0x00, 0xfe, 0x00, 0x7d, 0x80, 0x38,
   0x40, 0x18, 0x20, 0x14, 0x10, 0x12, 0x08, 0x01, 0x84, 0x00, 0x44, 0x00,
   0x32, 0x00, 0x09, 0x00, 0x04, 0x00, 0x00, 0x00
};

/* --------------------------------------------------- */

const unsigned char cursor_pipette_black[] =
{
   0x00, 0x70, 0x00, 0xf8, 0x80, 0xff, 0x00, 0xfe, 0x00, 0x7d, 0x80, 0x38,
   0x40, 0x18, 0xe0, 0x17, 0xf0, 0x13, 0xf8, 0x01, 0xfc, 0x00, 0x7c, 0x00,
   0x3e, 0x00, 0x0f, 0x00, 0x04, 0x00, 0x00, 0x00
};

/* --------------------------------------------------- */

const unsigned char cursor_pipette_gray[] = 
{
   0x00, 0x70, 0x00, 0xf8, 0x80, 0xff, 0x00, 0xfe, 0x00, 0x7d, 0x80, 0x38,
   0x40, 0x18, 0x20, 0x14, 0x10, 0x12, 0xf8, 0x01, 0xfc, 0x00, 0x7c, 0x00,
   0x3e, 0x00, 0x0f, 0x00, 0x04, 0x00, 0x00, 0x00
};

/* --------------------------------------------------- */

const unsigned char cursor_pipette_mask[] =
{
   0x00, 0x70, 0x00, 0xf8, 0x80, 0xff, 0x00, 0xfe, 0x00, 0x7f, 0x80, 0x3f,
   0xc0, 0x1f, 0xe0, 0x17, 0xf0, 0x13, 0xf8, 0x01, 0xfc, 0x00, 0x7c, 0x00,
   0x3e, 0x00, 0x0f, 0x00, 0x04, 0x00, 0x00, 0x00
};

/* --------------------------------------------------- */
