#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "youbin.h"
#include "w_youbin.h"
#include "userdata.h"
#include "resource.h"

BOOL CALLBACK DialogFunc(HWND, UINT, WPARAM, LPARAM);
void enable_password(HWND hdwnd);
void disable_password(HWND hdwnd);
void enable_header_require(HWND hdwnd);
void disable_header_require(HWND hdwnd);
void get_user_data(HWND hdwnd);
void init_dialog(HWND hdwnd);
void reg_write_user();

BOOL CALLBACK DialogFunc(HWND hdwnd, UINT message,
						 WPARAM wParam, LPARAM lParam)
{
	switch(message){
	case WM_INITDIALOG:
		init_dialog(hdwnd);
		return 1;
	case WM_COMMAND:
		switch(LOWORD(wParam)){
		case IDC_BTN_OK:
			get_user_data(hdwnd);
			EndDialog(hdwnd, 1);
			return 1;
		case IDC_BTN_CANCEL:
			EndDialog(hdwnd, 0);
			return 1;
		case IDC_BTN_SAVE:
			get_user_data(hdwnd);
			reg_write_user();
			MessageBox(hdwnd, "¸ޤ", "¸", MB_OK);
			return 1;
		case IDC_RBT_AUTH_NONE:
			disable_password(hdwnd);
			disable_header_require(hdwnd);
			return 1;
		case IDC_RBT_AUTH_ROK:
			disable_password(hdwnd);
			enable_header_require(hdwnd);
			return 1;
		case IDC_RBT_AUTH_PLAIN:
			enable_password(hdwnd);
			enable_header_require(hdwnd);
			return 1;
		case IDC_RBT_AUTH_PGP:
			enable_password(hdwnd);
			enable_header_require(hdwnd);
			return 1;

		}
	}
	return 0;
}

void enable_password(HWND hdwnd)
{
	HWND hdcwnd;

	hdcwnd=GetDlgItem(hdwnd,IDC_STX_PASSWORD);
	EnableWindow(hdcwnd,1);
	hdcwnd=GetDlgItem(hdwnd,IDC_EBX_PASSWORD);
	EnableWindow(hdcwnd,1);
	return;
}

void disable_password(HWND hdwnd)
{
	HWND hdcwnd;

	hdcwnd=GetDlgItem(hdwnd,IDC_STX_PASSWORD);
	EnableWindow(hdcwnd,0);
	hdcwnd=GetDlgItem(hdwnd,IDC_EBX_PASSWORD);
	EnableWindow(hdcwnd,0);
	return;
}

void enable_header_require(HWND hdwnd)
{
	HWND hdcwnd;

	hdcwnd=GetDlgItem(hdwnd,IDC_GBX_HEADER_REQUIRE);
	EnableWindow(hdcwnd,1);
	hdcwnd=GetDlgItem(hdwnd,IDC_CBX_BODY);
	EnableWindow(hdcwnd,1);
	hdcwnd=GetDlgItem(hdwnd,IDC_CBX_FROM);
	EnableWindow(hdcwnd,1);
	hdcwnd=GetDlgItem(hdwnd,IDC_CBX_TO);
	EnableWindow(hdcwnd,1);
	hdcwnd=GetDlgItem(hdwnd,IDC_CBX_SUBJECT);
	EnableWindow(hdcwnd,1);
	hdcwnd=GetDlgItem(hdwnd,IDC_CBX_CC);
	EnableWindow(hdcwnd,1);
	hdcwnd=GetDlgItem(hdwnd,IDC_CBX_DATE);
	EnableWindow(hdcwnd,1);
	return;
}

void disable_header_require(HWND hdwnd)
{
	HWND hdcwnd;

	hdcwnd=GetDlgItem(hdwnd,IDC_GBX_HEADER_REQUIRE);
	EnableWindow(hdcwnd,0);
	hdcwnd=GetDlgItem(hdwnd,IDC_CBX_BODY);
	EnableWindow(hdcwnd,0);
	hdcwnd=GetDlgItem(hdwnd,IDC_CBX_FROM);
	EnableWindow(hdcwnd,0);
	hdcwnd=GetDlgItem(hdwnd,IDC_CBX_TO);
	EnableWindow(hdcwnd,0);
	hdcwnd=GetDlgItem(hdwnd,IDC_CBX_SUBJECT);
	EnableWindow(hdcwnd,0);
	hdcwnd=GetDlgItem(hdwnd,IDC_CBX_CC);
	EnableWindow(hdcwnd,0);
	hdcwnd=GetDlgItem(hdwnd,IDC_CBX_DATE);
	EnableWindow(hdcwnd,0);
	return;
}

void get_user_data(HWND hdwnd)
{
	char d_user_name[USER_NAME_LEN + 1];
	char d_server_name[MAXHOSTNAMELEN + 1];
	char d_password[16] = "";

	/* user name */
	GetDlgItemText(hdwnd, IDC_EBX_USER_NAME,
					d_user_name, USER_NAME_LEN + 1);
	set_user_name(d_user_name);
	/* server name */
	GetDlgItemText(hdwnd, IDC_EBX_SERVER_NAME,
					d_server_name, MAXHOSTNAMELEN + 1);
	set_server_name(d_server_name);
	/* password */
	GetDlgItemText(hdwnd, IDC_EBX_PASSWORD, d_password, 16);
	set_password(d_password);
	/* auth */
	if(SendDlgItemMessage(hdwnd, IDC_RBT_AUTH_NONE,
							BM_GETCHECK,0,0)){
		set_auth(AUTH_NONE);
	}else if(SendDlgItemMessage(hdwnd, IDC_RBT_AUTH_ROK,
							BM_GETCHECK,0,0)){
		set_auth(AUTH_ROK);
	}else if(SendDlgItemMessage(hdwnd, IDC_RBT_AUTH_PLAIN,
							BM_GETCHECK,0,0)){
		set_auth(AUTH_PLAIN);
	}else if(SendDlgItemMessage(hdwnd, IDC_RBT_AUTH_PGP,
							BM_GETCHECK,0,0)){
		set_auth(AUTH_PGP);
	}else{
		/* default */
		set_auth(AUTH_NONE);
	}
	/* head list */
	reset_head_list();
	if(SendDlgItemMessage(hdwnd, IDC_CBX_BODY, BM_GETCHECK,0,0))
		set_head_list(HEAD_BODY);
	if(SendDlgItemMessage(hdwnd, IDC_CBX_FROM, BM_GETCHECK,0,0))
		set_head_list(HEAD_FROM);
	if(SendDlgItemMessage(hdwnd, IDC_CBX_TO, BM_GETCHECK,0,0))
		set_head_list(HEAD_TO);
	if(SendDlgItemMessage(hdwnd, IDC_CBX_SUBJECT, BM_GETCHECK,0,0))
		set_head_list(HEAD_SUBJECT);
	if(SendDlgItemMessage(hdwnd, IDC_CBX_CC, BM_GETCHECK,0,0))
		set_head_list(HEAD_CC);
	if(SendDlgItemMessage(hdwnd, IDC_CBX_DATE, BM_GETCHECK,0,0))
		set_head_list(HEAD_DATE);
	/* dlg_check */
	if(SendDlgItemMessage(hdwnd, IDC_CBX_DLGCHECK, BM_GETCHECK,0,0))
		set_dlg_check(TRUE);
	else
		set_dlg_check(FALSE);
}

void init_dialog(HWND hdwnd)
{
	char d_user_name[USER_NAME_LEN + 1];
	char d_server_name[MAXHOSTNAMELEN + 1];
	char d_password[16] = "";
	int d_auth;

	/* user name */
	get_user_name(d_user_name);
	SetDlgItemText(hdwnd, IDC_EBX_USER_NAME, d_user_name);
	/* server name */
	get_server_name(d_server_name);
	SetDlgItemText(hdwnd, IDC_EBX_SERVER_NAME, d_server_name);
	/* auth and  password */
	get_password(d_password);
	SetDlgItemText(hdwnd, IDC_EBX_PASSWORD, d_password);
	d_auth = check_auth();
	switch(d_auth)
	{
	case AUTH_NONE:
		SendDlgItemMessage(hdwnd,IDC_RBT_AUTH_NONE,BM_SETCHECK,1,0);
		disable_password(hdwnd);
		disable_header_require(hdwnd);
		break;
	case AUTH_ROK:
		SendDlgItemMessage(hdwnd,IDC_RBT_AUTH_ROK,BM_SETCHECK,1,0);
		disable_password(hdwnd);
		enable_header_require(hdwnd);
		break;
	case AUTH_PLAIN:
		SendDlgItemMessage(hdwnd,IDC_RBT_AUTH_PLAIN,BM_SETCHECK,1,0);
		enable_password(hdwnd);
		enable_header_require(hdwnd);
		break;
	case AUTH_PGP:
		SendDlgItemMessage(hdwnd,IDC_RBT_AUTH_PGP,BM_SETCHECK,1,0);
		enable_password(hdwnd);
		enable_header_require(hdwnd);
		break;
	default:
		SendDlgItemMessage(hdwnd,IDC_RBT_AUTH_NONE,BM_SETCHECK,1,0);
		disable_password(hdwnd);
		disable_header_require(hdwnd);
	}
	/* head list */
	if(check_head_list(HEAD_BODY) == 1)
		SendDlgItemMessage(hdwnd,IDC_CBX_BODY,BM_SETCHECK,1,0);
	if(check_head_list(HEAD_FROM) == 1)
		SendDlgItemMessage(hdwnd,IDC_CBX_FROM,BM_SETCHECK,1,0);
	if(check_head_list(HEAD_TO) == 1)
		SendDlgItemMessage(hdwnd,IDC_CBX_TO,BM_SETCHECK,1,0);
	if(check_head_list(HEAD_SUBJECT) == 1)
		SendDlgItemMessage(hdwnd,IDC_CBX_SUBJECT,BM_SETCHECK,1,0);
	if(check_head_list(HEAD_CC) == 1)
		SendDlgItemMessage(hdwnd,IDC_CBX_CC,BM_SETCHECK,1,0);
	if(check_head_list(HEAD_DATE) == 1)
		SendDlgItemMessage(hdwnd,IDC_CBX_DATE,BM_SETCHECK,1,0);
	/* dlg_check */
	if(get_dlg_check() == TRUE)
		SendDlgItemMessage(hdwnd,IDC_CBX_DLGCHECK,BM_SETCHECK,1,0);

}
