(***********************************************************************)
(*                               Zoggy                                 *)
(*                                                                     *)
(*            Maxence Guesdon, projet Cristal, INRIA Rocquencourt      *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the Q Public License version 1.0.               *)
(*                                                                     *)
(***********************************************************************)

open Zog_types

let buffer = ref (None : gui_element option)

let rec copy_gui_ele ele =
  { ele with
    name = ele.name ;
    props = List.map (fun p -> { p with prop_value = p.prop_value }) ele.props ;
    children = List.map copy_gui_ele ele.children
  } 

let copy ele = buffer := Some (copy_gui_ele ele)

let paste () = 
  match !buffer with
    None -> None 
  | Some e -> Some (copy_gui_ele e)
