(***********************************************************************)
(*                               Zoggy                                 *)
(*                                                                     *)
(*            Maxence Guesdon, projet Cristal, INRIA Rocquencourt      *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the Q Public License version 1.0.               *)
(*                                                                     *)
(***********************************************************************)

(** Main module of the standalone tool. *)

let _ = Zog_args.parse ()

let _ = match !Zog_args.file with
  None ->
    prerr_endline Zog_messages.usage ;
    exit 1
| Some file ->
    (
     ignore (GMain.Main.init ()) ;
     let data = new Zog_data.data file in
     let gui = new Zog_gui.gui data in
     let window = GWindow.window 
	 ~title: (Zog_messages.software^" : "^data#file)
	 ~width: 150 ~height: 250
	 () 
     in
     ignore (window#add gui#box#coerce) ;
     ignore (gui#box#connect#destroy window#destroy) ;
     ignore (window#connect#destroy GMain.Main.quit) ;
     ignore (gui#init_window window) ;
     ignore (window#show ()) ;
     GMain.Main.main ()
    )
