use strict;
use warnings;

use RT::Test tests => undef;
use Test::Warn;

my ($base, $m) = RT::Test->started_ok;

my $ticket = RT::Test->create_ticket(
    Queue   => 'General',
    Subject => 'test ticket A',
);
my $id = $ticket->id;
ok $id, "created ticket";

my @links = (
    'javascript:alert("xss")',
    'data:text/html,<script>alert("xss")</script>',
);

for my $link ( map { ($_, ucfirst $_) } @links ) {
    my ($ok, $msg);
    warnings_like {
        ($ok, $msg) = $ticket->AddLink(
            Type    => 'RefersTo',
            Target  => $link,
        );
    } [qr/Could not determine a URI scheme/];
    ok !$ok, $msg;

    ok $m->login, "logged in";
    $m->get_ok($base);
    $m->follow_link_ok({ text => 'test ticket A' }, 'ticket page');
    $m->follow_link_ok({ text => 'Links' }, 'links page');
    $m->submit_form_ok({
        with_fields => {
            "$id-RefersTo" => $link,
        },
        button  => 'SubmitTicket',
    }, 'submitted links page');
    $m->content_contains("Couldn&#39;t resolve ");
    $m->next_warning_like(qr/Could not determine a URI scheme/, 'expected warning');

    my $element = $m->find_link( url => $link );
    ok !$element, "no <a> link";
}

$m->no_leftover_warnings_ok;

done_testing;
