# 2020-12-24 Triage Log

Major event this week is landing PGO for rustc (on x86_64-unknown-linux-gnu). We
expect other platforms to follow but further investigation will be needed,
especially for cross-compiled platforms. We expect to add LLVM PGO as well.

Triage done by **@simulacrum**.
Revision range: [e1cce06e4ff5206daf397e1dcf91ed53653be171..c34c015fe2710caf53ba7ae9d1644f9ba65a6f74](https://perf.rust-lang.org/?start=e1cce06e4ff5206daf397e1dcf91ed53653be171&end=c34c015fe2710caf53ba7ae9d1644f9ba65a6f74&absolute=false&stat=instructions%3Au)

3 Regressions, 5 Improvements

#### Regressions

Rollup of 11 pull requests [#80105](https://github.com/rust-lang/rust/issues/80105)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a6491be5be9344a325b7e49b0114f3cf67ef199e&end=9b84d36a0b9ea3bf305f36f08d50aa42c26f96c2&stat=instructions:u) (up to 3.4% on `full` builds of `match-stress-enum-check`)
- Due to implementing `if let` guards in [#79051](https://github.com/rust-lang/rust/issues/79051)

Revert "cg_llvm: `fewer_names` in `uncached_llvm_type`" [#80122](https://github.com/rust-lang/rust/issues/80122)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=eb4fc71dc9024f15a0c9cc44bcc10c861e9d585e&end=1954756aa53d03e59e40669eaa47a15d8497c352&stat=instructions:u) (up to 424.2% on `incr-patched: println` builds of `regression-31157-debug`)
- Hopefully temporary fix until LLVM patches are applied. Fairly unfortunate,
  though, to lose this much performance.

or_patterns: implement :pat edition-specific behavior [#80100](https://github.com/rust-lang/rust/issues/80100)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=0c11b93f5a8914a40f619b0a1663baafe029d427&end=29e32120c33d30ff526fc7f4d94ec9fce0dc10c9&stat=instructions:u) (up to 1.3% on `incr-unchanged` builds of `deep-vector-check`)
- Most likely overeagerly queries edition of spans. Left ask for moving that to
  be lazy.

#### Improvements

Make BoundRegion have a kind of BoungRegionKind [#80163](https://github.com/rust-lang/rust/issues/80163)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=29e32120c33d30ff526fc7f4d94ec9fce0dc10c9&end=b1964e60b72c2d10e9fd4e801990f8af3f306ac0&stat=instructions:u) (up to -2.1% on `full` builds of `clap-rs-check`)
- Looks like faster mostly due to a smaller argument size

rustc_query_system: explicitly register reused dep nodes [#80177](https://github.com/rust-lang/rust/issues/80177)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=353f3a38460d3c2222d2ab29143f48595b1a32a9&end=bb1fbbf84455fbad9afd26c17e0f725019322655&stat=instructions:u) (up to -2.4% on `incr-unchanged` builds of `match-stress-enum-check`)
- Almost entirely incremental-only change, as expected.

Turn quadratic time on number of impl blocks into linear time [#78317](https://github.com/rust-lang/rust/issues/78317)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b0e5c7d1fee37f1890455b977495bfe262716701&end=c609b2eaf323186a1167ec1a9ffa69a7d4a5b1b9&stat=instructions:u) (up to -2.0% on `incr-unchanged` builds of `packed-simd-check`)

rustc_query_system: reduce dependency graph memory usage [#79589](https://github.com/rust-lang/rust/issues/79589)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3d10d3e49d9784ba3833ccf5d56d0a4d15bb36f6&end=49b315123e6adb35024437ef7ba408456771c062&stat=instructions:u) (up to -2.3% on `incr-unchanged` builds of `packed-simd-check`)

Utilize PGO for rustc linux dist builds [#80262](https://github.com/rust-lang/rust/issues/80262)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=87eecd40e87cf7e77cee9cfdc79900c83baf6d8f&end=3ffea60dd5a2260004cc4f487401ae7c7db1aa0e&stat=instructions:u) (up to -12.2% on `full` builds of `externs-debug`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=87eecd40e87cf7e77cee9cfdc79900c83baf6d8f&end=3ffea60dd5a2260004cc4f487401ae7c7db1aa0e&stat=instructions:u) (up to 7.4% on `incr-unchanged` builds of `many-assoc-items-check`)
- Instruction counts are not the main target of PGO, and wall times are
  showing the expected 5-20% [wins](https://perf.rust-lang.org/compare.html?start=87eecd40e87cf7e77cee9cfdc79900c83baf6d8f&end=3ffea60dd5a2260004cc4f487401ae7c7db1aa0e&stat=wall-time).
  Note that we expect to improve performance even further by applying PGO to
  LLVM as well.

#### Nags requiring follow up

- or_patterns: implement :pat edition-specific behavior [#80100](https://github.com/rust-lang/rust/issues/80100)
    - Needs follow-up performance fixing patch. https://github.com/rust-lang/rust/pull/80100#issuecomment-750893149
- stdarch is still a major contributor to libcore compile times.

