/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "PythonActionTabPresenter.h"

#include "QtPropertyFieldEditor.h"
#include "ExpandableFieldEditor.h"

// -------------------- constructor --------------------
PythonActionTabPresenter::PythonActionTabPresenter(CamiTKExtensionModelPresenter* presenter, VariantDataModel& dataModel, QWidget* parent) : ActionTabPresenter(presenter, dataModel, parent) {

    //-- advanced fields
    QWidget* expandableWidget = new QWidget();
    QGridLayout* expandableGridLayout = new QGridLayout(expandableWidget);
    expandableGridLayout->setContentsMargins(0, 0, 0, 0);

    QtPropertyFieldEditor* advancedQtPropertyFieldEditor;

    // in Python, custom is not supported (yet)
    QStringList guiType = {"Default Action GUI", "No GUI"};
    QString guiTypeDdescription = R"(You can choose between three types of user interface:<ul>
    <li>
        <b>Default Action GUI</b> will automatically build an interface for your action that will present the parameters to the user. Note that you can constrain to the parameter values (see the <i>Parameters</i> section below) and modify the default value or constraints depending on the currently selected target. This is the <i>easiest</i> way to start your development.
    </li>
    <li>
        <b>No GUI</b> means that your action does not require any user interface, when triggered it will immediately execute its <i>process</i> method.
    </li>)";

    advancedQtPropertyFieldEditor = new QtPropertyFieldEditor(presenter, dataModel["gui"], "User Interface", guiTypeDdescription, "Default Action GUI");
    advancedQtPropertyFieldEditor->setEnumValues(guiType);
    advancedQtPropertyFieldEditor->appendRowTo(expandableGridLayout);

    ExpandableFieldEditor* advancedEditor = new ExpandableFieldEditor(presenter, expandableWidget, dataModel, "Advanced");
    advancedEditor->appendRowTo(actionTabLayout);
}
