import textwrap

import pytest

from debputy.lsprotocol.types import DiagnosticSeverity

from debputy.lsp.languages.lsp_debian_watch import _lint_debian_watch
from debputy.packages import DctrlParser
from debputy.plugin.api.feature_set import PluginProvidedFeatureSet
from lint_tests.lint_tutil import (
    LintWrapper,
)


@pytest.fixture
def line_linter(
    debputy_plugin_feature_set: PluginProvidedFeatureSet,
    lint_dctrl_parser: DctrlParser,
) -> LintWrapper:
    return LintWrapper(
        "/nowhere/debian/watch",
        _lint_debian_watch,
        debputy_plugin_feature_set,
        lint_dctrl_parser,
    )


def test_dwatch_alias_dup(line_linter: LintWrapper) -> None:
    lines = textwrap.dedent(
        """\
    Version: 5

    Source: https://example.org
    MatchingPattern: @ANY_VERSION@
    Versionregex: @ANY_VERSION@
    """
    ).splitlines(keepends=True)

    diagnostics = line_linter(lines)
    diagnostics = [d for d in diagnostics if d.severity == DiagnosticSeverity.Error]
    assert len(diagnostics) == 1
    diag = diagnostics[0]

    msg = 'The field "Matching-Pattern" (via aliases) was used multiple times in this stanza. Please ensure the field is only used once per stanza.'
    assert diag.message == msg
    assert f"{diag.range}" == "4:0-4:12"
