/*
 * DO NOT EDIT THIS FILE. Generated by checkmk.
 * Edit the original source file "test_clean_iso8859_1_cp1252.template" instead.
 * Run `make internals` from the base of the project to regenerate this file.
 */

#include <check.h>

#line 1 "test_clean_iso8859_1_cp1252.template"
/**
 * This file is part of the Detox package.
 *
 * Copyright (c) Doug Harple <detox.dharple@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "builtin_table.h"
#include "clean_string.h"
#include "detox_struct.h"
#include "table.h"

#include "unit_struct.h"

#define DATA_COUNT 5
static struct test_filename data[DATA_COUNT] = {

    {
        .filename   = "safe string",
        .expected_a = "safe string",
        .expected_b = "safe string",
    },
    {
        .filename   = "\x80 euro",
        .expected_a = "\u20AC euro",
        .expected_b = "\u20AC euro",
    },
    {
        .filename   = "\x97 em dash",
        .expected_a = "\u2014 em dash",
        .expected_b = "\u2014 em dash",
    },

    {
        .filename   = "\x81 undefined",
        .expected_a = "- undefined",
        .expected_b = "- undefined",
    },

    {
        .filename   = "\xA1 outside scope",
        .expected_a = "_ outside scope",
        .expected_b = "\xA1 outside scope",
    },
};

START_TEST(test_clean_iso8859_1_cp1252)
{
#line 54
    table_t *table_a;
    table_t *table_b;
    char *output;
    int i;

    table_a = load_builtin_cp1252_table();
    table_b = load_builtin_cp1252_table();

    table_a->default_translation = strdup("_");
    table_b->default_translation = NULL;

    // confirm that our a/b test is still valid
    ck_assert(table_get(table_a, 0xA1) == NULL);
    ck_assert(table_get(table_b, 0xA1) == NULL);

    for (i = 0; i < DATA_COUNT; i++) {
        output = clean_iso8859_1(data[i].filename, table_a);
        ck_assert_str_eq(output, data[i].expected_a);

        output = clean_iso8859_1(data[i].filename, table_b);
        ck_assert_str_eq(output, data[i].expected_b);
    }
}
END_TEST

int main(void)
{
    Suite *s1 = suite_create("Core");
    TCase *tc1_1 = tcase_create("Core");
    SRunner *sr = srunner_create(s1);
    int nf;

    suite_add_tcase(s1, tc1_1);
    tcase_add_test(tc1_1, test_clean_iso8859_1_cp1252);

    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);

    return nf == 0 ? 0 : 1;
}
