//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/peering/armpeering"
	"net/http"
	"net/url"
	"regexp"
)

// ConnectionMonitorTestsServer is a fake server for instances of the armpeering.ConnectionMonitorTestsClient type.
type ConnectionMonitorTestsServer struct {
	// CreateOrUpdate is the fake for method ConnectionMonitorTestsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, peeringServiceName string, connectionMonitorTestName string, connectionMonitorTest armpeering.ConnectionMonitorTest, options *armpeering.ConnectionMonitorTestsClientCreateOrUpdateOptions) (resp azfake.Responder[armpeering.ConnectionMonitorTestsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ConnectionMonitorTestsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, peeringServiceName string, connectionMonitorTestName string, options *armpeering.ConnectionMonitorTestsClientDeleteOptions) (resp azfake.Responder[armpeering.ConnectionMonitorTestsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ConnectionMonitorTestsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, peeringServiceName string, connectionMonitorTestName string, options *armpeering.ConnectionMonitorTestsClientGetOptions) (resp azfake.Responder[armpeering.ConnectionMonitorTestsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByPeeringServicePager is the fake for method ConnectionMonitorTestsClient.NewListByPeeringServicePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByPeeringServicePager func(resourceGroupName string, peeringServiceName string, options *armpeering.ConnectionMonitorTestsClientListByPeeringServiceOptions) (resp azfake.PagerResponder[armpeering.ConnectionMonitorTestsClientListByPeeringServiceResponse])
}

// NewConnectionMonitorTestsServerTransport creates a new instance of ConnectionMonitorTestsServerTransport with the provided implementation.
// The returned ConnectionMonitorTestsServerTransport instance is connected to an instance of armpeering.ConnectionMonitorTestsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConnectionMonitorTestsServerTransport(srv *ConnectionMonitorTestsServer) *ConnectionMonitorTestsServerTransport {
	return &ConnectionMonitorTestsServerTransport{
		srv:                          srv,
		newListByPeeringServicePager: newTracker[azfake.PagerResponder[armpeering.ConnectionMonitorTestsClientListByPeeringServiceResponse]](),
	}
}

// ConnectionMonitorTestsServerTransport connects instances of armpeering.ConnectionMonitorTestsClient to instances of ConnectionMonitorTestsServer.
// Don't use this type directly, use NewConnectionMonitorTestsServerTransport instead.
type ConnectionMonitorTestsServerTransport struct {
	srv                          *ConnectionMonitorTestsServer
	newListByPeeringServicePager *tracker[azfake.PagerResponder[armpeering.ConnectionMonitorTestsClientListByPeeringServiceResponse]]
}

// Do implements the policy.Transporter interface for ConnectionMonitorTestsServerTransport.
func (c *ConnectionMonitorTestsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConnectionMonitorTestsClient.CreateOrUpdate":
		resp, err = c.dispatchCreateOrUpdate(req)
	case "ConnectionMonitorTestsClient.Delete":
		resp, err = c.dispatchDelete(req)
	case "ConnectionMonitorTestsClient.Get":
		resp, err = c.dispatchGet(req)
	case "ConnectionMonitorTestsClient.NewListByPeeringServicePager":
		resp, err = c.dispatchNewListByPeeringServicePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConnectionMonitorTestsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/peeringServices/(?P<peeringServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectionMonitorTests/(?P<connectionMonitorTestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpeering.ConnectionMonitorTest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	peeringServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringServiceName")])
	if err != nil {
		return nil, err
	}
	connectionMonitorTestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectionMonitorTestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, peeringServiceNameParam, connectionMonitorTestNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConnectionMonitorTest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectionMonitorTestsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if c.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/peeringServices/(?P<peeringServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectionMonitorTests/(?P<connectionMonitorTestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	peeringServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringServiceName")])
	if err != nil {
		return nil, err
	}
	connectionMonitorTestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectionMonitorTestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Delete(req.Context(), resourceGroupNameParam, peeringServiceNameParam, connectionMonitorTestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectionMonitorTestsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/peeringServices/(?P<peeringServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectionMonitorTests/(?P<connectionMonitorTestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	peeringServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringServiceName")])
	if err != nil {
		return nil, err
	}
	connectionMonitorTestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectionMonitorTestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, peeringServiceNameParam, connectionMonitorTestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConnectionMonitorTest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectionMonitorTestsServerTransport) dispatchNewListByPeeringServicePager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByPeeringServicePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByPeeringServicePager not implemented")}
	}
	newListByPeeringServicePager := c.newListByPeeringServicePager.get(req)
	if newListByPeeringServicePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/peeringServices/(?P<peeringServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectionMonitorTests`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		peeringServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringServiceName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByPeeringServicePager(resourceGroupNameParam, peeringServiceNameParam, nil)
		newListByPeeringServicePager = &resp
		c.newListByPeeringServicePager.add(req, newListByPeeringServicePager)
		server.PagerResponderInjectNextLinks(newListByPeeringServicePager, req, func(page *armpeering.ConnectionMonitorTestsClientListByPeeringServiceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByPeeringServicePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByPeeringServicePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByPeeringServicePager) {
		c.newListByPeeringServicePager.remove(req)
	}
	return resp, nil
}
