// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type RemoveRouteTableRulesRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* RouteTable ID  */
    RouteTableId string `json:"routeTableId"`

    /* 路由表规则Id列表  */
    RuleIds []string `json:"ruleIds"`
}

/*
 * param regionId: Region ID (Required)
 * param routeTableId: RouteTable ID (Required)
 * param ruleIds: 路由表规则Id列表 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewRemoveRouteTableRulesRequest(
    regionId string,
    routeTableId string,
    ruleIds []string,
) *RemoveRouteTableRulesRequest {

	return &RemoveRouteTableRulesRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/routeTables/{routeTableId}:removeRouteTableRules",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        RouteTableId: routeTableId,
        RuleIds: ruleIds,
	}
}

/*
 * param regionId: Region ID (Required)
 * param routeTableId: RouteTable ID (Required)
 * param ruleIds: 路由表规则Id列表 (Required)
 */
func NewRemoveRouteTableRulesRequestWithAllParams(
    regionId string,
    routeTableId string,
    ruleIds []string,
) *RemoveRouteTableRulesRequest {

    return &RemoveRouteTableRulesRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/routeTables/{routeTableId}:removeRouteTableRules",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        RouteTableId: routeTableId,
        RuleIds: ruleIds,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewRemoveRouteTableRulesRequestWithoutParam() *RemoveRouteTableRulesRequest {

    return &RemoveRouteTableRulesRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/routeTables/{routeTableId}:removeRouteTableRules",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *RemoveRouteTableRulesRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param routeTableId: RouteTable ID(Required) */
func (r *RemoveRouteTableRulesRequest) SetRouteTableId(routeTableId string) {
    r.RouteTableId = routeTableId
}

/* param ruleIds: 路由表规则Id列表(Required) */
func (r *RemoveRouteTableRulesRequest) SetRuleIds(ruleIds []string) {
    r.RuleIds = ruleIds
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r RemoveRouteTableRulesRequest) GetRegionId() string {
    return r.RegionId
}

type RemoveRouteTableRulesResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result RemoveRouteTableRulesResult `json:"result"`
}

type RemoveRouteTableRulesResult struct {
}