#!/usr/bin/env python

import openturns as ot
import persalys

Study_0 = persalys.Study('Study_0')
persalys.Study.Add(Study_0)
t = persalys.Variable('t', 0, '')
meshModel = persalys.GridMeshModel([t], ot.Interval([0], [12]), [20])
dist_z0 = ot.Uniform(100, 150)
z0 = persalys.Input('z0', 100, dist_z0, '')
dist_v0 = ot.Normal(55, 10)
v0 = persalys.Input('v0', 55, dist_v0, '')
dist_m = ot.Normal(80, 8)
m = persalys.Input('m', 80, dist_m, '')
dist_c = ot.Uniform(0, 30)
c = persalys.Input('c', 16, dist_c, '')
z = persalys.Output('z', '')
z2 = persalys.Output('z2', 'fake output')
inputs = [z0, v0, m, c]
outputs = [z, z2]
code = 'from math import exp\n\ndef _exec(z0,v0,m,c):\n    g = 9.81\n    zmin = 0.\n    tau = m / c\n    vinf = -m * g / c\n\n    # mesh nodes\n    t = getMesh().getVertices()\n\n    z = [max(z0 + vinf * t_i[0] + tau * (v0 - vinf) * (1 - exp(-t_i[0] / tau)), zmin) for t_i in t]\n    z2 = [2*max(z0 + vinf * t_i[0] + tau * (v0 - vinf) * (1 - exp(-t_i[0] / tau)), zmin) for t_i in t]\n\n    return z, z2'  # type: ignore # noqa: E501
PhysicalModel_1 = persalys.PythonFieldModel('PhysicalModel_1', meshModel, inputs, outputs, code)
Study_0.add(PhysicalModel_1)
t = persalys.Variable('t', 0, '')
meshModel = persalys.GridMeshModel([t], ot.Interval([0], [1]), [12])
collection = [[[21.7], [20.74], [20.52], [19.82], [20.19], [20.46], [21.92], [25.13], [25.44], [25.9], [25.29], [24.9]],
              [[24.56], [24.04], [22.43], [21.52], [22.2], [22.9], [23.01], [24.47], [26.42], [26.51], [24.54], [23.69]],
              [[22.35], [20.74], [19.95], [20.12], [20.45], [20.72], [22.53], [24.19], [26.33], [27.21], [26.85], [25.24]],
              [[23.74], [22.45], [21.68], [21.49], [21.08], [22.07], [22.47], [23.06], [25.22], [25.83], [23.05], [21.79]],
              [[21.02], [19.89], [19.78], [19.23], [19.2], [20.47], [21.25], [23.7], [24.64], [25.51], [24.34], [22.53]],
              [[21.12], [20.56], [19.75], [19.47], [19.35], [20], [21.1], [23.67], [24.78], [25.76], [25.06], [23.3]],
              [[22.29], [21.62], [20.66], [19.98], [19.84], [20.86], [21.6], [23.25], [26.32], [27.47], [26.86], [26.29]],
              [[24.92], [23.82], [22.33], [21.88], [21.76], [22.4], [23.75], [24.96], [26.74], [27.07], [26.45], [25.08]],
              [[23.04], [22.38], [20.56], [20.72], [20.96], [21.64], [22.47], [24.09], [25.68], [27.07], [25.89], [24.26]],
              [[22.63], [21.45], [20.34], [20.41], [20.91], [21.99], [22.69], [24.57], [25.72], [26.15], [24.72], [23.76]],
              [[22.15], [21.01], [20.37], [20.54], [20.22], [20.91], [22.74], [24.45], [26.55], [25.91], [24.97], [23.71]],
              [[22.39], [20.55], [19.96], [19.75], [20], [21.07], [22.06], [24.11], [25.55], [24.63], [23.57], [23.48]],
              [[21.85], [20.57], [20.37], [20.16], [19.92], [20.88], [21.83], [24.11], [25.36], [25.88], [24.54], [24.17]],
              [[22.6], [22.01], [21.45], [21.15], [21], [21.92], [22.83], [24.17], [24.98], [25.04], [24.53], [21.96]],
              [[21.27], [20.43], [19.2], [19.51], [19.96], [20.92], [21.85], [24.19], [25.95], [26.68], [27.1], [26.04]],
              [[24.57], [23.34], [22.02], [21.38], [21.67], [22.3], [23.45], [25.27], [25.92], [25.41], [24.18], [23.07]],
              [[21.84], [20.81], [20.27], [19.62], [20.64], [21.07], [22.32], [23.77], [25.64], [25.75], [25.23], [23.89]],
              [[22.18], [20.99], [19.73], [19.18], [19.41], [20.21], [21.3], [23.17], [24.79], [25.17], [24.09], [22.54]],
              [[21.6], [21.13], [20.73], [20.86], [21.16], [21.35], [22.99], [24.76], [25.55], [26.88], [26.42], [25.97]],
              [[24.3], [22.24], [21.01], [20.68], [21.8], [22.33], [23.45], [24.92], [25.63], [25.57], [24.48], [23.13]],
              [[21.33], [19.7], [19.3], [19.49], [20.29], [20.32], [21.79], [23.32], [24.66], [24.91], [25.1], [22.96]],
              [[21.86], [21.26], [19.86], [19.79], [20.07], [21.13], [21.96], [24.62], [26.81], [27.31], [26.35], [25.51]],
              [[24.86], [24.07], [23.27], [22.12], [22.56], [23.4], [24.69], [26.33], [26.5], [26.15], [24.52], [23.47]],
              [[21.51], [20.75], [19.47], [19.24], [19.68], [20.71], [21.61], [23.32], [24.92], [26.04], [25.29], [24.42]],
              [[22.68], [21.6], [20.47], [19.91], [20.02], [20.95], [21.41], [23.67], [24.9], [26.17], [25.44], [23.36]],
              [[21.71], [20.98], [20.05], [18.8], [19.13], [19.61], [20.94], [23.73], [25.63], [26.21], [25.78], [25.33]],
              [[24.4], [23.46], [22.19], [21.67], [21.52], [22], [23.69], [25.31], [25.97], [26.35], [25.25], [23.95]],
              [[22.82], [21.75], [20.28], [19.85], [20.98], [21.65], [22.49], [24.33], [25.99], [25.54], [25.03], [23.47]],
              [[22.09], [21.11], [20.03], [19.86], [20.35], [21.99], [23.3], [24.77], [25.7], [26.26], [25.39], [24.13]],
              [[23.29], [22.18], [21.2], [21.3], [21.61], [22.2], [23.25], [24.77], [25.77], [26.61], [25.8], [24.54]],
              [[23.27], [21.52], [20.77], [20.66], [20.36], [21.56], [22.54], [23.48], [25.21], [26.31], [25.03], [24.06]],
              [[22.75], [21.38], [20.52], [19.93], [20.55], [21.41], [23], [24.29], [25.49], [25.21], [24.5], [23.97]],
              [[22.89], [22.47], [21.75], [21.8], [22.94], [24.59], [26.13], [27.42], [28.09], [28.68], [28.56], [28.19]],
              [[27.44], [25.95], [23.78], [22.24], [21.86], [21.9], [23.01], [24.18], [25.18], [26], [25.16], [23.23]],
              [[21.96], [21.24], [20.17], [20.37], [20.52], [21.5], [22.58], [23.59], [24.87], [25.74], [24.25], [22.29]],
              [[21.75], [20.44], [19.29], [19.44], [19.9], [20.69], [22.4], [24.61], [26.06], [25.91], [24.58], [23.38]],
              [[21.98], [21.12], [20.97], [20.44], [21.07], [22.03], [23], [25.3], [27.14], [28.01], [27.17], [25.58]],
              [[24.06], [22.78], [21.73], [21.45], [22.39], [22.63], [23.47], [24.64], [25.74], [25.78], [24.54], [23.6]],
              [[21.27], [20.26], [19.12], [19.19], [19.5], [20.55], [21.8], [24.09], [26.26], [26.66], [25.63], [23.18]],
              [[22], [21.12], [20.32], [19.87], [20.33], [21.31], [22.19], [24.02], [25.88], [26.16], [25.22], [24.05]],
              [[22.68], [21], [20.25], [20.13], [20.28], [20.84], [22.45], [23.86], [25.97], [26.51], [24.99], [24.37]],
              [[23.05], [22.05], [21.08], [20.75], [21.13], [22.18], [23.43], [24.83], [26.68], [27.76], [27.68], [26.31]],
              [[23.82], [21.95], [20.55], [20.06], [20.82], [21.49], [22.48], [24.43], [26.49], [27.17], [26.44], [25.15]],
              [[23.76], [22.06], [21.05], [20.83], [20.99], [21.64], [22.75], [24.32], [25.79], [25.43], [24.32], [23.22]],
              [[22.43], [21.21], [19.7], [20.16], [21.53], [22.41], [23.61], [25.33], [26.43], [26.12], [24.47], [23.1]],
              [[22.45], [21.23], [20.01], [20.17], [20.15], [21.2], [22.02], [23.84], [25.71], [26.09], [23.85], [22.89]],
              [[21.56], [20.02], [19.53], [19.24], [19.95], [20.26], [21.61], [23.67], [25.74], [26.95], [26.64], [26.71]],
              [[26.27], [25.59], [24.8], [24.4], [24.58], [25.63], [26.92], [28.22], [28.98], [29.15], [28.61], [27.69]],
              [[25.18], [23.43], [21.77], [20.87], [21.16], [21.43], [22.56], [23.73], [25.64], [26.62], [24.3], [23.46]],
              [[21.83], [20.44], [19.75], [19.23], [20.05], [20.51], [21.72], [23.86], [25.71], [26.19], [25.84], [24.1]],
              [[22.25], [20.59], [20.1], [19.94], [20.37], [20.6], [22.22], [23.88], [25.91], [27.44], [26.69], [23.77]],
              [[21.74], [20.88], [19.9], [19.39], [19.52], [20.49], [21.96], [23.64], [26.06], [27.53], [26.53], [24.8]],
              [[22.67], [21.01], [19.94], [19.89], [21.16], [22.25], [23.44], [24.38], [25.81], [25.97], [24.44], [22.49]],
              [[21.58], [20.75], [20.14], [20], [20.99], [21.92], [22.99], [24.6], [25.81], [25.94], [25.32], [23.05]]]
mesh = meshModel.getMesh()
pSample = ot.ProcessSample(mesh, collection)
DataFieldModel_0 = persalys.DataFieldModel('DataFieldModel_0', meshModel, pSample)
Study_0.add(DataFieldModel_0)
mcAnalysis = persalys.FieldMonteCarloAnalysis('mcAnalysis', PhysicalModel_1)
interestVariables = ['z']
mcAnalysis.setInterestVariables(interestVariables)
mcAnalysis.setMaximumCalls(10)
mcAnalysis.setMaximumElapsedTime(1000)
mcAnalysis.setBlockSize(5)
mcAnalysis.setSeed(2)
mcAnalysis.setKarhunenLoeveThreshold(2e-05)
mcAnalysis.setQuantileLevel(0.05)
Study_0.add(mcAnalysis)
values = [100, 55, 80, 16]
evaluation = persalys.FieldModelEvaluation('evaluation', PhysicalModel_1, values)
Study_0.add(evaluation)
myAnalysis = persalys.FieldKarhunenLoeveAnalysis('myAnalysis', DataFieldModel_0)
myAnalysis.setKarhunenLoeveThreshold(1e-05)
myAnalysis.setQuantileLevel(0.05)
Study_0.add(myAnalysis)
