/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.image.EntityImageStateCommon;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageStateEmptyDescription
extends EntityImageStateCommon {
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 40;

    public EntityImageStateEmptyDescription(IEntity entity, ISkinParam skinParam) {
        super(entity, skinParam);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.desc.calculateDimension(stringBounder);
        Dimension2D result = Dimension2DDouble.delta(dim, 10.0);
        return Dimension2DDouble.atLeast(result, 50.0, 40.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        ug = this.applyColor(ug);
        ug.draw(this.getShape(dimTotal));
        double xDesc = (dimTotal.getWidth() - dimDesc.getWidth()) / 2.0;
        double yDesc = (dimTotal.getHeight() - dimDesc.getHeight()) / 2.0;
        this.desc.drawU(ug.apply(new UTranslate(xDesc, yDesc)));
        if (this.url != null) {
            ug.closeUrl();
        }
    }
}

