/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.core.Capabilities;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.Estimator;
import weka.estimators.IncrementalEstimator;

public class NormalEstimator
extends Estimator
implements IncrementalEstimator {
    private static final long serialVersionUID = 93584379632315841L;
    private double m_SumOfWeights;
    private double m_SumOfValues;
    private double m_SumOfValuesSq;
    private double m_Mean;
    private double m_StandardDev;
    private double m_Precision;

    private double round(double data) {
        return Math.rint(data / this.m_Precision) * this.m_Precision;
    }

    public NormalEstimator(double precision) {
        this.m_Precision = precision;
        this.m_StandardDev = this.m_Precision / 6.0;
    }

    public void addValue(double data, double weight) {
        if (weight == 0.0) {
            return;
        }
        data = this.round(data);
        this.m_SumOfWeights += weight;
        this.m_SumOfValues += data * weight;
        this.m_SumOfValuesSq += data * data * weight;
        if (this.m_SumOfWeights > 0.0) {
            this.m_Mean = this.m_SumOfValues / this.m_SumOfWeights;
            double stdDev = Math.sqrt(Math.abs(this.m_SumOfValuesSq - this.m_Mean * this.m_SumOfValues) / this.m_SumOfWeights);
            if (stdDev > 1.0E-10) {
                this.m_StandardDev = Math.max(this.m_Precision / 6.0, stdDev);
            }
        }
    }

    public double getProbability(double data) {
        data = this.round(data);
        double zLower = (data - this.m_Mean - this.m_Precision / 2.0) / this.m_StandardDev;
        double zUpper = (data - this.m_Mean + this.m_Precision / 2.0) / this.m_StandardDev;
        double pLower = Statistics.normalProbability(zLower);
        double pUpper = Statistics.normalProbability(zUpper);
        return pUpper - pLower;
    }

    public String toString() {
        return "Normal Distribution. Mean = " + Utils.doubleToString(this.m_Mean, 4) + " StandardDev = " + Utils.doubleToString(this.m_StandardDev, 4) + " WeightSum = " + Utils.doubleToString(this.m_SumOfWeights, 4) + " Precision = " + this.m_Precision + "\n";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        if (!this.m_noClass) {
            result.enable(Capabilities.Capability.NOMINAL_CLASS);
            result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        } else {
            result.enable(Capabilities.Capability.NO_CLASS);
        }
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        return result;
    }

    public double getMean() {
        return this.m_Mean;
    }

    public double getStdDev() {
        return this.m_StandardDev;
    }

    public double getPrecision() {
        return this.m_Precision;
    }

    public double getSumOfWeights() {
        return this.m_SumOfWeights;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5540 $");
    }

    public static void main(String[] argv) {
        try {
            if (argv.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            NormalEstimator newEst = new NormalEstimator(0.01);
            for (int i = 0; i < argv.length; ++i) {
                double current = Double.valueOf(argv[i]);
                System.out.println(newEst);
                System.out.println("Prediction for " + current + " = " + newEst.getProbability(current));
                newEst.addValue(current, 1.0);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

