/**********************************************************************
 * $hello example -- PLI application using VPI routines
 *
 * C source to print "Hello World" as a PLI application.
 *
 * Usage: $hello;
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *********************************************************************/

#include <stdlib.h>    /* ANSI C standard library */
#include <stdio.h>     /* ANSI C standard input/output library */
#include "vpi_user.h"  /* IEEE 1364 PLI VPI routine library  */

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_hello_calltf(char *user_data)
{
  vpi_printf("\nHello World!\n\n");
  return(0);
}

/**********************************************************************
 * $hello Registration Data
 * (add this function name to the vlog_startup_routines array)
 *********************************************************************/
void PLIbook_hello_register()
{
  s_vpi_systf_data tf_data;

  tf_data.type        = vpiSysTask;
  tf_data.tfname      = "$hello";
  tf_data.calltf      = PLIbook_hello_calltf;
  tf_data.compiletf   = NULL;
  tf_data.sizetf      = NULL;
  vpi_register_systf(&tf_data);
}
