# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FacebookChannelProperties(Model):
    """The parameters to provide for the Facebook channel.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar verify_token: Verify token. Value only returned through POST to the
     action Channel List API, otherwise empty.
    :vartype verify_token: str
    :param pages: The list of Facebook pages
    :type pages: list[~azure.mgmt.botservice.models.FacebookPage]
    :param app_id: Required. Facebook application id
    :type app_id: str
    :param app_secret: Required. Facebook application secret. Value only
     returned through POST to the action Channel List API, otherwise empty.
    :type app_secret: str
    :ivar callback_url: Callback Url
    :vartype callback_url: str
    :param is_enabled: Required. Whether this channel is enabled for the bot
    :type is_enabled: bool
    """

    _validation = {
        'verify_token': {'readonly': True},
        'app_id': {'required': True},
        'app_secret': {'required': True},
        'callback_url': {'readonly': True},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'verify_token': {'key': 'verifyToken', 'type': 'str'},
        'pages': {'key': 'pages', 'type': '[FacebookPage]'},
        'app_id': {'key': 'appId', 'type': 'str'},
        'app_secret': {'key': 'appSecret', 'type': 'str'},
        'callback_url': {'key': 'callbackUrl', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(self, *, app_id: str, app_secret: str, is_enabled: bool, pages=None, **kwargs) -> None:
        super(FacebookChannelProperties, self).__init__(**kwargs)
        self.verify_token = None
        self.pages = pages
        self.app_id = app_id
        self.app_secret = app_secret
        self.callback_url = None
        self.is_enabled = is_enabled
