# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, Optional, TypeVar, Union, cast

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._server_vulnerability_assessment_operations import (
    build_create_or_update_request,
    build_delete_request,
    build_get_request,
    build_list_by_extended_resource_request,
)

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ServerVulnerabilityAssessmentOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.security.v2020_01_01.aio.SecurityCenter`'s
        :attr:`server_vulnerability_assessment` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_by_extended_resource(
        self, resource_group_name: str, resource_namespace: str, resource_type: str, resource_name: str, **kwargs: Any
    ) -> _models.ServerVulnerabilityAssessmentsList:
        """Gets a list of server vulnerability assessment onboarding statuses on a given resource.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param resource_namespace: The Namespace of the resource. Required.
        :type resource_namespace: str
        :param resource_type: The type of the resource. Required.
        :type resource_type: str
        :param resource_name: Name of the resource. Required.
        :type resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ServerVulnerabilityAssessmentsList or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2020_01_01.models.ServerVulnerabilityAssessmentsList
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-01-01"))  # type: Literal["2020-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ServerVulnerabilityAssessmentsList]

        request = build_list_by_extended_resource_request(
            resource_group_name=resource_group_name,
            resource_namespace=resource_namespace,
            resource_type=resource_type,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_by_extended_resource.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ServerVulnerabilityAssessmentsList", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_by_extended_resource.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments"}  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, resource_namespace: str, resource_type: str, resource_name: str, **kwargs: Any
    ) -> _models.ServerVulnerabilityAssessment:
        """Gets a server vulnerability assessment onboarding statuses on a given resource.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param resource_namespace: The Namespace of the resource. Required.
        :type resource_namespace: str
        :param resource_type: The type of the resource. Required.
        :type resource_type: str
        :param resource_name: Name of the resource. Required.
        :type resource_name: str
        :keyword server_vulnerability_assessment: ServerVulnerabilityAssessment status. only a
         'default' value is supported. Default value is "default". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype server_vulnerability_assessment: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ServerVulnerabilityAssessment or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2020_01_01.models.ServerVulnerabilityAssessment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        server_vulnerability_assessment = kwargs.pop(
            "server_vulnerability_assessment", "default"
        )  # type: Literal["default"]
        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-01-01"))  # type: Literal["2020-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ServerVulnerabilityAssessment]

        request = build_get_request(
            resource_group_name=resource_group_name,
            resource_namespace=resource_namespace,
            resource_type=resource_type,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            server_vulnerability_assessment=server_vulnerability_assessment,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ServerVulnerabilityAssessment", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}"}  # type: ignore

    @distributed_trace_async
    async def create_or_update(
        self, resource_group_name: str, resource_namespace: str, resource_type: str, resource_name: str, **kwargs: Any
    ) -> _models.ServerVulnerabilityAssessment:
        """Creating a server vulnerability assessment on a resource, which will onboard a resource for
        having a vulnerability assessment on it.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param resource_namespace: The Namespace of the resource. Required.
        :type resource_namespace: str
        :param resource_type: The type of the resource. Required.
        :type resource_type: str
        :param resource_name: Name of the resource. Required.
        :type resource_name: str
        :keyword server_vulnerability_assessment: ServerVulnerabilityAssessment status. only a
         'default' value is supported. Default value is "default". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype server_vulnerability_assessment: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ServerVulnerabilityAssessment or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2020_01_01.models.ServerVulnerabilityAssessment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        server_vulnerability_assessment = kwargs.pop(
            "server_vulnerability_assessment", "default"
        )  # type: Literal["default"]
        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-01-01"))  # type: Literal["2020-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ServerVulnerabilityAssessment]

        request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            resource_namespace=resource_namespace,
            resource_type=resource_type,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            server_vulnerability_assessment=server_vulnerability_assessment,
            api_version=api_version,
            template_url=self.create_or_update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ServerVulnerabilityAssessment", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}"}  # type: ignore

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, resource_namespace: str, resource_type: str, resource_name: str, **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        server_vulnerability_assessment = kwargs.pop(
            "server_vulnerability_assessment", "default"
        )  # type: Literal["default"]
        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-01-01"))  # type: Literal["2020-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_request(
            resource_group_name=resource_group_name,
            resource_namespace=resource_namespace,
            resource_type=resource_type,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            server_vulnerability_assessment=server_vulnerability_assessment,
            api_version=api_version,
            template_url=self._delete_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_initial.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}"}  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, resource_namespace: str, resource_type: str, resource_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Removing server vulnerability assessment from a resource.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param resource_namespace: The Namespace of the resource. Required.
        :type resource_namespace: str
        :param resource_type: The type of the resource. Required.
        :type resource_type: str
        :param resource_name: Name of the resource. Required.
        :type resource_name: str
        :keyword server_vulnerability_assessment: ServerVulnerabilityAssessment status. only a
         'default' value is supported. Default value is "default". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype server_vulnerability_assessment: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        server_vulnerability_assessment = kwargs.pop(
            "server_vulnerability_assessment", "default"
        )  # type: Literal["default"]
        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-01-01"))  # type: Literal["2020-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                resource_namespace=resource_namespace,
                resource_type=resource_type,
                resource_name=resource_name,
                server_vulnerability_assessment=server_vulnerability_assessment,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_delete.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}"}  # type: ignore
