# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import AuthenticationKind, SignalKind

if TYPE_CHECKING:
    from .. import models as _models


class AlertConfiguration(_Model):
    """Alert configuration details.

    :ivar severity: The severity of triggered alert. Required. Known values are: "Sev0", "Sev1",
     "Sev2", "Sev3", and "Sev4".
    :vartype severity: str or ~azure.mgmt.cloudhealth.models.AlertSeverity
    :ivar description: The alert rule description.
    :vartype description: str
    :ivar action_group_ids: Optional list of action group resource IDs to be notified when the
     alert is triggered.
    :vartype action_group_ids: list[str]
    """

    severity: Union[str, "_models.AlertSeverity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The severity of triggered alert. Required. Known values are: \"Sev0\", \"Sev1\", \"Sev2\",
     \"Sev3\", and \"Sev4\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The alert rule description."""
    action_group_ids: Optional[List[str]] = rest_field(
        name="actionGroupIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional list of action group resource IDs to be notified when the alert is triggered."""

    @overload
    def __init__(
        self,
        *,
        severity: Union[str, "_models.AlertSeverity"],
        description: Optional[str] = None,
        action_group_ids: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cloudhealth.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cloudhealth.models.SystemData
    """


class AuthenticationSetting(ProxyResource):
    """An authentication setting in a health model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cloudhealth.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.cloudhealth.models.AuthenticationSettingProperties
    """

    properties: Optional["_models.AuthenticationSettingProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AuthenticationSettingProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AuthenticationSettingProperties(_Model):
    """Authentication setting properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ManagedIdentityAuthenticationSettingProperties

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.cloudhealth.models.HealthModelProvisioningState
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar authentication_kind: Kind of the authentication setting. Required. "ManagedIdentity"
    :vartype authentication_kind: str or ~azure.mgmt.cloudhealth.models.AuthenticationKind
    """

    __mapping__: Dict[str, _Model] = {}
    provisioning_state: Optional[Union[str, "_models.HealthModelProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Creating\", and \"Deleting\"."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name."""
    authentication_kind: str = rest_discriminator(
        name="authenticationKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """Kind of the authentication setting. Required. \"ManagedIdentity\""""

    @overload
    def __init__(
        self,
        *,
        authentication_kind: str,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureMonitorWorkspaceSignalGroup(_Model):
    """A grouping of signal assignments for a Azure Monitor Workspace.

    :ivar signal_assignments: Signal definitions which are assigned to this signal group. All
     assignments are combined with an OR operator.
    :vartype signal_assignments: list[~azure.mgmt.cloudhealth.models.SignalAssignment]
    :ivar authentication_setting: Reference to the name of the authentication setting which is used
     for querying the data source. Required.
    :vartype authentication_setting: str
    :ivar azure_monitor_workspace_resource_id: Azure Monitor workspace resource ID. Required.
    :vartype azure_monitor_workspace_resource_id: str
    """

    signal_assignments: Optional[List["_models.SignalAssignment"]] = rest_field(
        name="signalAssignments", visibility=["read", "create", "update", "delete", "query"]
    )
    """Signal definitions which are assigned to this signal group. All assignments are combined with
     an OR operator."""
    authentication_setting: str = rest_field(
        name="authenticationSetting", visibility=["read", "create", "update", "delete", "query"]
    )
    """Reference to the name of the authentication setting which is used for querying the data source.
     Required."""
    azure_monitor_workspace_resource_id: str = rest_field(
        name="azureMonitorWorkspaceResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure Monitor workspace resource ID. Required."""

    @overload
    def __init__(
        self,
        *,
        authentication_setting: str,
        azure_monitor_workspace_resource_id: str,
        signal_assignments: Optional[List["_models.SignalAssignment"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureResourceSignalGroup(_Model):
    """A grouping of signal assignments for an Azure resource.

    :ivar signal_assignments: Signal definitions which are assigned to this signal group. All
     assignments are combined with an OR operator.
    :vartype signal_assignments: list[~azure.mgmt.cloudhealth.models.SignalAssignment]
    :ivar authentication_setting: Reference to the name of the authentication setting which is used
     for querying the data source. Required.
    :vartype authentication_setting: str
    :ivar azure_resource_id: Azure resource ID. Required.
    :vartype azure_resource_id: str
    """

    signal_assignments: Optional[List["_models.SignalAssignment"]] = rest_field(
        name="signalAssignments", visibility=["read", "create", "update", "delete", "query"]
    )
    """Signal definitions which are assigned to this signal group. All assignments are combined with
     an OR operator."""
    authentication_setting: str = rest_field(
        name="authenticationSetting", visibility=["read", "create", "update", "delete", "query"]
    )
    """Reference to the name of the authentication setting which is used for querying the data source.
     Required."""
    azure_resource_id: str = rest_field(
        name="azureResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource ID. Required."""

    @overload
    def __init__(
        self,
        *,
        authentication_setting: str,
        azure_resource_id: str,
        signal_assignments: Optional[List["_models.SignalAssignment"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DependenciesSignalGroup(_Model):
    """Properties for dependent entities, i.e. child entities.

    :ivar aggregation_type: Aggregation type for child dependencies. Required. Known values are:
     "WorstOf" and "Thresholds".
    :vartype aggregation_type: str or ~azure.mgmt.cloudhealth.models.DependenciesAggregationType
    :ivar degraded_threshold: Degraded threshold for aggregating the propagated health state of
     child dependencies. Can be either an absolute number that is greater than 0, or a percentage
     between 1-100%. The entity will be considered degraded when the number of not healthy child
     dependents (unhealthy, degraded, unknown) is equal to or above the threshold value. Must only
     be set when AggregationType is 'Thresholds'.
    :vartype degraded_threshold: str
    :ivar unhealthy_threshold: Unhealthy threshold for aggregating the propagated health state of
     child dependencies. Can be either an absolute number that is greater than 0, or a percentage
     between 1-100%. The entity will be considered unhealthy when the number of not healthy child
     dependents (unhealthy, degraded, unknown) is equal to or above the threshold value. Must only
     be set when AggregationType is 'Thresholds'.
    :vartype unhealthy_threshold: str
    """

    aggregation_type: Union[str, "_models.DependenciesAggregationType"] = rest_field(
        name="aggregationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Aggregation type for child dependencies. Required. Known values are: \"WorstOf\" and
     \"Thresholds\"."""
    degraded_threshold: Optional[str] = rest_field(
        name="degradedThreshold", visibility=["read", "create", "update", "delete", "query"]
    )
    """Degraded threshold for aggregating the propagated health state of child dependencies. Can be
     either an absolute number that is greater than 0, or a percentage between 1-100%. The entity
     will be considered degraded when the number of not healthy child dependents (unhealthy,
     degraded, unknown) is equal to or above the threshold value. Must only be set when
     AggregationType is 'Thresholds'."""
    unhealthy_threshold: Optional[str] = rest_field(
        name="unhealthyThreshold", visibility=["read", "create", "update", "delete", "query"]
    )
    """Unhealthy threshold for aggregating the propagated health state of child dependencies. Can be
     either an absolute number that is greater than 0, or a percentage between 1-100%. The entity
     will be considered unhealthy when the number of not healthy child dependents (unhealthy,
     degraded, unknown) is equal to or above the threshold value. Must only be set when
     AggregationType is 'Thresholds'."""

    @overload
    def __init__(
        self,
        *,
        aggregation_type: Union[str, "_models.DependenciesAggregationType"],
        degraded_threshold: Optional[str] = None,
        unhealthy_threshold: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiscoveryRule(ProxyResource):
    """A discovery rule which automatically finds entities and relationships in a health model based
    on an Azure Resource Graph query.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cloudhealth.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.cloudhealth.models.DiscoveryRuleProperties
    """

    properties: Optional["_models.DiscoveryRuleProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DiscoveryRuleProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiscoveryRuleProperties(_Model):
    """Discovery rule properties.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.cloudhealth.models.HealthModelProvisioningState
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar resource_graph_query: Azure Resource Graph query text in KQL syntax. The query must
     return at least a column named 'id' which contains the resource ID of the discovered resources.
     Required.
    :vartype resource_graph_query: str
    :ivar authentication_setting: Reference to the name of the authentication setting which is used
     for querying Azure Resource Graph. The same authentication setting will also be assigned to any
     discovered entities. Required.
    :vartype authentication_setting: str
    :ivar discover_relationships: Whether to create relationships between the discovered entities
     based on a set of built-in rules. These relationships cannot be manually deleted. Required.
     Known values are: "Enabled" and "Disabled".
    :vartype discover_relationships: str or
     ~azure.mgmt.cloudhealth.models.DiscoveryRuleRelationshipDiscoveryBehavior
    :ivar add_recommended_signals: Whether to add all recommended signals to the discovered
     entities. Required. Known values are: "Enabled" and "Disabled".
    :vartype add_recommended_signals: str or
     ~azure.mgmt.cloudhealth.models.DiscoveryRuleRecommendedSignalsBehavior
    :ivar deletion_date: Date when the discovery rule was (soft-)deleted.
    :vartype deletion_date: ~datetime.datetime
    :ivar error_message: Error message if the last discovery operation failed.
    :vartype error_message: str
    :ivar number_of_discovered_entities: Number of discovered entities in the last discovery
     operation.
    :vartype number_of_discovered_entities: int
    :ivar entity_name: Name of the entity which represents the discovery rule. Note: It might take
     a few minutes after creating the discovery rule until the entity is created. Required.
    :vartype entity_name: str
    """

    provisioning_state: Optional[Union[str, "_models.HealthModelProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Creating\", and \"Deleting\"."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name."""
    resource_graph_query: str = rest_field(
        name="resourceGraphQuery", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure Resource Graph query text in KQL syntax. The query must return at least a column named
     'id' which contains the resource ID of the discovered resources. Required."""
    authentication_setting: str = rest_field(
        name="authenticationSetting", visibility=["read", "create", "update", "delete", "query"]
    )
    """Reference to the name of the authentication setting which is used for querying Azure Resource
     Graph. The same authentication setting will also be assigned to any discovered entities.
     Required."""
    discover_relationships: Union[str, "_models.DiscoveryRuleRelationshipDiscoveryBehavior"] = rest_field(
        name="discoverRelationships", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether to create relationships between the discovered entities based on a set of built-in
     rules. These relationships cannot be manually deleted. Required. Known values are: \"Enabled\"
     and \"Disabled\"."""
    add_recommended_signals: Union[str, "_models.DiscoveryRuleRecommendedSignalsBehavior"] = rest_field(
        name="addRecommendedSignals", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether to add all recommended signals to the discovered entities. Required. Known values are:
     \"Enabled\" and \"Disabled\"."""
    deletion_date: Optional[datetime.datetime] = rest_field(name="deletionDate", visibility=["read"], format="rfc3339")
    """Date when the discovery rule was (soft-)deleted."""
    error_message: Optional[str] = rest_field(name="errorMessage", visibility=["read"])
    """Error message if the last discovery operation failed."""
    number_of_discovered_entities: Optional[int] = rest_field(name="numberOfDiscoveredEntities", visibility=["read"])
    """Number of discovered entities in the last discovery operation."""
    entity_name: str = rest_field(name="entityName", visibility=["read"])
    """Name of the entity which represents the discovery rule. Note: It might take a few minutes after
     creating the discovery rule until the entity is created. Required."""

    @overload
    def __init__(
        self,
        *,
        resource_graph_query: str,
        authentication_setting: str,
        discover_relationships: Union[str, "_models.DiscoveryRuleRelationshipDiscoveryBehavior"],
        add_recommended_signals: Union[str, "_models.DiscoveryRuleRecommendedSignalsBehavior"],
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DynamicDetectionRule(_Model):
    """ML-based evaluation rule for a signal definition.

    :ivar dynamic_threshold_model: ML model to use for dynamic thresholds. Required.
     "AnomalyDetection"
    :vartype dynamic_threshold_model: str or ~azure.mgmt.cloudhealth.models.DynamicThresholdModel
    :ivar model_sensitivity: ML model sensitivity. Lowest value = high sensitivity. Supported step
     size = 0.5. Required.
    :vartype model_sensitivity: float
    :ivar dynamic_threshold_direction: Threshold direction. Required. Known values are:
     "LowerThan", "GreaterThan", and "GreaterOrLowerThan".
    :vartype dynamic_threshold_direction: str or
     ~azure.mgmt.cloudhealth.models.DynamicThresholdDirection
    :ivar training_start_time: Start time of the training in UTC.
    :vartype training_start_time: ~datetime.datetime
    """

    dynamic_threshold_model: Union[str, "_models.DynamicThresholdModel"] = rest_field(
        name="dynamicThresholdModel", visibility=["read", "create", "update", "delete", "query"]
    )
    """ML model to use for dynamic thresholds. Required. \"AnomalyDetection\""""
    model_sensitivity: float = rest_field(
        name="modelSensitivity", visibility=["read", "create", "update", "delete", "query"]
    )
    """ML model sensitivity. Lowest value = high sensitivity. Supported step size = 0.5. Required."""
    dynamic_threshold_direction: Union[str, "_models.DynamicThresholdDirection"] = rest_field(
        name="dynamicThresholdDirection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Threshold direction. Required. Known values are: \"LowerThan\", \"GreaterThan\", and
     \"GreaterOrLowerThan\"."""
    training_start_time: Optional[datetime.datetime] = rest_field(
        name="trainingStartTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Start time of the training in UTC."""

    @overload
    def __init__(
        self,
        *,
        dynamic_threshold_model: Union[str, "_models.DynamicThresholdModel"],
        model_sensitivity: float,
        dynamic_threshold_direction: Union[str, "_models.DynamicThresholdDirection"],
        training_start_time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Entity(ProxyResource):
    """An entity (aka node) of a health model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cloudhealth.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.cloudhealth.models.EntityProperties
    """

    properties: Optional["_models.EntityProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.EntityProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityAlerts(_Model):
    """Alert configuration for an entity.

    :ivar unhealthy: Alert to be triggered on state change to unhealthy.
    :vartype unhealthy: ~azure.mgmt.cloudhealth.models.AlertConfiguration
    :ivar degraded: Alert to be triggered on state change to degraded.
    :vartype degraded: ~azure.mgmt.cloudhealth.models.AlertConfiguration
    """

    unhealthy: Optional["_models.AlertConfiguration"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Alert to be triggered on state change to unhealthy."""
    degraded: Optional["_models.AlertConfiguration"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Alert to be triggered on state change to degraded."""

    @overload
    def __init__(
        self,
        *,
        unhealthy: Optional["_models.AlertConfiguration"] = None,
        degraded: Optional["_models.AlertConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityCoordinates(_Model):
    """Visual position of the entity.

    :ivar x: X Coordinate. Required.
    :vartype x: float
    :ivar y: Y Coordinate. Required.
    :vartype y: float
    """

    x: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """X Coordinate. Required."""
    y: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Y Coordinate. Required."""

    @overload
    def __init__(
        self,
        *,
        x: float,
        y: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityProperties(_Model):
    """Properties which are common across all kinds of entities.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.cloudhealth.models.HealthModelProvisioningState
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar kind: Entity kind.
    :vartype kind: str
    :ivar canvas_position: Positioning of the entity on the model canvas.
    :vartype canvas_position: ~azure.mgmt.cloudhealth.models.EntityCoordinates
    :ivar icon: Visual icon definition. If not set, a default icon is used.
    :vartype icon: ~azure.mgmt.cloudhealth.models.IconDefinition
    :ivar health_objective: Health objective as a percentage of time the entity should be healthy.
    :vartype health_objective: float
    :ivar impact: Impact of the entity in health state propagation. Known values are: "Standard",
     "Limited", and "Suppressed".
    :vartype impact: str or ~azure.mgmt.cloudhealth.models.EntityImpact
    :ivar labels: Optional set of labels (key-value pairs).
    :vartype labels: dict[str, str]
    :ivar signals: Signal groups which are assigned to this entity.
    :vartype signals: ~azure.mgmt.cloudhealth.models.SignalGroup
    :ivar discovered_by: Discovered by which discovery rule. If set, the entity cannot be deleted
     manually.
    :vartype discovered_by: str
    :ivar deletion_date: Date when the entity was (soft-)deleted.
    :vartype deletion_date: ~datetime.datetime
    :ivar health_state: Health state of this entity. Known values are: "Healthy", "Degraded",
     "Error", "Unknown", and "Deleted".
    :vartype health_state: str or ~azure.mgmt.cloudhealth.models.HealthState
    :ivar alerts: Alert configuration for this entity.
    :vartype alerts: ~azure.mgmt.cloudhealth.models.EntityAlerts
    """

    provisioning_state: Optional[Union[str, "_models.HealthModelProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Creating\", and \"Deleting\"."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name."""
    kind: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity kind."""
    canvas_position: Optional["_models.EntityCoordinates"] = rest_field(
        name="canvasPosition", visibility=["read", "create", "update", "delete", "query"]
    )
    """Positioning of the entity on the model canvas."""
    icon: Optional["_models.IconDefinition"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Visual icon definition. If not set, a default icon is used."""
    health_objective: Optional[float] = rest_field(
        name="healthObjective", visibility=["read", "create", "update", "delete", "query"]
    )
    """Health objective as a percentage of time the entity should be healthy."""
    impact: Optional[Union[str, "_models.EntityImpact"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Impact of the entity in health state propagation. Known values are: \"Standard\", \"Limited\",
     and \"Suppressed\"."""
    labels: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional set of labels (key-value pairs)."""
    signals: Optional["_models.SignalGroup"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Signal groups which are assigned to this entity."""
    discovered_by: Optional[str] = rest_field(name="discoveredBy", visibility=["read"])
    """Discovered by which discovery rule. If set, the entity cannot be deleted manually."""
    deletion_date: Optional[datetime.datetime] = rest_field(name="deletionDate", visibility=["read"], format="rfc3339")
    """Date when the entity was (soft-)deleted."""
    health_state: Optional[Union[str, "_models.HealthState"]] = rest_field(name="healthState", visibility=["read"])
    """Health state of this entity. Known values are: \"Healthy\", \"Degraded\", \"Error\",
     \"Unknown\", and \"Deleted\"."""
    alerts: Optional["_models.EntityAlerts"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Alert configuration for this entity."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        kind: Optional[str] = None,
        canvas_position: Optional["_models.EntityCoordinates"] = None,
        icon: Optional["_models.IconDefinition"] = None,
        health_objective: Optional[float] = None,
        impact: Optional[Union[str, "_models.EntityImpact"]] = None,
        labels: Optional[Dict[str, str]] = None,
        signals: Optional["_models.SignalGroup"] = None,
        alerts: Optional["_models.EntityAlerts"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.cloudhealth.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.cloudhealth.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.cloudhealth.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvaluationRule(_Model):
    """Evaluation rule for a signal definition.

    :ivar dynamic_detection_rule: Configure to use ML-based dynamic thresholds. When used,
     degradedRule and unhealthyRule must not be set.
    :vartype dynamic_detection_rule: ~azure.mgmt.cloudhealth.models.DynamicDetectionRule
    :ivar degraded_rule: Degraded rule with static threshold. When used, dynamicDetectionRule must
     not be set.
    :vartype degraded_rule: ~azure.mgmt.cloudhealth.models.ThresholdRule
    :ivar unhealthy_rule: Unhealthy rule with static threshold. When used, dynamicDetectionRule
     must not be set.
    :vartype unhealthy_rule: ~azure.mgmt.cloudhealth.models.ThresholdRule
    """

    dynamic_detection_rule: Optional["_models.DynamicDetectionRule"] = rest_field(
        name="dynamicDetectionRule", visibility=["read", "create", "update", "delete", "query"]
    )
    """Configure to use ML-based dynamic thresholds. When used, degradedRule and unhealthyRule must
     not be set."""
    degraded_rule: Optional["_models.ThresholdRule"] = rest_field(
        name="degradedRule", visibility=["read", "create", "update", "delete", "query"]
    )
    """Degraded rule with static threshold. When used, dynamicDetectionRule must not be set."""
    unhealthy_rule: Optional["_models.ThresholdRule"] = rest_field(
        name="unhealthyRule", visibility=["read", "create", "update", "delete", "query"]
    )
    """Unhealthy rule with static threshold. When used, dynamicDetectionRule must not be set."""

    @overload
    def __init__(
        self,
        *,
        dynamic_detection_rule: Optional["_models.DynamicDetectionRule"] = None,
        degraded_rule: Optional["_models.ThresholdRule"] = None,
        unhealthy_rule: Optional["_models.ThresholdRule"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cloudhealth.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthModel(TrackedResource):
    """A HealthModel resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cloudhealth.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.cloudhealth.models.HealthModelProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.cloudhealth.models.ManagedServiceIdentity
    """

    properties: Optional["_models.HealthModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.HealthModelProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthModelProperties(_Model):
    """HealthModel properties.

    :ivar dataplane_endpoint: The data plane endpoint for interacting with health data.
    :vartype dataplane_endpoint: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.cloudhealth.models.HealthModelProvisioningState
    :ivar discovery: Configure to automatically discover entities from a given scope, such as a
     Service Group. The discovered entities will be linked to the root entity of the health model.
    :vartype discovery: ~azure.mgmt.cloudhealth.models.ModelDiscoverySettings
    """

    dataplane_endpoint: Optional[str] = rest_field(name="dataplaneEndpoint", visibility=["read"])
    """The data plane endpoint for interacting with health data."""
    provisioning_state: Optional[Union[str, "_models.HealthModelProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Creating\", and \"Deleting\"."""
    discovery: Optional["_models.ModelDiscoverySettings"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configure to automatically discover entities from a given scope, such as a Service Group. The
     discovered entities will be linked to the root entity of the health model."""

    @overload
    def __init__(
        self,
        *,
        discovery: Optional["_models.ModelDiscoverySettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthModelUpdate(_Model):
    """The type used for update operations of the HealthModel.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.cloudhealth.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.cloudhealth.models.HealthModelUpdateProperties
    """

    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.HealthModelUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.HealthModelUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthModelUpdateProperties(_Model):
    """The updatable properties of the HealthModel.

    :ivar discovery: Configure to automatically discover entities from a given scope, such as a
     Service Group. The discovered entities will be linked to the root entity of the health model.
    :vartype discovery: ~azure.mgmt.cloudhealth.models.ModelDiscoverySettings
    """

    discovery: Optional["_models.ModelDiscoverySettings"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configure to automatically discover entities from a given scope, such as a Service Group. The
     discovered entities will be linked to the root entity of the health model."""

    @overload
    def __init__(
        self,
        *,
        discovery: Optional["_models.ModelDiscoverySettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IconDefinition(_Model):
    """Visual icon definition of an entity.

    :ivar icon_name: Name of the built-in icon, or 'Custom' to use customData. Required.
    :vartype icon_name: str
    :ivar custom_data: Custom data. Base64-encoded SVG data. If set, this overrides the built-in
     icon.
    :vartype custom_data: str
    """

    icon_name: str = rest_field(name="iconName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the built-in icon, or 'Custom' to use customData. Required."""
    custom_data: Optional[str] = rest_field(
        name="customData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Custom data. Base64-encoded SVG data. If set, this overrides the built-in icon."""

    @overload
    def __init__(
        self,
        *,
        icon_name: str,
        custom_data: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SignalDefinitionProperties(_Model):
    """SignalDefinition properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ResourceMetricSignalDefinitionProperties, LogAnalyticsQuerySignalDefinitionProperties,
    PrometheusMetricsSignalDefinitionProperties

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.cloudhealth.models.HealthModelProvisioningState
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar signal_kind: Kind of the signal definition. Required. Known values are:
     "AzureResourceMetric", "LogAnalyticsQuery", and "PrometheusMetricsQuery".
    :vartype signal_kind: str or ~azure.mgmt.cloudhealth.models.SignalKind
    :ivar refresh_interval: Interval in which the signal is being evaluated. Defaults to PT1M (1
     minute). Known values are: "PT1M", "PT5M", "PT10M", "PT30M", "PT1H", and "PT2H".
    :vartype refresh_interval: str or ~azure.mgmt.cloudhealth.models.RefreshInterval
    :ivar labels: Optional set of labels (key-value pairs).
    :vartype labels: dict[str, str]
    :ivar data_unit: Unit of the signal result (e.g. Bytes, MilliSeconds, Percent, Count)).
    :vartype data_unit: str
    :ivar evaluation_rules: Evaluation rules for the signal definition. Required.
    :vartype evaluation_rules: ~azure.mgmt.cloudhealth.models.EvaluationRule
    :ivar deletion_date: Date when the signal definition was (soft-)deleted.
    :vartype deletion_date: ~datetime.datetime
    """

    __mapping__: Dict[str, _Model] = {}
    provisioning_state: Optional[Union[str, "_models.HealthModelProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Creating\", and \"Deleting\"."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name."""
    signal_kind: str = rest_discriminator(name="signalKind", visibility=["read", "create", "update", "delete", "query"])
    """Kind of the signal definition. Required. Known values are: \"AzureResourceMetric\",
     \"LogAnalyticsQuery\", and \"PrometheusMetricsQuery\"."""
    refresh_interval: Optional[Union[str, "_models.RefreshInterval"]] = rest_field(
        name="refreshInterval", visibility=["read", "create", "update", "delete", "query"]
    )
    """Interval in which the signal is being evaluated. Defaults to PT1M (1 minute). Known values are:
     \"PT1M\", \"PT5M\", \"PT10M\", \"PT30M\", \"PT1H\", and \"PT2H\"."""
    labels: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional set of labels (key-value pairs)."""
    data_unit: Optional[str] = rest_field(name="dataUnit", visibility=["read", "create", "update", "delete", "query"])
    """Unit of the signal result (e.g. Bytes, MilliSeconds, Percent, Count))."""
    evaluation_rules: "_models.EvaluationRule" = rest_field(
        name="evaluationRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """Evaluation rules for the signal definition. Required."""
    deletion_date: Optional[datetime.datetime] = rest_field(name="deletionDate", visibility=["read"], format="rfc3339")
    """Date when the signal definition was (soft-)deleted."""

    @overload
    def __init__(
        self,
        *,
        signal_kind: str,
        evaluation_rules: "_models.EvaluationRule",
        display_name: Optional[str] = None,
        refresh_interval: Optional[Union[str, "_models.RefreshInterval"]] = None,
        labels: Optional[Dict[str, str]] = None,
        data_unit: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LogAnalyticsQuerySignalDefinitionProperties(
    SignalDefinitionProperties, discriminator="LogAnalyticsQuery"
):  # pylint: disable=name-too-long
    """Log Analytics Query Signal Definition properties.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.cloudhealth.models.HealthModelProvisioningState
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar refresh_interval: Interval in which the signal is being evaluated. Defaults to PT1M (1
     minute). Known values are: "PT1M", "PT5M", "PT10M", "PT30M", "PT1H", and "PT2H".
    :vartype refresh_interval: str or ~azure.mgmt.cloudhealth.models.RefreshInterval
    :ivar labels: Optional set of labels (key-value pairs).
    :vartype labels: dict[str, str]
    :ivar data_unit: Unit of the signal result (e.g. Bytes, MilliSeconds, Percent, Count)).
    :vartype data_unit: str
    :ivar evaluation_rules: Evaluation rules for the signal definition. Required.
    :vartype evaluation_rules: ~azure.mgmt.cloudhealth.models.EvaluationRule
    :ivar deletion_date: Date when the signal definition was (soft-)deleted.
    :vartype deletion_date: ~datetime.datetime
    :ivar signal_kind: Kind of the signal definition. Required.
    :vartype signal_kind: str or ~azure.mgmt.cloudhealth.models.LOG_ANALYTICS_QUERY
    :ivar query_text: Query text in KQL syntax. Required.
    :vartype query_text: str
    :ivar time_grain: Time range of signal. ISO duration format like PT10M. If not specified, the
     KQL query must define a time range.
    :vartype time_grain: str
    :ivar value_column_name: Name of the column in the result set to evaluate against the
     thresholds. Defaults to the first column in the result set if not specified. The column must be
     numeric.
    :vartype value_column_name: str
    """

    signal_kind: Literal[SignalKind.LOG_ANALYTICS_QUERY] = rest_discriminator(name="signalKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the signal definition. Required."""
    query_text: str = rest_field(name="queryText", visibility=["read", "create", "update", "delete", "query"])
    """Query text in KQL syntax. Required."""
    time_grain: Optional[str] = rest_field(name="timeGrain", visibility=["read", "create", "update", "delete", "query"])
    """Time range of signal. ISO duration format like PT10M. If not specified, the KQL query must
     define a time range."""
    value_column_name: Optional[str] = rest_field(
        name="valueColumnName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the column in the result set to evaluate against the thresholds. Defaults to the first
     column in the result set if not specified. The column must be numeric."""

    @overload
    def __init__(
        self,
        *,
        evaluation_rules: "_models.EvaluationRule",
        query_text: str,
        display_name: Optional[str] = None,
        refresh_interval: Optional[Union[str, "_models.RefreshInterval"]] = None,
        labels: Optional[Dict[str, str]] = None,
        data_unit: Optional[str] = None,
        time_grain: Optional[str] = None,
        value_column_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, signal_kind=SignalKind.LOG_ANALYTICS_QUERY, **kwargs)


class LogAnalyticsSignalGroup(_Model):
    """A grouping of signal assignments for a Log Analytics Workspace.

    :ivar signal_assignments: Signal definitions which are assigned to this signal group. All
     assignments are combined with an OR operator.
    :vartype signal_assignments: list[~azure.mgmt.cloudhealth.models.SignalAssignment]
    :ivar authentication_setting: Reference to the name of the authentication setting which is used
     for querying the data source. Required.
    :vartype authentication_setting: str
    :ivar log_analytics_workspace_resource_id: Log Analytics Workspace resource ID. Required.
    :vartype log_analytics_workspace_resource_id: str
    """

    signal_assignments: Optional[List["_models.SignalAssignment"]] = rest_field(
        name="signalAssignments", visibility=["read", "create", "update", "delete", "query"]
    )
    """Signal definitions which are assigned to this signal group. All assignments are combined with
     an OR operator."""
    authentication_setting: str = rest_field(
        name="authenticationSetting", visibility=["read", "create", "update", "delete", "query"]
    )
    """Reference to the name of the authentication setting which is used for querying the data source.
     Required."""
    log_analytics_workspace_resource_id: str = rest_field(
        name="logAnalyticsWorkspaceResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Log Analytics Workspace resource ID. Required."""

    @overload
    def __init__(
        self,
        *,
        authentication_setting: str,
        log_analytics_workspace_resource_id: str,
        signal_assignments: Optional[List["_models.SignalAssignment"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedIdentityAuthenticationSettingProperties(
    AuthenticationSettingProperties, discriminator="ManagedIdentity"
):  # pylint: disable=name-too-long
    """Authentication setting properties for Azure Managed Identity.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.cloudhealth.models.HealthModelProvisioningState
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar authentication_kind: Kind of the authentication setting. Required.
    :vartype authentication_kind: str or ~azure.mgmt.cloudhealth.models.MANAGED_IDENTITY
    :ivar managed_identity_name: Name of the managed identity to use. Either 'SystemAssigned' or
     the resourceId of a user-assigned identity. Required.
    :vartype managed_identity_name: str
    """

    authentication_kind: Literal[AuthenticationKind.MANAGED_IDENTITY] = rest_discriminator(name="authenticationKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the authentication setting. Required."""
    managed_identity_name: str = rest_field(
        name="managedIdentityName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the managed identity to use. Either 'SystemAssigned' or the resourceId of a
     user-assigned identity. Required."""

    @overload
    def __init__(
        self,
        *,
        managed_identity_name: str,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, authentication_kind=AuthenticationKind.MANAGED_IDENTITY, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.cloudhealth.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.cloudhealth.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ModelDiscoverySettings(_Model):
    """Settings for automatically discovering entities for the health model.

    :ivar scope: The scope from which entities should be automatically discovered. For example, the
     resource id of a Service Group. Required.
    :vartype scope: str
    :ivar add_recommended_signals: Whether to add all recommended signals to the discovered
     entities. Required. Known values are: "Enabled" and "Disabled".
    :vartype add_recommended_signals: str or
     ~azure.mgmt.cloudhealth.models.DiscoveryRuleRecommendedSignalsBehavior
    :ivar identity: Which Managed Identity of the health model to use for discovery. Defaults to
     SystemAssigned, if not set. Can be set to 'SystemAssigned' or to the resource id of a
     user-assigned managed identity which is linked to the health model.
    :vartype identity: str
    """

    scope: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The scope from which entities should be automatically discovered. For example, the resource id
     of a Service Group. Required."""
    add_recommended_signals: Union[str, "_models.DiscoveryRuleRecommendedSignalsBehavior"] = rest_field(
        name="addRecommendedSignals", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether to add all recommended signals to the discovered entities. Required. Known values are:
     \"Enabled\" and \"Disabled\"."""
    identity: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Which Managed Identity of the health model to use for discovery. Defaults to SystemAssigned, if
     not set. Can be set to 'SystemAssigned' or to the resource id of a user-assigned managed
     identity which is linked to the health model."""

    @overload
    def __init__(
        self,
        *,
        scope: str,
        add_recommended_signals: Union[str, "_models.DiscoveryRuleRecommendedSignalsBehavior"],
        identity: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.cloudhealth.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.cloudhealth.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.cloudhealth.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PrometheusMetricsSignalDefinitionProperties(
    SignalDefinitionProperties, discriminator="PrometheusMetricsQuery"
):  # pylint: disable=name-too-long
    """Prometheus Metrics Signal Definition properties.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.cloudhealth.models.HealthModelProvisioningState
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar refresh_interval: Interval in which the signal is being evaluated. Defaults to PT1M (1
     minute). Known values are: "PT1M", "PT5M", "PT10M", "PT30M", "PT1H", and "PT2H".
    :vartype refresh_interval: str or ~azure.mgmt.cloudhealth.models.RefreshInterval
    :ivar labels: Optional set of labels (key-value pairs).
    :vartype labels: dict[str, str]
    :ivar data_unit: Unit of the signal result (e.g. Bytes, MilliSeconds, Percent, Count)).
    :vartype data_unit: str
    :ivar evaluation_rules: Evaluation rules for the signal definition. Required.
    :vartype evaluation_rules: ~azure.mgmt.cloudhealth.models.EvaluationRule
    :ivar deletion_date: Date when the signal definition was (soft-)deleted.
    :vartype deletion_date: ~datetime.datetime
    :ivar signal_kind: Kind of the signal definition. Required.
    :vartype signal_kind: str or ~azure.mgmt.cloudhealth.models.PROMETHEUS_METRICS_QUERY
    :ivar query_text: Query text in PromQL syntax. Required.
    :vartype query_text: str
    :ivar time_grain: Time range of signal. ISO duration format like PT10M.
    :vartype time_grain: str
    """

    signal_kind: Literal[SignalKind.PROMETHEUS_METRICS_QUERY] = rest_discriminator(name="signalKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the signal definition. Required."""
    query_text: str = rest_field(name="queryText", visibility=["read", "create", "update", "delete", "query"])
    """Query text in PromQL syntax. Required."""
    time_grain: Optional[str] = rest_field(name="timeGrain", visibility=["read", "create", "update", "delete", "query"])
    """Time range of signal. ISO duration format like PT10M."""

    @overload
    def __init__(
        self,
        *,
        evaluation_rules: "_models.EvaluationRule",
        query_text: str,
        display_name: Optional[str] = None,
        refresh_interval: Optional[Union[str, "_models.RefreshInterval"]] = None,
        labels: Optional[Dict[str, str]] = None,
        data_unit: Optional[str] = None,
        time_grain: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, signal_kind=SignalKind.PROMETHEUS_METRICS_QUERY, **kwargs)


class Relationship(ProxyResource):
    """A relationship (aka edge) between two entities in a health model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cloudhealth.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.cloudhealth.models.RelationshipProperties
    """

    properties: Optional["_models.RelationshipProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.RelationshipProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RelationshipProperties(_Model):
    """Relationship properties.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.cloudhealth.models.HealthModelProvisioningState
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar parent_entity_name: Resource name of the parent entity. Required.
    :vartype parent_entity_name: str
    :ivar child_entity_name: Resource name of the child entity. Required.
    :vartype child_entity_name: str
    :ivar labels: Optional set of labels (key-value pairs).
    :vartype labels: dict[str, str]
    :ivar discovered_by: Discovered by which discovery rule. If set, the relationship cannot be
     deleted manually.
    :vartype discovered_by: str
    :ivar deletion_date: Date when the relationship was (soft-)deleted.
    :vartype deletion_date: ~datetime.datetime
    """

    provisioning_state: Optional[Union[str, "_models.HealthModelProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Creating\", and \"Deleting\"."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name."""
    parent_entity_name: str = rest_field(name="parentEntityName", visibility=["read", "create"])
    """Resource name of the parent entity. Required."""
    child_entity_name: str = rest_field(name="childEntityName", visibility=["read", "create"])
    """Resource name of the child entity. Required."""
    labels: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional set of labels (key-value pairs)."""
    discovered_by: Optional[str] = rest_field(name="discoveredBy", visibility=["read"])
    """Discovered by which discovery rule. If set, the relationship cannot be deleted manually."""
    deletion_date: Optional[datetime.datetime] = rest_field(name="deletionDate", visibility=["read"], format="rfc3339")
    """Date when the relationship was (soft-)deleted."""

    @overload
    def __init__(
        self,
        *,
        parent_entity_name: str,
        child_entity_name: str,
        display_name: Optional[str] = None,
        labels: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceMetricSignalDefinitionProperties(SignalDefinitionProperties, discriminator="AzureResourceMetric"):
    """Azure Resource Metric Signal Definition properties.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.cloudhealth.models.HealthModelProvisioningState
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar refresh_interval: Interval in which the signal is being evaluated. Defaults to PT1M (1
     minute). Known values are: "PT1M", "PT5M", "PT10M", "PT30M", "PT1H", and "PT2H".
    :vartype refresh_interval: str or ~azure.mgmt.cloudhealth.models.RefreshInterval
    :ivar labels: Optional set of labels (key-value pairs).
    :vartype labels: dict[str, str]
    :ivar data_unit: Unit of the signal result (e.g. Bytes, MilliSeconds, Percent, Count)).
    :vartype data_unit: str
    :ivar evaluation_rules: Evaluation rules for the signal definition. Required.
    :vartype evaluation_rules: ~azure.mgmt.cloudhealth.models.EvaluationRule
    :ivar deletion_date: Date when the signal definition was (soft-)deleted.
    :vartype deletion_date: ~datetime.datetime
    :ivar signal_kind: Kind of the signal definition. Required.
    :vartype signal_kind: str or ~azure.mgmt.cloudhealth.models.AZURE_RESOURCE_METRIC
    :ivar metric_namespace: Metric namespace. Required.
    :vartype metric_namespace: str
    :ivar metric_name: Name of the metric. Required.
    :vartype metric_name: str
    :ivar time_grain: Time range of signal. ISO duration format like PT10M. Required.
    :vartype time_grain: str
    :ivar aggregation_type: Type of aggregation to apply to the metric. Required. Known values are:
     "None", "Average", "Count", "Minimum", "Maximum", and "Total".
    :vartype aggregation_type: str or ~azure.mgmt.cloudhealth.models.MetricAggregationType
    :ivar dimension: Optional: Dimension to split by.
    :vartype dimension: str
    :ivar dimension_filter: Optional: Dimension filter to apply to the dimension. Must only be set
     if also Dimension is set.
    :vartype dimension_filter: str
    """

    signal_kind: Literal[SignalKind.AZURE_RESOURCE_METRIC] = rest_discriminator(name="signalKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the signal definition. Required."""
    metric_namespace: str = rest_field(
        name="metricNamespace", visibility=["read", "create", "update", "delete", "query"]
    )
    """Metric namespace. Required."""
    metric_name: str = rest_field(name="metricName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the metric. Required."""
    time_grain: str = rest_field(name="timeGrain", visibility=["read", "create", "update", "delete", "query"])
    """Time range of signal. ISO duration format like PT10M. Required."""
    aggregation_type: Union[str, "_models.MetricAggregationType"] = rest_field(
        name="aggregationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of aggregation to apply to the metric. Required. Known values are: \"None\", \"Average\",
     \"Count\", \"Minimum\", \"Maximum\", and \"Total\"."""
    dimension: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional: Dimension to split by."""
    dimension_filter: Optional[str] = rest_field(
        name="dimensionFilter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional: Dimension filter to apply to the dimension. Must only be set if also Dimension is
     set."""

    @overload
    def __init__(
        self,
        *,
        evaluation_rules: "_models.EvaluationRule",
        metric_namespace: str,
        metric_name: str,
        time_grain: str,
        aggregation_type: Union[str, "_models.MetricAggregationType"],
        display_name: Optional[str] = None,
        refresh_interval: Optional[Union[str, "_models.RefreshInterval"]] = None,
        labels: Optional[Dict[str, str]] = None,
        data_unit: Optional[str] = None,
        dimension: Optional[str] = None,
        dimension_filter: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, signal_kind=SignalKind.AZURE_RESOURCE_METRIC, **kwargs)


class SignalAssignment(_Model):
    """Group of signal definition assignments.

    :ivar signal_definitions: Signal definitions referenced by their names. All definitions are
     combined with an AND operator. Required.
    :vartype signal_definitions: list[str]
    """

    signal_definitions: List[str] = rest_field(
        name="signalDefinitions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Signal definitions referenced by their names. All definitions are combined with an AND
     operator. Required."""

    @overload
    def __init__(
        self,
        *,
        signal_definitions: List[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SignalDefinition(ProxyResource):
    """A signal definition in a health model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cloudhealth.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.cloudhealth.models.SignalDefinitionProperties
    """

    properties: Optional["_models.SignalDefinitionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SignalDefinitionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SignalGroup(_Model):
    """Contains various signal groups that can be assigned to an entity.

    :ivar azure_resource: Azure Resource Signal Group.
    :vartype azure_resource: ~azure.mgmt.cloudhealth.models.AzureResourceSignalGroup
    :ivar azure_log_analytics: Log Analytics Signal Group.
    :vartype azure_log_analytics: ~azure.mgmt.cloudhealth.models.LogAnalyticsSignalGroup
    :ivar azure_monitor_workspace: Azure Monitor Workspace Signal Group.
    :vartype azure_monitor_workspace:
     ~azure.mgmt.cloudhealth.models.AzureMonitorWorkspaceSignalGroup
    :ivar dependencies: Settings for dependency signals to control how the health state of child
     entities influences the health state of the parent entity.
    :vartype dependencies: ~azure.mgmt.cloudhealth.models.DependenciesSignalGroup
    """

    azure_resource: Optional["_models.AzureResourceSignalGroup"] = rest_field(
        name="azureResource", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure Resource Signal Group."""
    azure_log_analytics: Optional["_models.LogAnalyticsSignalGroup"] = rest_field(
        name="azureLogAnalytics", visibility=["read", "create", "update", "delete", "query"]
    )
    """Log Analytics Signal Group."""
    azure_monitor_workspace: Optional["_models.AzureMonitorWorkspaceSignalGroup"] = rest_field(
        name="azureMonitorWorkspace", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure Monitor Workspace Signal Group."""
    dependencies: Optional["_models.DependenciesSignalGroup"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings for dependency signals to control how the health state of child entities influences
     the health state of the parent entity."""

    @overload
    def __init__(
        self,
        *,
        azure_resource: Optional["_models.AzureResourceSignalGroup"] = None,
        azure_log_analytics: Optional["_models.LogAnalyticsSignalGroup"] = None,
        azure_monitor_workspace: Optional["_models.AzureMonitorWorkspaceSignalGroup"] = None,
        dependencies: Optional["_models.DependenciesSignalGroup"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.cloudhealth.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.cloudhealth.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ThresholdRule(_Model):
    """Threshold-based evaluation rule for a signal definition.

    :ivar operator: Operator how to compare the signal value with the threshold. Required. Known
     values are: "LowerThan", "LowerOrEquals", "GreaterThan", "GreaterOrEquals", and "Equals".
    :vartype operator: str or ~azure.mgmt.cloudhealth.models.SignalOperator
    :ivar threshold: Threshold value. Required.
    :vartype threshold: str
    """

    operator: Union[str, "_models.SignalOperator"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Operator how to compare the signal value with the threshold. Required. Known values are:
     \"LowerThan\", \"LowerOrEquals\", \"GreaterThan\", \"GreaterOrEquals\", and \"Equals\"."""
    threshold: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Threshold value. Required."""

    @overload
    def __init__(
        self,
        *,
        operator: Union[str, "_models.SignalOperator"],
        threshold: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""
