# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class ApiKey(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of ApiKey."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class AutoGeneratedDomainNameLabelScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scope for dns deterministic name hash calculation."""

    TENANT_REUSE = "TenantReuse"


class AvailablePromotion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of AvailablePromotion."""

    NONE = "None"
    FREE_TRIAL = "FreeTrial"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DeterministicOutboundIP(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of DeterministicOutboundIP."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class ManagedPrivateEndpointConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The approval/rejection status of managed private endpoint connection."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class MarketplaceAutoRenew(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The AutoRenew setting of the Enterprise subscription."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    """Connection has been provisioned"""
    CREATING = "Creating"
    """Connection is being created"""
    DELETING = "Deleting"
    """Connection is being deleted"""
    FAILED = "Failed"
    """Connection provisioning has failed"""


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    """Connection waiting for approval or rejection"""
    APPROVED = "Approved"
    """Connection approved"""
    REJECTED = "Rejected"
    """Connection Rejected"""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of ProvisioningState."""

    ACCEPTED = "Accepted"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"
    NOT_SPECIFIED = "NotSpecified"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicate the state for enable or disable traffic over the public interface."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class StartTLSPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The StartTLSPolicy setting of the SMTP configuration
    `https://pkg.go.dev/github.com/go-mail/mail#StartTLSPolicy
    <https://pkg.go.dev/github.com/go-mail/mail#StartTLSPolicy>`_.
    """

    OPPORTUNISTIC_START_TLS = "OpportunisticStartTLS"
    MANDATORY_START_TLS = "MandatoryStartTLS"
    NO_START_TLS = "NoStartTLS"


class ZoneRedundancy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of ZoneRedundancy."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"
