# far more readable python hash of collector_index.json

EXAMPLE_INDEX = {
  'index_created': '2019-11-30 22:26',
  'build_revision': '199d1bed',
  'path': 'https://collector.torproject.org',
  'directories': [
    {
      'path': 'archive',
      'directories': [
        {
          'path': 'bridge-descriptors',
          'directories': [
            {
              'path': 'extra-infos',
              'files': [
                {
                  'path': 'bridge-extra-infos-2008-05.tar.xz',
                  'last_published': '2008-05-31 23:09',
                  'first_published': '2008-05-13 15:21',
                  'last_modified': '2016-09-04 09:21',
                  'sha256': 'aDD2q7uNGOM+WuH67+nTd7rvFN4P580xPAmXYtqxr2I=',
                  'types': ['bridge-extra-info 1.3'],
                  'size': 377644
                }, {
                  'path': 'bridge-extra-infos-2008-06.tar.xz',
                  'last_published': '2008-06-30 23:29',
                  'first_published': '2008-06-01 00:23',
                  'last_modified': '2016-09-04 09:21',
                  'sha256': 'VLdUu98Fz8RKTFL13ftA3WJ5lsDJQBRrh/KGLOYAUqk=',
                  'types': ['bridge-extra-info 1.3'],
                  'size': 600484
                }, {
                  'path': 'bridge-extra-infos-2008-07.tar.xz',
                  'last_published': '2008-07-31 23:59',
                  'first_published': '2008-07-01 05:06',
                  'last_modified': '2016-09-04 09:21',
                  'sha256': 'NNj6mBr/aWDdNZmmPYSERn5pjQh0g04Xu8gUi6kMVds=',
                  'types': ['bridge-extra-info 1.3'],
                  'size': 716320
                }
              ]
            }, {
              'path': 'server-descriptors',
              'files': [
                {
                  'path': 'bridge-server-descriptors-2008-05.tar.xz',
                  'last_published': '2008-05-31 23:09',
                  'first_published': '2008-05-14 18:22',
                  'last_modified': '2016-09-09 14:13',
                  'sha256': 'NRb2dzS2OhFKYjfr5WoleOFokqC4C+qf0Nu4iegnFLo=',
                  'types': ['bridge-server-descriptor 1.2'],
                  'size': 205348
                }, {
                  'path': 'bridge-server-descriptors-2008-06.tar.xz',
                  'last_published': '2008-06-30 23:29',
                  'first_published': '2008-06-01 00:23',
                  'last_modified': '2016-09-09 14:13',
                  'sha256': '+R6WdoPIjlGZQhkMEFhr5sOF1LOs2u/ioJyi3G8f9iI=',
                  'types': ['bridge-server-descriptor 1.2'],
                  'size': 342828
                }, {
                  'path': 'bridge-server-descriptors-2008-07.tar.xz',
                  'last_published': '2008-07-31 23:59',
                  'first_published': '2008-07-01 05:06',
                  'last_modified': '2016-09-09 14:13',
                  'sha256': '/qR5Ec3Np/aKaHNGwSJJBxkFseKFaxYSrCNYeMqVS04=',
                  'types': ['bridge-server-descriptor 1.2'],
                  'size': 374848
                }
              ]
            }, {
              'path': 'statuses',
              'files': [
                {
                  'path': 'bridge-statuses-2008-05.tar.xz',
                  'last_published': '2008-05-31 23:37',
                  'first_published': '2008-05-16 19:46',
                  'last_modified': '2016-09-14 21:11',
                  'sha256': 'scynC2b8xKD+NbkejGK7mKCegUwGPwgzXu7MouxBSj0=',
                  'types': ['bridge-network-status 1.1'],
                  'size': 74792
                }, {
                  'path': 'bridge-statuses-2008-06.tar.xz',
                  'last_published': '2008-06-30 23:37',
                  'first_published': '2008-06-01 00:07',
                  'last_modified': '2016-09-14 21:11',
                  'sha256': 'sEEyUlnpL16UMfVIDlkFx/M5CRCa4A6wPAUUTN51eTA=',
                  'types': ['bridge-network-status 1.1'],
                  'size': 123488
                }, {
                  'path': 'bridge-statuses-2008-07.tar.xz',
                  'last_published': '2008-07-31 23:37',
                  'first_published': '2008-07-01 00:07',
                  'last_modified': '2016-09-14 21:11',
                  'sha256': 'cUIkQce1OEEgYHBpB+2AP2uKoRt+RoXOlkNKqPtacb8=',
                  'types': ['bridge-network-status 1.1'],
                  'size': 143836
                }
              ]
            }
          ]
        }, {
          'path': 'bridge-pool-assignments',
          'files': [
            {
              'path': 'bridge-pool-assignments-2010-09.tar.xz',
              'last_published': '2010-09-30 23:37',
              'first_published': '2010-09-29 07:41',
              'last_modified': '2012-05-31 10:21',
              'sha256': 'sBeIx6oEwkqjZkS9iB8Y9z/ArL8hdcGk9QMxt9dCUak=',
              'types': ['bridge-pool-assignment 1.0'],
              'size': 32804
            }, {
              'path': 'bridge-pool-assignments-2010-10.tar.xz',
              'last_published': '2010-10-31 23:37',
              'first_published': '2010-10-01 00:07',
              'last_modified': '2012-05-31 10:21',
              'sha256': 'nQ3w/COujflQGGE/xTD9U9x6iMNZbbUf7QHde3siJTw=',
              'types': ['bridge-pool-assignment 1.0'],
              'size': 304684
            }, {
              'path': 'bridge-pool-assignments-2010-11.tar.xz',
              'last_published': '2010-11-30 23:37',
              'first_published': '2010-11-01 00:07',
              'last_modified': '2012-05-31 10:21',
              'sha256': 'AxuzHdixo9j8AKJYXEUeoHiYL2/vaIbtb6tN7cYTfSg=',
              'types': ['bridge-pool-assignment 1.0'],
              'size': 292228
            }
          ]
        }, {
          'path': 'bridgedb-metrics',
          'files': [
            {
              'path': 'bridgedb-metrics-2019-09.tar.xz',
              'last_published': '2019-09-30 14:51',
              'first_published': '2019-09-05 08:51',
              'last_modified': '2019-11-10 15:27',
              'sha256': 'SJ6F54RXNfJBUPu9qq8zu2nDyXLKurhpZ2zyA1x+T6I=',
              'size': 7728
            }, {
              'path': 'bridgedb-metrics-2019-10.tar.xz',
              'last_published': '2019-10-31 16:22',
              'first_published': '2019-10-01 14:51',
              'last_modified': '2019-11-10 15:27',
              'sha256': 'pMrbEjNFQVy8F13EXThFIbOTHKggvahhbWuJ047QFPI=',
              'size': 9028
            }, {
              'path': 'bridgedb-metrics-2019-11.tar.xz',
              'last_published': '2019-11-29 14:21',
              'first_published': '2019-11-01 16:22',
              'last_modified': '2019-11-29 16:52',
              'sha256': 'x1GdLDMINdwm4pmYnvpLM8C91YwxwRzeGVVFcVW6B0o=',
              'size': 17140
            }
          ]
        }, {
          'path': 'exit-lists',
          'files': [
            {
              'path': 'exit-list-2010-02.tar.xz',
              'last_published': '2010-02-28 23:18',
              'first_published': '2010-02-22 15:32',
              'last_modified': '2012-05-31 18:57',
              'sha256': 'Q6ZAAy7RVbO+8rHH48AEZUU9PqcY5jD9zMASqjMzyns=',
              'types': ['tordnsel 1.0'],
              'size': 272008
            }, {
              'path': 'exit-list-2010-03.tar.xz',
              'last_published': '2010-03-31 23:25',
              'first_published': '2010-03-01 00:18',
              'last_modified': '2012-05-31 18:57',
              'sha256': 'ZjYIOYsuAwhmVYKs5QH7IQrRuoOicMy26vBxqnKBimY=',
              'types': ['tordnsel 1.0'],
              'size': 1247484
            }, {
              'path': 'exit-list-2010-04.tar.xz',
              'last_published': '2010-04-30 23:44',
              'first_published': '2010-04-01 00:30',
              'last_modified': '2012-05-31 18:57',
              'sha256': 'gu8kB7FLJpoY+gYW/DsK2eR3hRYaAo+CrTn4hTVAEhM=',
              'types': ['tordnsel 1.0'],
              'size': 1139896
            }
          ]
        }, {
          'path': 'relay-descriptors',
          'files': [
            {
              'path': 'certs.tar.xz',
              'last_published': '2019-10-08 04:06',
              'first_published': '2007-09-19 03:14',
              'last_modified': '2019-11-29 03:33',
              'sha256': 'ZfcE9RJwHvXhXaZ2xDzpoOJFqJeQR5ovOePOyNkKDi8=',
              'types': ['dir-key-certificate-3 1.0'],
              'size': 151748
            }
          ],
          'directories': [
            {
              'path': 'bandwidths',
              'files': [
                {
                  'path': 'bandwidths-2017-08.tar.xz',
                  'last_published': '2017-08-31 23:35',
                  'first_published': '2017-08-09 09:35',
                  'last_modified': '2019-07-29 18:45',
                  'sha256': 'BVVDEkegsLzkAn30dYikr4yTT79+XScfc0VUVEb83tM=',
                  'types': ['bandwidth-file 1.0'],
                  'size': 13330020
                }, {
                  'path': 'bandwidths-2017-09.tar.xz',
                  'last_published': '2017-09-30 23:38',
                  'first_published': '2017-09-01 00:40',
                  'last_modified': '2019-07-29 18:55',
                  'sha256': '4Ify8gHvQ8HDVsNvol2cbOj3KPApOjbbANRp8OOqkyA=',
                  'types': ['bandwidth-file 1.0'],
                  'size': 32672052
                }, {
                  'path': 'bandwidths-2017-10.tar.xz',
                  'last_published': '2017-10-31 23:43',
                  'first_published': '2017-10-01 00:11',
                  'last_modified': '2019-07-29 19:18',
                  'sha256': 'Yy9Haap9QWvWN0E2z06T1KXHeEQmL3og9X9AWGN7mIc=',
                  'types': ['bandwidth-file 1.0'],
                  'size': 40897092
                }
              ]
            }, {
              'path': 'consensuses',
              'files': [
                {
                  'path': 'consensuses-2007-10.tar.xz',
                  'last_published': '2007-10-31 23:00',
                  'first_published': '2007-10-27 12:00',
                  'last_modified': '2012-05-15 14:35',
                  'sha256': '4lhYcEmZbJUcI5L4+p+Rt1/vn65L9b4mcdBQRzdTvKo=',
                  'types': ['network-status-consensus-3 1.0'],
                  'size': 1061648
                }, {
                  'path': 'consensuses-2007-11.tar.xz',
                  'last_published': '2007-11-30 23:00',
                  'first_published': '2007-11-01 00:00',
                  'last_modified': '2012-05-15 14:35',
                  'sha256': 'F3sbwfxsuvXclitWpO/rRniALV7EtEmKWFHf9LpT2ps=',
                  'types': ['network-status-consensus-3 1.0'],
                  'size': 6810308
                }, {
                  'path': 'consensuses-2007-12.tar.xz',
                  'last_published': '2007-12-31 23:00',
                  'first_published': '2007-12-01 00:00',
                  'last_modified': '2012-05-15 14:35',
                  'sha256': 'QIhi0QoI5bOJU2HawwqXp+oCBEASVyjFWAb72Ha5+0Q=',
                  'types': ['network-status-consensus-3 1.0'],
                  'size': 8106968
                }
              ]
            }, {
              'path': 'extra-infos',
              'files': [
                {
                  'path': 'extra-infos-2007-08.tar.xz',
                  'last_published': '2007-08-31 23:53',
                  'first_published': '2007-08-14 17:35',
                  'last_modified': '2016-06-23 09:53',
                  'sha256': 'UcAIrzYjFU52mRHXNle/fbI21lvfsVkeC0NpBZ/Pt/w=',
                  'types': ['extra-info 1.0'],
                  'size': 3016916
                }, {
                  'path': 'extra-infos-2007-09.tar.xz',
                  'last_published': '2007-09-30 23:57',
                  'first_published': '2007-09-01 00:04',
                  'last_modified': '2016-06-23 09:54',
                  'sha256': '+hZ62VJrsIhkwqzZSbAQ3g1agPs+8QOgRVkcFxsIoBI=',
                  'types': ['extra-info 1.0'],
                  'size': 6459884
                }, {
                  'path': 'extra-infos-2007-10.tar.xz',
                  'last_published': '2007-10-31 23:59',
                  'first_published': '2007-10-01 00:01',
                  'last_modified': '2016-06-23 09:54',
                  'sha256': 'jLZGMaWik6X7zBJkHwoXSvplcwrNJhK2oRJTnBdM4MI=',
                  'types': ['extra-info 1.0'],
                  'size': 7326564
                }
              ]
            }, {
              'path': 'microdescs',
              'files': [
                {
                  'path': 'microdescs-2014-01.tar.xz',
                  'last_published': '2014-01-31 23:00',
                  'first_published': '2014-01-22 09:00',
                  'last_modified': '2014-02-07 03:59',
                  'sha256': 'DFugbV1phhpiEB0QeyyueKp0V/bicmAAkdBk/95RjKk=',
                  'types': ['microdescriptor 1.0', 'network-status-microdesc-consensus-3 1.0'],
                  'size': 7515396
                }, {
                  'path': 'microdescs-2014-02.tar.xz',
                  'last_published': '2014-02-28 23:00',
                  'first_published': '2014-02-01 00:00',
                  'last_modified': '2014-03-07 04:54',
                  'sha256': '5NFYLrbi8OUy7hRHhlWQ5uAbEkXDPHxkyFTkXIKiAF8=',
                  'types': ['microdescriptor 1.0', 'network-status-microdesc-consensus-3 1.0'],
                  'size': 21822944
                }, {
                  'path': 'microdescs-2014-03.tar.xz',
                  'last_published': '2014-03-31 23:00',
                  'first_published': '2014-03-01 00:00',
                  'last_modified': '2014-04-07 03:54',
                  'sha256': 'A6nUn1dyUx3s1sE5STBDH7+jW5Hdc2WD1mWBnSDmLVI=',
                  'types': ['microdescriptor 1.0', 'network-status-microdesc-consensus-3 1.0'],
                  'size': 24201436
                }
              ]
            }, {
              'path': 'server-descriptors',
              'files': [
                {
                  'path': 'server-descriptors-2005-12.tar.xz',
                  'last_published': '2005-12-17 11:06',
                  'first_published': '2005-12-15 01:42',
                  'last_modified': '2016-06-24 08:12',
                  'sha256': 'v3ANi2FD4xAhmyzigQq9gvlLwpXH8I6fGoiYlWLjOy8=',
                  'types': ['server-descriptor 1.0'],
                  'size': 1348620
                }, {
                  'path': 'server-descriptors-2006-02.tar.xz',
                  'last_published': '2006-02-28 23:59',
                  'first_published': '2006-02-04 11:22',
                  'last_modified': '2016-06-24 08:14',
                  'sha256': 'UhhE5TM/VM6VhhXnn7HdGMBw8L9RJL0NXsrZ0R/0DZQ=',
                  'types': ['server-descriptor 1.0'],
                  'size': 28625408
                }, {
                  'path': 'server-descriptors-2006-03.tar.xz',
                  'last_published': '2006-03-31 23:59',
                  'first_published': '2006-03-01 00:00',
                  'last_modified': '2016-06-24 08:17',
                  'sha256': 'Jv7qfAIbksfEjx80vW8aJto1cwTBDR1zD4LI2sNijXM=',
                  'types': ['server-descriptor 1.0'],
                  'size': 49548736
                }
              ]
            }, {
              'path': 'statuses',
              'files': [
                {
                  'path': 'statuses-2005-12.tar.xz',
                  'last_published': '2005-12-31 23:59',
                  'first_published': '2005-12-16 00:13',
                  'last_modified': '2016-06-25 11:50',
                  'sha256': 'Ec6DZrTog8DnFkmM7yRiAHO55lS9vOSDZrTtKHL0Vrw=',
                  'types': ['network-status-2 1.0'],
                  'size': 1468844
                }, {
                  'path': 'statuses-2006-01.tar.xz',
                  'last_published': '2006-01-31 23:39',
                  'first_published': '2006-01-01 00:38',
                  'last_modified': '2016-06-25 11:52',
                  'sha256': 'w3i+973xjkGh/qCvdM7i3bUq7zTDlWX9OXTUbaTe7ds=',
                  'types': ['network-status-2 1.0'],
                  'size': 3344280
                }, {
                  'path': 'statuses-2006-02.tar.xz',
                  'last_published': '2006-02-28 23:38',
                  'first_published': '2006-02-01 00:37',
                  'last_modified': '2016-06-25 11:54',
                  'sha256': 'b4q9NCSDd2KMb0W0al1+LBQAGGu+IhLZIC7fONZCRC4=',
                  'types': ['network-status-2 1.0'],
                  'size': 4006336
                }
              ]
            }, {
              'path': 'tor',
              'files': [
                {
                  'path': 'tor-2004-05.tar.xz',
                  'last_published': '2004-05-31 22:07',
                  'first_published': '2004-05-15 07:30',
                  'last_modified': '2012-05-18 14:26',
                  'sha256': '0dpNzcmozHGhCzz6SnF4YSXUgSGPTeRLGPHJV4eCZjI=',
                  'types': ['directory 1.0'],
                  'size': 386672
                }, {
                  'path': 'tor-2004-06.tar.xz',
                  'last_published': '2004-06-30 22:07',
                  'first_published': '2004-06-01 02:07',
                  'last_modified': '2012-05-18 14:26',
                  'sha256': 'qaXf+eht8EPlr9qO/VV9h+GjmxhboEP8BwLXw+Qn7+M=',
                  'types': ['directory 1.0'],
                  'size': 1087980
                }, {
                  'path': 'tor-2004-07.tar.xz',
                  'last_published': '2004-07-31 22:07',
                  'first_published': '2004-07-01 02:07',
                  'last_modified': '2012-05-18 14:26',
                  'sha256': 'f++lUmy43l+59UxH9e+Fxq/5MpnWvqRcIaJfNCKDwUE=',
                  'types': ['directory 1.0'],
                  'size': 1366568
                }
              ]
            }, {
              'path': 'votes',
              'files': [
                {
                  'path': 'votes-2007-10.tar.xz',
                  'last_published': '2007-10-31 23:00',
                  'first_published': '2007-10-27 12:00',
                  'last_modified': '2012-05-15 14:51',
                  'sha256': 'j6e2TIb3LYCG3Bf50W9MFljiadWY7v/fe7K6+jnI+Hc=',
                  'types': ['network-status-vote-3 1.0'],
                  'size': 1356504
                }, {
                  'path': 'votes-2007-11.tar.xz',
                  'last_published': '2007-11-30 23:00',
                  'first_published': '2007-11-01 00:00',
                  'last_modified': '2012-05-15 14:51',
                  'sha256': 'mnb+jeueqm8WVbx8taipzE+yyzQ/rDuGaytCWvOS6NA=',
                  'types': ['network-status-vote-3 1.0'],
                  'size': 10641492
                }, {
                  'path': 'votes-2007-12.tar.xz',
                  'last_published': '2007-12-31 23:00',
                  'first_published': '2007-12-01 00:00',
                  'last_modified': '2012-05-15 14:52',
                  'sha256': 'tAjI4CWqtGpFNWb3DaIvzVugrPnHN2oyKAI1Z6ofjs0=',
                  'types': ['network-status-vote-3 1.0'],
                  'size': 14712136
                }
              ]
            }
          ]
        }, {
          'path': 'snowflakes',
          'files': [
            {
              'path': 'snowflakes-2019-06.tar.xz',
              'last_published': '2019-06-30 21:41',
              'first_published': '2019-06-29 21:41',
              'last_modified': '2019-09-16 10:21',
              'sha256': '6o+UkFo5DuAju8J+w+dcyNEcAzhppueJOrAE4tKpHIw=',
              'types': ['snowflake-stats 1.0'],
              'size': 424
            }, {
              'path': 'snowflakes-2019-07.tar.xz',
              'last_published': '2019-07-31 19:52',
              'first_published': '2019-07-01 21:41',
              'last_modified': '2019-09-16 10:21',
              'sha256': 'cd2eJpugSZuIpuSlQqw8Z0/YFjOuchMekD0uQQH/XMo=',
              'types': ['snowflake-stats 1.0'],
              'size': 3528
            }, {
              'path': 'snowflakes-2019-08.tar.xz',
              'last_published': '2019-08-31 14:06',
              'first_published': '2019-08-01 19:52',
              'last_modified': '2019-09-16 10:21',
              'sha256': '5k6Py4+ENKkcI0s4mpJWzcJ82XQvdl4t6wa8/Y+0sFI=',
              'types': ['snowflake-stats 1.0'],
              'size': 6420
            }
          ]
        }, {
          'path': 'torperf',
          'files': [
            {
              'path': 'torperf-2009-07.tar.xz',
              'last_published': '2009-07-31 23:55',
              'first_published': '2009-07-03 21:35',
              'last_modified': '2012-05-30 07:23',
              'sha256': 'mxi+0MgtNHXZ2wgYH/cre0go8yXn0TpRHJOA863KsWM=',
              'types': ['torperf 1.0'],
              'size': 182712
            }, {
              'path': 'torperf-2009-08.tar.xz',
              'last_published': '2009-08-31 23:55',
              'first_published': '2009-08-01 00:00',
              'last_modified': '2012-05-30 07:23',
              'sha256': '8xyc9zWnKUPoMO4mflyu2v5i2r2JifNNZ7noddfPGV0=',
              'types': ['torperf 1.0'],
              'size': 203236
            }, {
              'path': 'torperf-2009-09.tar.xz',
              'last_published': '2009-09-30 23:55',
              'first_published': '2009-09-01 00:00',
              'last_modified': '2012-05-30 07:23',
              'sha256': 'LCBvAkFgdpAgW71mmrVRNC/4oYKmu6ritc1xCBrQ6+o=',
              'types': ['torperf 1.0'],
              'size': 193832
            }
          ]
        }, {
          'path': 'webstats',
          'files': [
            {
              'path': 'webstats-2015-01.tar',
              'last_published': '2015-01-20 00:00',
              'first_published': '2015-01-04 00:00',
              'last_modified': '2018-03-19 16:07',
              'sha256': 'TJb1iwzRBTyOvPuOL7DoKVUQa/Q5V0zD/7qNIS8QTp0=',
              'size': 30720
            }, {
              'path': 'webstats-2015-02.tar',
              'last_published': '2015-02-12 00:00',
              'first_published': '2015-02-11 00:00',
              'last_modified': '2018-03-19 16:07',
              'sha256': '30uazpNDayxBRe7BEnfCRu8nrquDtoL/1oXV5eaX9xw=',
              'size': 20480
            }, {
              'path': 'webstats-2015-03.tar',
              'last_published': '2015-03-13 00:00',
              'first_published': '2015-03-04 00:00',
              'last_modified': '2018-03-19 16:07',
              'sha256': 'EPj4SrLYpnkfSUAOOfXeYBoE3zWP/VPq+bd8hhnOPKc=',
              'size': 20480
            }
          ]
        }
      ]
    }, {
      'path': 'recent',
      'directories': [
        {
          'path': 'bridge-descriptors',
          'directories': [
            {
              'path': 'extra-infos',
              'files': [
                {
                  'path': '2019-11-27-23-09-00-extra-infos',
                  'last_published': '2019-11-28 01:05',
                  'first_published': '2019-11-27 21:58',
                  'last_modified': '2019-11-27 23:09',
                  'sha256': '9wk9MvCL0Cu1SunJdWsuWXGh0EXe/hsOu03zYLA2BzQ=',
                  'types': ['bridge-extra-info 1.3'],
                  'size': 753174
                }, {
                  'path': '2019-11-28-00-09-00-extra-infos',
                  'last_published': '2019-11-28 00:07',
                  'first_published': '2019-11-27 21:00',
                  'last_modified': '2019-11-28 00:09',
                  'sha256': 'AFM7LdUqT/zJHYsWZBOEEMUCAg1WvEaRExp3aa7mMy0=',
                  'types': ['bridge-extra-info 1.3'],
                  'size': 793414
                }, {
                  'path': '2019-11-28-01-09-00-extra-infos',
                  'last_published': '2019-11-28 01:10',
                  'first_published': '2019-11-28 00:06',
                  'last_modified': '2019-11-28 01:09',
                  'sha256': 'ErLKI17AJHsQfkkckrz/dDkXUF57Olmoe6uAbxQZUYg=',
                  'types': ['bridge-extra-info 1.3'],
                  'size': 616029
                }
              ]
            }, {
              'path': 'statuses',
              'files': [
                {
                  'path': '20191127-221129-BA44A889E64B93FAA2B114E02C2A279A8555C533',
                  'last_published': '2019-11-27 22:11',
                  'first_published': '2019-11-27 22:11',
                  'last_modified': '2019-11-27 23:09',
                  'sha256': 'fBty8+Okn2bEtTkpYm6Flz+j4U/8yHt5IVYl+T8AwAg=',
                  'types': ['bridge-network-status 1.2'],
                  'size': 257731
                }, {
                  'path': '20191127-224129-BA44A889E64B93FAA2B114E02C2A279A8555C533',
                  'last_published': '2019-11-27 22:41',
                  'first_published': '2019-11-27 22:41',
                  'last_modified': '2019-11-27 23:09',
                  'sha256': 'wkaV5zH/THEkYNU10PuOKWTAPjZrg1HMFVlX+nGtc7U=',
                  'types': ['bridge-network-status 1.2'],
                  'size': 257484
                }, {
                  'path': '20191127-231129-BA44A889E64B93FAA2B114E02C2A279A8555C533',
                  'last_published': '2019-11-27 23:11',
                  'first_published': '2019-11-27 23:11',
                  'last_modified': '2019-11-28 00:09',
                  'sha256': '7drOuyxG+xgZ0BMboAwbDkdHEZXiyt8yy1+j3nhGgQM=',
                  'types': ['bridge-network-status 1.2'],
                  'size': 257459
                }
              ]
            }
          ]
        }, {
          'path': 'bridge-pool-assignments',
          'files': [
            {
              'path': '2019-08-22-00-00-21',
              'last_published': '2019-08-22 00:00',
              'first_published': '2019-08-22 00:00',
              'last_modified': '2019-11-28 10:09',
              'sha256': 'UX/6vleSKRBUP4fGnOPjUnpAZtFjkl/N4Tog3+A7KmU=',
              'types': ['bridge-pool-assignment 1.0'],
              'size': 84863
            }, {
              'path': '2019-08-22-00-30-21',
              'last_published': '2019-08-22 00:30',
              'first_published': '2019-08-22 00:30',
              'last_modified': '2019-11-28 10:09',
              'sha256': '8dH8DK5RuxUtDMJUA9JKkz+4vjPWbTK2Aqq4vvd03oM=',
              'types': ['bridge-pool-assignment 1.0'],
              'size': 84363
            }, {
              'path': '2019-08-22-01-00-20',
              'last_published': '2019-08-22 01:00',
              'first_published': '2019-08-22 01:00',
              'last_modified': '2019-11-28 10:09',
              'sha256': '4JLrB0P4p14DrbNOXQTscT2dZESwgaZoszNWEiaYeTs=',
              'types': ['bridge-pool-assignment 1.0'],
              'size': 83912
            }
          ]
        }, {
          'path': 'bridgedb-metrics',
          'files': [
            {
              'path': '2019-09-05-08-51-16-bridgedb-metrics',
              'last_published': '2019-09-05 08:51',
              'first_published': '2019-09-05 08:51',
              'last_modified': '2019-11-28 19:40',
              'sha256': 'gvgAeZ5ttvRmHFUmauZwA4scmCPCOhnBTjan/EPV1fk=',
              'size': 7727
            }, {
              'path': '2019-09-06-08-51-16-bridgedb-metrics',
              'last_published': '2019-09-06 08:51',
              'first_published': '2019-09-06 08:51',
              'last_modified': '2019-11-28 19:40',
              'sha256': 'D/3QDwi7eRlkmGl/sk2uXmqn/6tJ3QLdAdArMt+a9kc=',
              'size': 8134
            }, {
              'path': '2019-09-07-08-51-16-bridgedb-metrics',
              'last_published': '2019-09-07 08:51',
              'first_published': '2019-09-07 08:51',
              'last_modified': '2019-11-28 19:40',
              'sha256': 'bMceCkg/6qFiRL7TKBsfWlQs1MoYVngavRFSDcxa8Gc=',
              'size': 7772
            }
          ]
        }, {
          'path': 'exit-lists',
          'files': [
            {
              'path': '2019-11-27-23-02-00',
              'last_published': '2019-11-27 23:02',
              'first_published': '2019-11-27 23:02',
              'last_modified': '2019-11-27 23:02',
              'sha256': 'aOe9LSWJJ3N8sbembPFH8b027FlK2aixvKOkaDSEyUA=',
              'types': ['tordnsel 1.0'],
              'size': 160234
            }, {
              'path': '2019-11-28-00-02-00',
              'last_published': '2019-11-28 00:02',
              'first_published': '2019-11-28 00:02',
              'last_modified': '2019-11-28 00:02',
              'sha256': 'VuaqrB4wJid7RqHXn+BrL65F+FyKgMzzaj3XNumyOhc=',
              'types': ['tordnsel 1.0'],
              'size': 160234
            }
          ]
        }, {
          'path': 'relay-descriptors',
          'directories': [
            {
              'path': 'bandwidths',
              'files': [
                {
                  'path': '2019-11-27-20-44-46-bandwidth-572936DECB11EE615C0F698D0BB0E43D12F7A8B373F26236DBC4091099D3284A',
                  'last_published': '2019-11-27 20:44',
                  'first_published': '2019-11-27 20:44',
                  'last_modified': '2019-11-27 22:35',
                  'sha256': 'Ystd7EP1ElJ/SSLUAMklGtbhvgO2Qu2+9SIemBLieO8=',
                  'types': ['bandwidth-file 1.0'],
                  'size': 2510298
                }, {
                  'path': '2019-11-27-21-31-40-bandwidth-3A522F869B89A2DDB0A798C3878483A0A3CC1E8F02FDF1C81404A5F742729C29',
                  'last_published': '2019-11-27 21:31',
                  'first_published': '2019-11-27 21:31',
                  'last_modified': '2019-11-27 22:35',
                  'sha256': 'Wu1Fzp0qSXlNavxBAbm3TRj7AE5jGEdwrAYdoAhDMRE=',
                  'types': ['bandwidth-file 1.0'],
                  'size': 2450793
                }, {
                  'path': '2019-11-27-21-32-55-bandwidth-97EC4B3E17125BD9B58CE219FC417BA7B41C84D765711C8841AC75EB08CC5D8F',
                  'last_published': '2019-11-27 21:32',
                  'first_published': '2019-11-27 21:32',
                  'last_modified': '2019-11-27 23:35',
                  'sha256': '8VN/DJqQ0rmhfJvcr+yuwGSbvMDlkRfHyCnS5Y8GUuo=',
                  'types': ['bandwidth-file 1.0'],
                  'size': 2510643
                }
              ]
            }, {
              'path': 'consensuses',
              'files': [
                {
                  'path': '2019-11-27-23-00-00-consensus',
                  'last_published': '2019-11-27 23:00',
                  'first_published': '2019-11-27 23:00',
                  'last_modified': '2019-11-27 23:05',
                  'sha256': 'cGWT19Y0UVE/EUi3ZayacGvJU5t9T6MKaTOrNarAqlI=',
                  'types': ['network-status-consensus-3 1.0'],
                  'size': 2208505
                }, {
                  'path': '2019-11-28-00-00-00-consensus',
                  'last_published': '2019-11-28 00:00',
                  'first_published': '2019-11-28 00:00',
                  'last_modified': '2019-11-28 00:05',
                  'sha256': 'VHwgrdBK3QpD7NQypBPqeFPXUjfFnuSYtmp/36jBUOo=',
                  'types': ['network-status-consensus-3 1.0'],
                  'size': 2198681
                }, {
                  'path': '2019-11-28-01-00-00-consensus',
                  'last_published': '2019-11-28 01:00',
                  'first_published': '2019-11-28 01:00',
                  'last_modified': '2019-11-28 01:05',
                  'sha256': 'cXrIUvqiIybA87NoejHaBlDcN3VsLljGlmt+ku+HU/g=',
                  'types': ['network-status-consensus-3 1.0'],
                  'size': 2195362
                }
              ]
            }, {
              'path': 'extra-infos',
              'files': [
                {
                  'path': '2019-11-27-23-05-00-extra-infos',
                  'last_published': '2019-11-27 23:28',
                  'first_published': '2019-11-27 21:00',
                  'last_modified': '2019-11-27 23:05',
                  'sha256': 'xNzjDxg6iCQFdfShUD4e2oO+SiLxSgVqQp13dXDjwTU=',
                  'types': ['extra-info 1.0'],
                  'size': 1567496
                }, {
                  'path': '2019-11-28-00-05-00-extra-infos',
                  'last_published': '2019-11-28 00:01',
                  'first_published': '2019-11-27 19:04',
                  'last_modified': '2019-11-28 00:05',
                  'sha256': 'YybmmLOJgLf/kUyZ/IXQc5A4m7O8Sx0g6Ccu/G9ADhA=',
                  'types': ['extra-info 1.0'],
                  'size': 1471455
                }, {
                  'path': '2019-11-28-01-05-00-extra-infos',
                  'last_published': '2019-11-28 01:17',
                  'first_published': '2019-11-27 10:31',
                  'last_modified': '2019-11-28 01:05',
                  'sha256': '2nRmT48/8xVctXlhEHgawQVQy4DpcHS2NJHpQ1mZJRs=',
                  'types': ['extra-info 1.0'],
                  'size': 1378360
                }
              ]
            }, {
              'path': 'microdescs',
              'directories': [
                {
                  'path': 'consensus-microdesc',
                  'files': [
                    {
                      'path': '2019-11-27-23-00-00-consensus-microdesc',
                      'last_published': '2019-11-27 23:00',
                      'first_published': '2019-11-27 23:00',
                      'last_modified': '2019-11-27 23:05',
                      'sha256': 'AEiZyuLlIf17aqIp3EOder5EzbSjgWesKaPLR/zRw6Q=',
                      'types': ['network-status-microdesc-consensus-3 1.0'],
                      'size': 2036635
                    }, {
                      'path': '2019-11-28-00-00-00-consensus-microdesc',
                      'last_published': '2019-11-28 00:00',
                      'first_published': '2019-11-28 00:00',
                      'last_modified': '2019-11-28 00:05',
                      'sha256': '5P5AYHwuULmjNjdmubf0O6RYkIy7QAHLaIfv1GAUiYY=',
                      'types': ['network-status-microdesc-consensus-3 1.0'],
                      'size': 2029885
                    }, {
                      'path': '2019-11-28-01-00-00-consensus-microdesc',
                      'last_published': '2019-11-28 01:00',
                      'first_published': '2019-11-28 01:00',
                      'last_modified': '2019-11-28 01:05',
                      'sha256': 'jjqsrEr3kkT7P04BlZmWICrmUxMkUp+vmtNQl93OnJc=',
                      'types': ['network-status-microdesc-consensus-3 1.0'],
                      'size': 2026257
                    }
                  ]
                }, {
                  'path': 'micro',
                  'files': [
                    {
                      'path': '2019-11-27-22-05-00-micro',
                      'last_modified': '2019-11-27 22:05',
                      'sha256': 'cMrDxiUTrotiz80JaPQXEJ7UmNautHI+1tV7Jlvwn6Y=',
                      'types': ['microdescriptor 1.0'],
                      'size': 14940
                    }, {
                      'path': '2019-11-27-23-05-00-micro',
                      'last_modified': '2019-11-27 23:05',
                      'sha256': 'qzQ5EdHwdDNFAx6Ca7DgKdaABVznjmMMl+TNUMsKR1s=',
                      'types': ['microdescriptor 1.0'],
                      'size': 12234
                    }, {
                      'path': '2019-11-28-00-05-00-micro',
                      'last_modified': '2019-11-28 00:05',
                      'sha256': '9mnZR7wYjdQm259cay9YgGzxoGSqdjn1sl3oODEggDA=',
                      'types': ['microdescriptor 1.0'],
                      'size': 14696
                    }
                  ]
                }
              ]
            }, {
              'path': 'server-descriptors',
              'files': [
                {
                  'path': '2019-11-27-23-05-00-server-descriptors',
                  'last_published': '2019-11-27 23:28',
                  'first_published': '2019-11-27 21:00',
                  'last_modified': '2019-11-27 23:05',
                  'sha256': 'HLb5s027ceH0iNag9IzQxR42pSMWreTxtC8xuNyNMs0=',
                  'types': ['server-descriptor 1.0'],
                  'size': 1978883
                }, {
                  'path': '2019-11-28-00-05-00-server-descriptors',
                  'last_published': '2019-11-28 00:01',
                  'first_published': '2019-11-27 19:04',
                  'last_modified': '2019-11-28 00:05',
                  'sha256': '35HKfcpwZpOP6DU/6078dciDIfyt/7rbVfL6qOPphrM=',
                  'types': ['server-descriptor 1.0'],
                  'size': 1780252
                }, {
                  'path': '2019-11-28-01-05-00-server-descriptors',
                  'last_published': '2019-11-28 01:17',
                  'first_published': '2019-11-27 10:31',
                  'last_modified': '2019-11-28 01:05',
                  'sha256': 'gzhTR8EVKPnki8xT0XHcw2WV+BVmWJ6RxQjjhyxZ8Ro=',
                  'types': ['server-descriptor 1.0'],
                  'size': 1737656
                }
              ]
            }, {
              'path': 'votes',
              'files': [
                {
                  'path': '2019-11-27-23-00-00-vote-0232AF901C31A04EE9848595AF9BB7620D4C5B2E-82EBEC114F0D555B5A44C13533235AFC68BE707D',
                  'last_published': '2019-11-27 23:00',
                  'first_published': '2019-11-27 23:00',
                  'last_modified': '2019-11-27 23:05',
                  'sha256': 'uBb0SCyaR+hRrJBoHpcgzDtdKzZD7bsqWVAf4ivYNao=',
                  'types': ['network-status-vote-3 1.0'],
                  'size': 3721766
                }, {
                  'path': '2019-11-27-23-00-00-vote-14C131DFC5C6F93646BE72FA1401C02A8DF2E8B4-1E73049822816A032C719782F7EBA461E1A43055',
                  'last_published': '2019-11-27 23:00',
                  'first_published': '2019-11-27 23:00',
                  'last_modified': '2019-11-27 23:05',
                  'sha256': 'WyUizNcJZIvKfJTc9cwUy1iyvSxfU5gAZGf3dSVQrMA=',
                  'types': ['network-status-vote-3 1.0'],
                  'size': 3396129
                }, {
                  'path': '2019-11-27-23-00-00-vote-23D15D965BC35114467363C165C4F724B64B4F66-7D0503631CE3246ABD7A52BFAA4B416F02DDA5FA',
                  'last_published': '2019-11-27 23:00',
                  'first_published': '2019-11-27 23:00',
                  'last_modified': '2019-11-27 23:05',
                  'sha256': 'CIYCy5yb3FtJSpt8oDcqHUkuSnugtn6TnOvvR5XxGsk=',
                  'types': ['network-status-vote-3 1.0'],
                  'size': 3432263
                }
              ]
            }
          ]
        }, {
          'path': 'snowflakes',
          'files': [
            {
              'path': '2019-11-28-08-24-18-snowflake-stats',
              'last_published': '2019-11-28 08:24',
              'first_published': '2019-11-28 08:24',
              'last_modified': '2019-11-28 08:40',
              'sha256': 'ikyXH8BpDQ03oZUw0P1+WyTLzoqQUma4mQ3ULJl74L4=',
              'types': ['snowflake-stats 1.0'],
              'size': 750
            }, {
              'path': '2019-11-29-08-24-18-snowflake-stats',
              'last_published': '2019-11-29 08:24',
              'first_published': '2019-11-29 08:24',
              'last_modified': '2019-11-29 08:40',
              'sha256': 'J5XTwjE1t/4mc7XLzr1mmYtoizIPH0WUdwNZs041nE0=',
              'types': ['snowflake-stats 1.0'],
              'size': 725
            }, {
              'path': '2019-11-30-08-24-18-snowflake-stats',
              'last_published': '2019-11-30 08:24',
              'first_published': '2019-11-30 08:24',
              'last_modified': '2019-11-30 08:40',
              'sha256': 'LyIeFYoZ+qnsXXZkLWkqXpqZ81eXorecQA6JOpi6kbw=',
              'types': ['snowflake-stats 1.0'],
              'size': 734
            }
          ]
        }, {
          'path': 'torperf',
          'files': [
            {
              'path': 'op-ab-1048576-2019-11-27.tpf',
              'last_published': '2019-11-27 23:59',
              'first_published': '2019-11-27 00:19',
              'last_modified': '2019-11-28 00:01',
              'sha256': 'EIUcAWfl8hXt5Ho4r7UpNptBwJKC5VW+xtXDcsxIftI=',
              'types': ['torperf 1.1'],
              'size': 42012
            }, {
              'path': 'op-ab-1048576-2019-11-28.tpf',
              'last_published': '2019-11-28 23:59',
              'first_published': '2019-11-28 00:24',
              'last_modified': '2019-11-29 00:01',
              'sha256': '88mSSG4Vjl6Ue6TQ3ZggEmUE5N0/OZVnApJjhReegPg=',
              'types': ['torperf 1.1'],
              'size': 39910
            }, {
              'path': 'op-ab-1048576-2019-11-29.tpf',
              'last_published': '2019-11-29 22:44',
              'first_published': '2019-11-29 00:04',
              'last_modified': '2019-11-30 00:01',
              'sha256': 'AdpYLfjx8dbyUgxg/wr/FJh0e/wNAuhffKp9rwdAzuk=',
              'types': ['torperf 1.1'],
              'size': 47405
            }
          ]
        }, {
          'path': 'webstats',
          'files': [
            {
              'path': '2019.www.torproject.org_hetzner-hel1-03.torproject.org_access.log_20191116.xz',
              'last_published': '2019-11-16 00:00',
              'first_published': '2019-11-16 00:00',
              'last_modified': '2019-11-28 19:41',
              'sha256': 'mJdqQBAfEPze/TuhLxBy9//1CFwCvbxHiIwwqptt1ek=',
              'size': 10480
            }, {
              'path': '2019.www.torproject.org_hetzner-hel1-03.torproject.org_access.log_20191117.xz',
              'last_published': '2019-11-17 00:00',
              'first_published': '2019-11-17 00:00',
              'last_modified': '2019-11-30 19:41',
              'sha256': '0vAFfbUWeoDn2kZyxK1a9CDZwTk5/yc9yz9IjEcPolo=',
              'size': 11836
            }, {
              'path': '2019.www.torproject.org_hetzner-hel1-03.torproject.org_access.log_20191118.xz',
              'last_published': '2019-11-18 00:00',
              'first_published': '2019-11-18 00:00',
              'last_modified': '2019-11-30 19:41',
              'sha256': 'CcIuv30SczF0l6Z41d90+ykLobsRuqTfNT9TrfimcKk=',
              'size': 11108
            }
          ]
        }
      ]
    }
  ]
}
