"""SAIL Python bindings examples.

This package contains example scripts demonstrating various features
of the SAIL library through its Python bindings.

Examples:
    01_quickstart.py - Basic image loading and saving
    02_memory_io.py - Working with memory buffers
    03_features_and_options.py - Codec features and save options
    04_numpy_integration.py - NumPy array integration
    05_multiframe.py - Multi-frame image handling
    06_probe.py - Image probing without full loading
    07_codec_info.py - Querying codec information
    08_logging.py - Logging configuration
    09_image_transformations.py - Image transformations
    10_enum_usage.py - Working with enums
    11_advanced_saving.py - Advanced saving options
    12_image_viewer.py - Simple Qt-based image viewer

To run an example:
    python -m sailpy.examples.01_quickstart

Or to find examples location:
    import sailpy.examples
    print(sailpy.examples.__path__)
"""

__all__ = []

