---
myst:
  html_meta:
    keywords: LaTeX, composition, illustrations, graphiques
---

# Comment réaliser des diagrammes à barres ?

## Avec l'extension [PGFPlots](ctanpkg:pgfplots)

L'extension [PGFPlots](ctanpkg:pgfplots) vous permet de dessiner 
des [diagrammes à barres](wpfr:Diagramme_à_barres) (ou diagrammes en bâtons)
et bien d'autres encore. Basée sur [TikZ](ctanpkg:pgf), elle est 
très polyvalente et permet toutes sortes de représentations de données. 
La contrepartie de cette polyvalence est que 
[sa documentation](texdoc:pgfplots) est volumineuse (mais très claire).

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{pgfplots}
  \pgfplotsset{width=7cm}

\begin{document}
\begin{tikzpicture}
  \begin{axis}[
    x tick label style={/pgf/number format/1000 sep=},
    ylabel=Population,
    enlargelimits=0.15,
    legend style={
      at={(0.5,-0.15)},
      anchor=north,
      legend columns=-1
    },
    ybar=5pt,% configures `bar shift'
    bar width=9pt,
    nodes near coords,
    point meta=y *10^-7, % the displayed number
    ]
    \addplot coordinates{
      (1930,50e6) (1940,33e6)(1950,40e6) (1960,50e6) (1970,70e6)
    };

    \addplot coordinates{
      (1930,38e6) (1940,42e6)(1950,43e6) (1960,45e6) (1970,65e6)
    };
    \legend{Lointain,Proche}
  \end{axis}
\end{tikzpicture}
\end{document}
```


## Avec l'extension <ctanpkg:bchart>

Si vos besoins sont très modestes, l'extension <ctanpkg:bchart> peut 
être suffisante. Elle s'appuie elle aussi sur [TikZ](ctanpkg:pgf). 
Elle a pour particularité de ne proposer que des barres horizontales.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{bchart}

\begin{document}
\centering
\begin{bchart}[step=20,max=100]
  \bcbar[text=Alain]{47}
  \bcbar[text=Alex]{83}
  \bcbar[text=Alice]{65}
  \bcxlabel{Production mensuelle de documents}
\end{bchart}
\end{document}
``` 


## Avec l'extension <ctanpkg:pstricks>

Si vous avez l'habitude d'utiliser <ctanpkg:pstricks>, 
les extensions <ctanpkg:pst-bar> et <ctanpkg:bardiag> fournissent
des commandes pour dessiner des diagrammes à barres.

Voici un exemple basé sur la [documentation](texdoc:pst-bar) de l'extension.
Notez que nous utilisons ici le moteur LuaLaTeX pour traiter cet exemple car 
il est directement compatible avec <ctanpkg:pstricks>.

```
%!TEX engine=xelatex
% Un fichier de données créé par le document avec l'environnement filecontents
\begin{filecontents*}[nosearch,overwrite]{test.csv}
Alain, Alex, Alice
1.4, 2, 2.5
1, 2.7, 3.2
\end{filecontents*}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{pst-bar}

\begin{document}
\psset{unit=0.5in}
\centering
\begin{pspicture}(0,-0.5)(3,3)%
  \readpsbardata{\data}{test.csv}%
  \psbarchart[barstyle={red,blue}]{\data}%
\end{pspicture}
\end{document}
```