---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, notes de bas de page, retour à la ligne, 
              footnote, notes l'une après l'autre
---

# Comment placer les notes de bas de page les unes à la suite des autres ?

L'extension <ctanpkg:footmisc> permet d'avoir des notes de bas de page qui s'enchaînent 
sans retour à ligne, en utilisant l'option `para`. En voici un exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[para]{footmisc}

\begin{document}
Donald Knuth\footnote{Mathématicien américain.} a déclaré qu'il ne développe
plus \TeX ; il ne traite désormais plus que la correction des erreurs qui
lui sont remontées\footnote{et ces bugs sont rares!}.
\end{document}
```

Si vous souhaitez plutôt regrouper les notes de bas de page en fin de document, 
consultez la question "[](mettre_les_notes_de_bas_de_page_en_fin_de_document)".